var MunzaCORE = MunzaCORE || {};

(function ($) {

	"use strict";

	MunzaCORE.init = {

		shortcodes: function () {
			var con = $('.wpb-layout-element-button[data-element="contact-form-7"]').clone();
			$('.wpb-layout-element-button[data-element="contact-form-7"]').remove();
			$('.vc_add-element-container .wpb-content-layouts').append(con);

			$('.edit_form_line').each(function () {
				var th = $(this),
					dsc = th.find('.vc_description'),
					txt = dsc.text();
				if (dsc.length && !th.is('.withdesc')) {
					th.addClass('withdesc');
					dsc.remove();
					th.prev().addClass('hasdesc').prepend('<span class="ttips" data-tip="' + txt + '"><i class="stline-alert-diamond"></i></span>');
					th.prev().find('.ttips').tipr();
				}
			});
			$('.count_date').attr('readonly', 'readonly').attr('autocomplete', 'off').datepicker({ dateFormat: 'yy/mm/dd' });
		},

		custom_select: function () {
			$('.select_bxs').each(function () {
				var thP = $(this),
					th = thP.find('.edit_form_line select'),
					act = '';
				if (thP.find('.sel_opts').length == 0) {
					th.before('<ul class="sel_opts"></ul>');
					var opts = th.parent().find('.sel_opts');
					th.find('option').each(function () {
						if (this.selected) {
							opts.append('<li class="active" data-value="' + $(this).val() + '">' + $(this).text() + '</li>');
						} else {
							opts.append('<li data-value="' + $(this).val() + '">' + $(this).text() + '</li>');
						}

					});

					opts.find('li').click(function () {
						th.val($(this).data('value')).trigger('change');
						opts.find('li').removeClass('active');
						$(this).addClass('active');
					});
				}

			});
		},

		cats_select: function () {
			$('.multichck_wrap').each(function () {
				var th = $(this),
					textbox = th.next('.multi_sel'),
					checkboxes = th.find('.multicheck');

				for (var i = 0; i < checkboxes.length; i++) {
					var checkbox = checkboxes[i],
						vl = textbox.attr('value'),
						substr = vl.split(',');

					for (var x = 0; x < substr.length; ++x) {
						$('.multicheck[value="' + substr[x] + '"]').attr('checked', 'checked');
					}

					checkbox.onclick = (function (chk) {
						return function () {
							var value = "";
							for (var j = 0; j < checkboxes.length; j++) {
								if (checkboxes[j].checked) {
									if (value === "") {
										value += checkboxes[j].value;
									} else {
										value += "," + checkboxes[j].value;
									}
								}
							}
							textbox.attr('value', value);
						}
					})(checkbox);
				}
			});
		},

	};

	/* ================ ajaxComplete Functions. ================ */
	$(document).unbind('ajaxComplete').ajaxComplete(function () {
		MunzaCORE.init.shortcodes();
		MunzaCORE.init.custom_select();
		MunzaCORE.init.cats_select();
	});

	// VC Params Functions..
	vc.atts.img_map_mark = {
		init: function (param, $field) {
			if (!$field.prev().data('vc-shortcode-param-name') || !$field.prev().data('vc-shortcode-param-name') == 'image') {
				return false;
			}

			var src = '',
				mainImg = $field.prev().find('input[name="image"]'),
				mainImage = function () {
					if ($field.prev().find('img').length > 0) {
						var id = $field.find('.cp_map_marker').attr('id');
						src = $field.prev().find('img').attr('src').replace('-150x150', '', src);
						if ($field.find('img.mark_img').length > 0) {
							$field.find('img.mark_img').attr('src', src);
						}

						$field.find('.cp-image-map-holder').hotspot({
							mode: 'admin',
							LS_Variable: '#' + id,

						});
					}
				};

			mainImage();
			mainImg.on('change', function () {
				mainImage();
			});
		},
	};

	vc.atts.it_video_bg = {
		init: function (param, $field) {

			var mainVid = $field.find('.video_up_txt'),
				mainVidinpField = function () {

					if ($field.find('.video_up_txt').val() != '') {
						$field.find('.remove-val').show(0);
					}

					$field.find('a.upload_button').on('click', function (e) {
						e.preventDefault();
						wp.media.editor.send.attachment = function (props, attachment) {
							$field.find('.video_up_txt').val(attachment.id);

							if ($field.find('.vid_wrap').length == 0) {
								$field.find('.upload_button').before('<div class="vid_wrap"><video><source src="' + attachment.url + '"></video><a href="#" class="remove-val" style="display:inline-block"></a></div>');
							}
							$field.find('.remove-val').show(0).css('display', 'inline-block');
							$field.find('.remove-val').on('click', function (e) {
								e.preventDefault();
								$field.parent().find('.video_up_txt').attr('value', '');
								$(this).hide();
								$(this).parent().find('video').remove();
								$(this).parent().remove();
							});

						}
						wp.media.editor.open(this);
						return false;
					});

					$field.find('.remove-val').on('click', function (e) {
						e.preventDefault();
						$field.parent().find('.video_up_txt').attr('value', '');
						$(this).parent().remove();
					});

				}

			mainVidinpField();
			mainVid.on('change', function () {
				mainVidinpField();
			});

		},
	};

	vc.atts.gradientpicker = {
		init: function (param, $field) {
			var grad = $field.find('.gradpic');
			$field.find('.grad_link').click(function (e) {
				e.preventDefault();
				if (grad.is(':hidden')) {
					grad.fadeIn();
				} else {
					grad.fadeOut();
				}
			});
			$field.find('.cls_grad').click(function (e) {
				e.preventDefault();
				grad.fadeOut();
			});
			if ($field.find('.gradientPicker-preview').length === 0) {

				var st = $field.find('.grad_vl').attr('data-vl'),
					txtbox = $field.find('.grad_vl'),
					gtype = st.substr(0, st.indexOf('(')),
					tp = (gtype == '-webkit-radial-gradient') ? 'radial' : 'linear',
					gposition, i, arr = [];

				st = st.substring(st.indexOf("(") + 1).split(';')[0].slice(0, -1);


				if (tp == 'linear') {
					var dir = st.substr(0, st.indexOf(',')).trim();
					gposition = (dir != '') ? dir : "left";
				}

				st = (gtype == '-webkit-radial-gradient') ? st : st.substring(st.indexOf(",") + 1);



				st = st.replace(/ #/g, '#');



				if (st.indexOf('rgb') > 0) {
					arr = st.split(', rgb').join(",rgb");
				} else if (st.indexOf('rgba') > 0) {
					arr = st.split(', rgba').join(",rgba");
				} else {
					arr = st.split(',');
					if (gtype == '-webkit-radial-gradient') {
						arr.splice(0, 2);
					}
				}

				$field.find('select.gtype').val(tp);
				if (tp == 'linear') {
					$field.find('select.gposition').val(gposition);
				}

				//arr = arr.replace(/\#/g,'"#').replace(/\%/g,'%"').replace(/rgb/g,'"rgb');

				if (st == '') {
					arr = ["#b400ff 0%", "#3f0a9e 100%"];
					gposition = 'left';
					tp = 'linear';
				}

				$field.find('.gradpic').gradientPicker({
					change: function (points, styles) {
						for (i = 0; i < styles.length; ++i) {
							txtbox.attr("value", styles[i]);
						}
					},
					fillDirection: gposition,
					type: tp,
					controlPoints: arr
				});

			}

		},
	};

	vc.atts.it_icon_pop = {
		init: function (param, $field) {

			var mainVid = $field.find('.icon_cust'),
				mainVidinpField = function () {

					if ($field.find('.icon_cust').val() != '') {
						$field.find('.icon-remove').show(0);
						$field.find('.ico').fadeIn();
						$field.find('.ico').addClass(mainVid.attr('value'));
						$field.find('.btn_icon').text('Change Icon');
					}

					var themeurl = $('.it_add_icon').attr('data-theme-url'),
						iconsurl = themeurl + '/it-framework/includes/fields/icons/',
						icsArr = ['outlinefont', 'streamline', 'fontawesome'];

					$field.find('a.btn_icon').on('click', function (e) {
						e.preventDefault();

						var th = $(this);
						$.each(icsArr, function (index, value) {
							var ic = iconsurl + value;

							$.getJSON(ic + '.json', function (data) {

								var output = '';

								$.each(data.items, function (key, val) {
									if (value == 'fontawesome') {
										output += '<a href="#" data-icon="fa ' + val + '"><i class="fa ' + val + '"></i></a>';
									} else {
										output += '<a href="#" data-icon="' + val + '"><i class="' + val + '"></i></a>';
									}
								});

								$('.icons_set .' + value).html(output);
								$('#boo-overlay').fadeIn(200);
								$('.it_add_icon').fadeIn(300);
								$('.btn_icon').removeClass('clicked');
								th.addClass('clicked');
								$('.icons_set a').each(function () {
									$(this).on('click', function (e) {
										e.preventDefault();
										var icon = $(this).find('i').attr('class'),
											ht = $(this).find('i').html();
										$('.btn_icon.clicked').next('.icon_cust').val(icon);
										$('.btn_icon.clicked').prev('.ico').removeAttr('class').addClass('ico ' + icon);
										$('#boo-overlay,.it_add_icon').fadeOut(400);
										th.parent().find('.icon-remove').fadeIn().css('display', 'inline-block');
										th.parent().find('.ico').fadeIn().html(ht);
										th.text('Change Icon');
										th.removeClass('clicked');
										return false;
									});
								});
							});
						});

						var dw = parseInt($(window).width()) / 2,
							mw = parseInt($('.it_add_icon').width()) / 2,
							dh = parseInt($(window).height()) / 2,
							mh = parseInt($('.it_add_icon').height()) / 2,
							lft = dw - mw + 'px',
							tp = dh - mh + 'px';
						$('.it_add_icon').css({ left: lft, top: tp });

						var iconSearch = $('.iconSearch'),
							iconLoad = $('.icons_set > div');
						iconSearch.keyup(function () {
							var $this = $(this),
								val = $this.val(),
								list_icon = iconLoad.find('a');
							list_icon.each(function () {
								var $ico = $(this);
								if ($ico.data('icon').search(new RegExp(val, "i")) < 0) {
									$ico.hide();
								} else {
									$ico.show();
								}
							});
						});

					});

					$field.find('.icon-remove').on('click', function (e) {
						e.preventDefault();
						$field.find('.icon_cust').attr('value', '');
						$field.find('.ico').removeAttr('class').addClass('ico');
						$field.find('.ico').fadeOut(200);
						$('#boo-overlay,.it_add_icon').fadeOut(400);
						$field.find('.btn_icon').html('<i class="stline-add"></i> Add Icon');
						$(this).fadeOut();
					});

				}

			mainVidinpField();
			mainVid.on('change', function () {
				mainVidinpField();
			});

		},
	};

	vc.atts.it_google_fonts = {
		init: function (param, $field) {

			var mainFont = $field.find('.font-hid'),
				themeurl = $('.themeURI').text(),
				iconsurl = themeurl + '/it-framework/assets/fonts/fonts.json';

			$.getJSON(iconsurl, function (data) {

				var output = '<option value="">-- Select Font Family --</option>';

				$.each(data.items, function (key, val) {
					output += '<option value="' + val.family + '">' + val.family + '</option>';
				});

				$field.find('.fontSel').html(output);

				var sel = $field.find('.fontSel'),
					val = $field.find('.fontSel').val(),
					txt = $field.find('.font-hid'),
					old = txt.attr('value');

				if (old != '') {
					$("option[value='" + old + "']", sel).attr('selected', 'selected');
					$field.next('.gfonts').append("<link rel='stylesheet' href='//fonts.googleapis.com/css?family=" + old + ":100,200,300,400,500,600,700,900&#038;subset=latin,latin-ext' type='text/css' media='all' />");
					$field.next('.gfonts').css('font-family', old);
				}

				sel.on('change', function () {
					val = sel.val();
					txt.val(val);
					if (val != '') {
						$field.next('.gfonts').append("<link rel='stylesheet' href='//fonts.googleapis.com/css?family=" + val + ":100,200,300,400,500,600,700,900&#038;subset=latin,latin-ext' type='text/css' media='all' />");
						$field.next('.gfonts').css('font-family', val);
					}
				});

			});

		}

	};

})(window.jQuery);