<?php
return array(
    "name"              => esc_html__("Animated Letters", 'munza'),
    "base"              => "it_letters",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-font-size',
    "params"            => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Letters Animation", 'munza'),
            "param_name"        => "in_anims",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "value"     => array(
                esc_html__( "Bounce Up", 'munza' )             => "fx1",
                esc_html__( "Slide From Right", 'munza' )      => "fx2",
                esc_html__( "Fade Up Down", 'munza' )          => "fx3",
                esc_html__( "Rotate Up Down", 'munza' )        => "fx4",
                esc_html__( "Slide Down Rotate", 'munza' )     => "fx5",
                esc_html__( "Fast Up Down", 'munza' )          => "fx6",
                esc_html__( "Swipe Up", 'munza' )              => "fx7",
                esc_html__( "Swipe Down", 'munza' )            => "fx8",
                esc_html__( "Small Rotate", 'munza' )          => "fx9",
                esc_html__( "Rotate Left", 'munza' )           => "fx10",
                esc_html__( "Flip Left", 'munza' )             => "fx11",
                esc_html__( "Swing Left", 'munza' )            => "fx12",
                esc_html__( "Fade Up", 'munza' )               => "fx13",
                esc_html__( "Wave To Top", 'munza' )           => "fx14",
                esc_html__( "Rotate Letter", 'munza' )         => "fx15",
                esc_html__( "Fall Short From Top", 'munza' )   => "fx16",
                esc_html__( "Colored Background", 'munza' )    => "fx17",
                esc_html__( "Fall Long From Top", 'munza' )    => "fx18",
            ),  
         ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Align', 'munza' ),
            'param_name'        => 'let_align',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-6',
            'value'     => array(
                esc_html__( 'Left', 'munza' )      => '',
                esc_html__( 'Center', 'munza' )    => 'center',
                esc_html__( 'Right', 'munza' )     => 'right',
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"          => "textfield",
            "heading"       => esc_html__("Extra class name", "munza"),
            "param_name"    => "el_class",
            "description"   => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),
        array(
            'type'                  => 'param_group',
            'heading'               => esc_html__('Content', 'munza'),
            'param_name'            => 'letters_txts',
            'value'     => urlencode( json_encode( array(
                array(
                    'letters_txt'   => 'Unlimited Features and Availabilities.',
                    'lett_color'    => ''
                ),
                array(
                    'letters_txt'   => 'With our theme you will build the future.',
                    'lett_color'    => ''
                ),
            ) ) ),
            'params'    => array(
                array(
                    'type'          => 'textfield',
                    'heading'       => esc_html__( 'Label', 'munza' ),
                    'param_name'    => 'letters_txt',
                    'description'   => esc_html__( 'Enter text used as animated letters.', 'munza' ),
                    'admin_label'   => true,
                ),array(
                    "type"          => "colorpicker",
                    "heading"       => esc_html__("Color", "munza"),
                    "param_name"    => "lett_color",
                )
            ),
            'group'                 => 'Content',
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "tag",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'group'             => 'Typography',
            "value"             => array(
                'H1' => 'h1',
                'H2' => 'h2',
                'H3' => 'h3',
                'H4' => 'h4',
                'H5' => 'h5',
                'H6' => 'h6',
            ),
            "std"  => 'h3'
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'family',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => 'Typography',
        ),array(
            'type'              => 'label',
            'heading'           => 'Grumpy wizards make toxic brew for the evil Queen and Jack.',
            'param_name'        => 'gfont',
            'group'             => 'Typography',
            'edit_field_class'  => 'gfonts',
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'size',
            'group'             => 'Typography',
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => 'Typography',
            'value'             => array(
                esc_html__( '-- Select --', 'munza' ) => '',
                esc_html__( 'normal', 'munza' )    => 'normal',
                esc_html__( 'bold', 'munza' )      => 'bold',
                esc_html__( 'lighter', 'munza' )   => 'lighter',
                esc_html__( 'bolder', 'munza' )    => 'bolder',
                '100'                              => '100',
                '200'                              => '200',
                '300'                              => '300',
                '400'                              => '400',
                '500'                              => '500',
                '600'                              => '600',
                '700'                              => '700',
                '800'                              => '800',
                '900'                              => '900',
                esc_html__( 'inherit', 'munza' )   => 'inherit'
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Letter Spacing (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => 'Typography',
            "param_name"        => "lett_spacing",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Line Height (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => 'Typography',
            "param_name"        => "let_lin_height",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Font Style', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "f_st",
            'group'             => 'Typography',
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<i>Italic</i>', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'let_italic',
            'group'             => 'Typography',
            'value'             => array(
                '' => '1',
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<u>Underline</u>', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'let_underline',
            'group'             => 'Typography',
            'value'             => array(
                '' => '1',
            ),
        ),
    )
);