<?php
return array(
    "name"              => esc_html__("Animated Text", 'munza'),
    "base"              => "it_anim_text",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-scale-horizontal',
    "params"    => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Text Animation",'munza'),
            "param_name"        => "in_anims",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value"     => array(
                esc_html__( "Type", 'munza' )          => "letters type",
                esc_html__( "Loading Bar", 'munza' )   => "loading-bar",
                esc_html__( "Slide", 'munza' )         => "slide",
                esc_html__( "Clip", 'munza' )          => "clip is-full-width",
                esc_html__( "Zoom", 'munza' )          => "zoom",
                esc_html__( "Push", 'munza' )          => "push",
            ),  
         ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Text Align', 'munza' ),
            'param_name'        => 'text_align',
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            'value'     => array(
                esc_html__( 'Left', 'munza' )      => '',
                esc_html__( 'Center', 'munza' )    => 'center',
                esc_html__( 'Right', 'munza' )     => 'right',
            ),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "main_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"          => "textfield",
            "heading"       => esc_html__("Extra class name", "munza"),
            "param_name"    => "el_class",
            "description"   => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),
        array(
            'type'          => 'textfield',
            'heading'       => esc_html__( 'Text Before', 'munza' ),
            'param_name'    => 'txt_before',
            'group'         => 'Content',
            'value'         => 'Our theme comes with '
        ),
        array(
            'type'          => 'param_group',
            'heading'       => esc_html__('Content', 'munza'),
            'param_name'    => 'text_txts',
            'params'    => array(
                array(
                    'type'          => 'textfield',
                    'heading'       => esc_html__( 'Label', 'munza' ),
                    'param_name'    => 'text_txt',
                    'description'   => esc_html__( 'Enter text used as animated letters.', 'munza' ),
                    'admin_label'   => true,
                ),array(
                    "type"              => "colorpicker",
                    "heading"           => esc_html__("Color", "munza"),
                    "param_name"        => "text_color",
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                ),array(
                    "type"              => "colorpicker",
                    "heading"           => esc_html__("Background Color", "munza"),
                    "param_name"        => "text_bg_color",
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                )
            ),
            'value' => urlencode( 
                json_encode( 
                    array(
                        array(
                            'text_txt'      => 'Elegant',
                            'text_color'    => '#b400ff',
                            'text_bg_color' => ''
                        ),
                        array(
                            'text_txt'      => 'Awesome',
                            'text_color'    => '#f00',
                            'text_bg_color' => ''
                        ),
                        array(
                            'text_txt'      => 'Great',
                            'text_color'    => '#00f',
                            'text_bg_color' => ''
                        ),
                    )
                ) 
            ),
            'group'     => 'Content',
        ),
        array(
            'type'          => 'textfield',
            'heading'       => esc_html__( 'Text After', 'munza' ),
            'param_name'    => 'txt_after',
            'group'         => 'Content',
            'value'         => ' Theme Options!'
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'param_name'        => 'txt_size',
            'group'             => 'Content',
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'con_family',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => 'Content',
        ),
        array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
            'param_name'        => 'gdfont',
            'group'             => 'Content',
            'edit_field_class'  => 'gfonts',
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "tag",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'group'             => 'Typography',
            "value" => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"  => 'h3'
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'family',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => 'Typography',
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
            'param_name'        => 'gfont',
            'group'             => 'Typography',
            'edit_field_class'  => 'gfonts',
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'size',
            'group'             => 'Typography',
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => 'Typography',
            'value'     => array(
                esc_html__( '-- Select --', 'munza' )   => '',
                esc_html__( 'normal', 'munza' )         => 'normal',
                esc_html__( 'bold', 'munza' )           => 'bold',
                esc_html__( 'lighter', 'munza' )        => 'lighter',
                esc_html__( 'bolder', 'munza' )         => 'bolder',
                '100'                                   => '100',
                '200'                                   => '200',
                '300'                                   => '300',
                '400'                                   => '400',
                '500'                                   => '500',
                '600'                                   => '600',
                '700'                                   => '700',
                '800'                                   => '800',
                '900'                                   => '900',
                esc_html__( 'inherit', 'munza' )        => 'inherit'
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Letter Spacing (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => 'Typography',
            "param_name"        => "text_spacing",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Line Height (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => 'Typography',
            "param_name"        => "text_lin_height",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Font Style', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "f_st",
            'group'             => 'Typography',
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<i>Italic</i>', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'text_italic',
            'group'             => 'Typography',
            'value'     => array(
                '' => '1',
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<u>Underline</u>', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'text_underline',
            'group'             => 'Typography',
            'value'     => array(
                '' => '1',
            ),
        ),
    )
);