<?php
return array(
    "name"          => esc_html__("Blog Posts", "munza"),
    "base"          => "it_blog",
    'category'      => esc_html__( 'Munza Shortcodes', 'munza' ),
    'icon'          => 'no-bg stline-book-close',
    'description'   => esc_html__( 'Add Blog Posts To Page', 'munza' ),
    "params" => array(
        array(
            "type"              => "it_multiselect",
            "heading"           => esc_html__("Category",'munza'),
            "param_name"        => "it_category",
            "value"             => it_dropdown_cats(),
            "description"       => esc_html__("type the post category.",'munza')
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Execlude Posts",'munza'),
            "param_name"        => "posts_exec",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "description"       => esc_html__("Enter post ID to be execluded (separate each id with comma).",'munza')
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Blog Style",'munza'),
            "param_name"        => "blog_style",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-8',
            "value"             => array(
                esc_html__( 'Large Image','munza')   => 'large-image',
                esc_html__( 'Side Image','munza')    => 'small-image',
                esc_html__( 'Blog Grid','munza')     => 'grid',
                esc_html__( 'Blog Masonry','munza')  => 'masonry',
            ),
            "description"       => esc_html__("Select the Blog Style.",'munza'),
            "std"               => 'lg-image'
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Max. Number of words", "munza"),
            "param_name"        => "max_words",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
            'value'             => '40',
            "description"       => esc_html__("Enter -1 to disable this.", "munza"),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Coulmns",'munza'),
            "param_name"        => "blog_cols",
            "value" => array(
                esc_html__( '2 Columns','munza') => '6',
                esc_html__( '3 Columns','munza') => '4',
                esc_html__( '4 Columns','munza') => '3',
            ),
            'dependency'        => array(
                'element'   => 'blog_style',
                'value'     => array('grid','masonry')
            ),                              
            "description"       => esc_html__("select how many coulmns.",'munza'),
            "std"               => '4'
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Image Size",'munza'),
            "param_name"        => "img_size",    
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value" => array(
                esc_html__( 'Thumbnail - 150x150','munza')           => 'thumbnail',
                esc_html__( 'Medium - 400x380','munza')              => 'blog-small-image',
                esc_html__( 'Large - 1024x1024','munza')             => 'large',
                esc_html__( 'Blog Large Image - 1170x470','munza')   => 'blog-large-image',
                esc_html__( 'Original Size','munza')                 => 'full'
            ),                           
            "description"       => esc_html__("select the image size.",'munza'),
            "std"               => 'large'
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Posts Per Page",'munza'),
            "param_name"        => "posts_per_page",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "std"               => '10',
            "description"       => esc_html__("Number of posts shown per page.",'munza')
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Pager Type",'munza'),
            "param_name"        => "pager_type",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( 'Numeric','munza')       => '1',
                esc_html__( 'Older - Newer','munza') => '2',
                esc_html__( 'Load More','munza')     => '3'
            ),                           
            "description"       => esc_html__("select the pager type.",'munza'),
            "std"               => '1'
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Load More Text",'munza'),
            "param_name"        => "load_txt",
            'dependency'        => array(
                'element'   => 'pager_type',
                'value'     => '3'
            ),                              
            "description"       => esc_html__("Text to be shown on load more button.",'munza'),
            "std"               => 'Load More'
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Pager Position",'munza'),
            "param_name"        => "pg_pos",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "value"             => array(
                esc_html__( 'Center','munza') => 'centered',
                esc_html__( 'Left','munza')   => 'left',
                esc_html__( 'Right','munza')  => 'right',
            ),
            'dependency'        => array(
                'element'   => 'pager_type',
                'value'     => array('1')
            ),                              
            "description"       => esc_html__("select Pager Position.",'munza'),
            "std"               => 'centered'
         ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Post Media', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_media',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post Media.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Date', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_date',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post date.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Title', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_title',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post title.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Author', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_auth',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post Author.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Post Meta', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_meta',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post meta.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Content', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_except',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show post excerpt.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Social Share', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_socials',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
            "description"       => esc_html__("Show Social Sharing icons.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Read More', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'show_more',
            'value'             => array(
                '' => '1',
            ),
            "description"       => esc_html__("Show Read more button.",'munza'),
        ),array(
            "type"          => "textfield",
            "heading"       => esc_html__("Read More Text",'munza'),
            "param_name"    => "mor_txt",
            "std"           => "Read More", 
            'dependency'    => array(
                'element'   => 'show_more', 
                'not_empty' => true
            ),
        ),array(
            "type"          => "textfield",
            "heading"       => esc_html__("Extra class name", "munza"),
            "param_name"    => "el_class",
            "description"   => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),
    )
);
    