<?php
return array(
    "name"              => esc_html__("Button", "munza"),
    "base"              => "it_btn",
    'category'          => esc_html__( 'Munza Shortcodes', "munza" ),
    'description'       => esc_html__( 'Eye catching button', "munza" ),
    "content_element"   => true,
    'icon'              => 'no-bg fa fa-bold',
    "params"            => array(
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Button Size', "munza" ),
            'param_name'        => 'btn_size',
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'std'               => 'btn-md',
            'value'             => array(
                  esc_html__( 'Small', 'munza' )      => 'btn-sm',
                  esc_html__( 'Medium', 'munza' )     => 'btn-md',
                  esc_html__( 'Large', 'munza' )      => 'btn-lg',
                  esc_html__( 'X-Large', 'munza' )    => 'btn-xl',
                  esc_html__( 'Custom', 'munza' )     => 'custom',
            ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Button Shape', "munza" ),
            'param_name'        => 'btn_shape',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'value'             => array(
                  esc_html__( 'Square', 'munza' )     => '',
                  esc_html__( 'Rounded', 'munza' )    => 'rounded',
                  esc_html__( 'Round', 'munza' )      => 'round',
            ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => __( 'Hover Animation', "munza" ),
            'param_name'        => 'btn_anim',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'value'             => array(
                  esc_html__( 'None', 'munza' )        => '',
                  esc_html__( 'Scale Out', 'munza' )   => 'animate1',
                  esc_html__( 'Scale In', 'munza' )    => 'animate2',
                  esc_html__( 'Fall Down', 'munza' )   => 'animate3',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Add Icon', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'use_icon',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'size',
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Letter Spacing (px)', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'letter_spacing',
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', "munza" ),
            'param_name'        => 'font_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            'value'             => array(
                esc_html__( '-- Select --','munza')  => '',
                esc_html__( 'normal','munza')        => 'normal',
                esc_html__( 'bold','munza')          => 'bold',
                esc_html__( 'lighter','munza')       => 'lighter',
                esc_html__( 'bolder','munza')        => 'bolder',
                '100'           => '100',
                '200'           => '200',
                '300'           => '300',
                '400'           => '400',
                '500'           => '500',
                '600'           => '600',
                '700'           => '700',
                '800'           => '800',
                '900'           => '900',
                esc_html__( 'inherit','munza')       => 'inherit'
            ),
        ),array(
            "type"              => "label",
            "heading"           => 'Padding (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "mr_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "padd_left",
        ),array(
            "type"              => "label",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            'dependency'        => array( 'element' => 'btn_size','value' => 'custom' ),
            "param_name"        => "mr_lblss",
        ),array(
            "type"              => "vc_link",
            "heading"           => "Link",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "param_name"        => "link",  
        ),
        array(
            "type"          => "textarea_html",
            "heading"       => esc_html__( "Text",'munza'),
            "param_name"    => "content",
            "std"           => "BUTTON TEXT",
        ),
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background Type', "munza" ),
            'param_name'        => 'bg_main',
            'edit_field_class'  => 'select_bxs lg-items vc_column vc_col-xs-8',
            'value'             => array(
                  esc_html__( 'Color', 'munza' )      => 'color',
                  esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', "munza" ),
            'param_name'        => 'idl_shad',
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', "munza" ),
            'param_name'        => 'bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "std"               => "#b400ff",
            'dependency'        => array('element' => 'bg_main','value' => array('color'),),
        ),
        array(
            'type'              => 'gradientpicker',
            'heading'           => esc_html__( 'Gradient', "munza" ),
            'param_name'        => 'bg_grad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array('element'   => 'bg_main','value' => 'gradient',),
        ),
        array(
            "type"              => "label",
            "heading"           => esc_html__( 'Shadow Properties (px)','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad2",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad3",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad4",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "shd_color",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),
        array(
            "type"              => "label",
            "heading"           => esc_html__( 'Border Width (px)','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "bord_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "param_name"        => "bord_bottom",
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_left",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "border_color",
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( "None",'munza')    => "none",
                esc_html__( "Solid",'munza')   => "solid",
                esc_html__( "Dashed",'munza')  => "dashed",
                esc_html__( "Dotted",'munza')  => "dotted",
                esc_html__( "Double",'munza')  => "double",
            ),
        ),array(
            "type"              => "label",
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input',
            "param_name"        => "bord_lbl2",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "hover_color",
            "group"             => esc_html__( "Hover",'munza')
        ),
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', "munza" ),
            'param_name'        => 'hover_bg_main',
            'edit_field_class'  => 'select_bxs lg-items vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Hover','munza'),
            'value'             => array(
                  esc_html__( 'Color', 'munza' )      => 'color',
                  esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),    
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', "munza" ),
            'param_name'        => 'hover_shad',
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Hover','munza'), 
            'value'             => array(
                '' => '1',
            )
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', "munza" ),
            'param_name'        => 'hover_bg_color',
            'group'             => esc_html__( 'Hover','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array('element' => 'hover_bg_main','value' => array('color')),
        ),
        array(
            'type'              => 'gradientpicker',
            'heading'           => esc_html__( 'Gradient', "munza" ),
            'param_name'        => 'hover_bg_grad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Hover','munza'),
            'dependency'        => array('element' => 'hover_bg_main','value' => 'gradient'),
        ),
        array(
            "type"              => "label",
            "heading"           => esc_html__( 'Shadow Properties (px)','munza'),
            "group"             => esc_html__( "Hover",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd1",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd2",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd3",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd4",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "hover_shd_color",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
            "group"             => esc_html__( "Hover",'munza')
        ),
        array(
            "type"              => "label",
            "heading"           => esc_html__( 'Border Width (px)','munza'),
            "group"             => esc_html__( "Hover",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "bord_hov_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Hover",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_left",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "hover_border_color",
            "group"             => esc_html__( "Hover",'munza')
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "hover_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Hover",'munza'), 
            "value"             => array(
                esc_html__( "None",'munza')     => "none",
                esc_html__( "Solid",'munza')    => "solid",
                esc_html__( "Dashed",'munza')   => "dashed",
                esc_html__( "Dotted",'munza')   => "dotted",
                esc_html__( "Double",'munza')   => "double",
            ),
        ),
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            "group"             => esc_html__( 'Icon','munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Icon Position","munza"),
            "param_name"        => "icon_align",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__("Icon" ,'munza'), 
            "value"             => array(
                esc_html__( "Left",'munza')    => "",
                esc_html__( "Right",'munza')   => "right",
            ),
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (PX)", "munza"),
            "group"             => esc_html__( "Icon",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "icon_size",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Padding (PX)", "munza"),
            "group"             => esc_html__( "Icon",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "icon_padd",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius (PX)", "munza"),
            "group"             => esc_html__( "Icon",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "icon_radius",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color","munza"),
            "param_name"        => "icon_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color","munza"),
            "param_name"        => "icon_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            "param_name"        => "icon_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color","munza"),
            "param_name"        => "icon_color_hover",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color","munza"),
            "param_name"        => "icon_bg_hover",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover border Color","munza"),
            "param_name"        => "icon_border_hover",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza')
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Element ID", "munza"),
            "param_name"        => "el_id",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "description"       => esc_html__("Enter element ID (Note: make sure it is unique and valid according to w3c specification).", "munza"),
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),
    )
);
    
