<?php
return array(
    "name"          => esc_html__("Counter", "munza"),
    "base"          => "it_counter",
    'category'      => esc_html__( 'Munza Shortcodes', "munza" ),
    'description'   => esc_html__( 'animated numbers changes in counter style with icons', "munza" ),
    'icon'          => 'no-bg stline-font-expand-horizontal',
    "params"        => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Box Shape",'munza'),
            "param_name"        => "counter_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( "Square",'munza') => "square",
                esc_html__( "Rounded",'munza') => "rounded",
                esc_html__( "Round",'munza') => "round",
            )
         ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Alignment', "munza" ),
            'param_name'        => 'counter_align',
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            'value'             => array(
                esc_html__( 'Center','munza') => 'text-center',
                esc_html__( 'Left','munza') => 'text-left',
                esc_html__( 'Right','munza') => 'text-right',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', "munza" ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1'
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "bx_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            "param_name"        => "bx_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (px)",'munza'),
            "param_name"        => "bx_border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "bx_border_style",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => array(
                esc_html__( "None",'munza')  => '',
                esc_html__( "Solid",'munza') => "solid",
                esc_html__( "Dashed",'munza') => "dashed",
                esc_html__( "Dotted",'munza') => "dotted",
                esc_html__( "Double",'munza') => "double",
            ),
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Hover Styling",'munza'),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hover_lbl",
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "bx_hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            "param_name"        => "bx_hover_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-8',
         ),
         it_animation(),
         it_animation_delay(),
         it_animation_duration(),
         array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Title",'munza'),
            "param_name"        => "item_title",  
            'group'             => esc_html__( 'Content','munza')
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Title Color",'munza'),
            "param_name"        => "title_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content','munza')
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "title_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content','munza')
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "title_size",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content','munza')
         ),
         array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', "munza" ),
            'param_name'        => 'title_font_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content','munza'),
            'value'             => array(
                esc_html__( '-- Select --','munza') => '',
                esc_html__( 'normal','munza') => 'normal',
                esc_html__( 'bold','munza') => 'bold',
                esc_html__( 'lighter','munza') => 'lighter',
                esc_html__( 'bolder','munza') => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit','munza') => 'inherit'
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Hover Styling",'munza'),
            "group"             => esc_html__( "Content",'munza'),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hover_lbl2",
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Title Color",'munza'),
            "param_name"        => "title_hove_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Content','munza')
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Title Background Color",'munza'),
            "param_name"        => "title_hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            'group'             => esc_html__( 'Content','munza')
         ),array(
            'type'              => 'textarea_html',
            'heading'           => esc_html__( 'Content', "munza" ),
            'param_name'        => 'content',
            'admin_label'       => true,
            'group'             => esc_html__( 'Content','munza')
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color",'munza'),
            "param_name"        => "content_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Content','munza')
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Start After",'munza'),
            "param_name"        => "item_timer",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value"             => '1000',
            "description"       => esc_html__("time in ms Ex:(1000).",'munza'),
            'group'             => esc_html__( 'Number','munza')
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("From",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "init_value",
            "value"             => '0',
            'group'             => esc_html__( 'Number','munza')
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("To",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value"             => '1000',
            "param_name"        => "item_value",
            'group'             => esc_html__( 'Number','munza')
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Text Before Number",'munza'),
            "param_name"        => "item_before",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "group"             => esc_html__( 'Number','munza'),
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Text After Number",'munza'),
            "param_name"        => "item_after",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "group"             => esc_html__( 'Number','munza'),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "numbers_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Number','munza')
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color",'munza'),
            "param_name"        => "numbers_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Number','munza')
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "numbers_size",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Number','munza')
         ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', "munza" ),
            'param_name'        => 'item_font_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Number','munza'),
            'value'             => array(
                esc_html__( '-- Select --','munza') => '',
                esc_html__( 'normal','munza') => 'normal',
                esc_html__( 'bold','munza') => 'bold',
                esc_html__( 'lighter','munza') => 'lighter',
                esc_html__( 'bolder','munza') => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit','munza') => 'inherit'
            ),
        ),
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            "group"             => esc_html__( 'Icon','munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Position",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "param_name"        => "icon_pos",
            "group"             => esc_html__( "Icon",'munza'),
            "value"             => array(
                esc_html__( 'Inline','munza')   => 'inline',
                esc_html__( 'Block','munza')    => 'block',
            ),
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "param_name"        => "icon_align",
            "group"             => esc_html__( "Icon",'munza'),
            "value"             => array(
                esc_html__( 'Left','munza')      => 'left',
                esc_html__( 'Center','munza')    => 'center',
                esc_html__( 'Right','munza')     => 'right',
            ),
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "icon_shape",
            "value" => array(
                esc_html__( 'Square','munza')    => 'square',
                esc_html__( 'Rounded','munza')   => 'rounded',
                esc_html__( 'round','munza')     => 'rounded-lg',
                esc_html__( 'Circle','munza')    => 'circle',
            ),
            "group"             => esc_html__( "Icon",'munza'),
            'dependency'        => array('element' => 'icon_align', 'not_empty' => true)
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "icon_size",
            "value"             => array(
                esc_html__( 'X-Small','munza')   => 'box-xs-icon',
                esc_html__( 'Small','munza')     => 'box-sm-icon',
                esc_html__( 'Normal','munza')    => 'box-md-icon',
                esc_html__( 'Large','munza')     => 'box-lg-icon',
                esc_html__( 'X-Large','munza')   => 'box-xl-icon',
                esc_html__( 'XX-Large','munza')  => 'box-xxl-icon'
            ),
            'dependency'        => array('element' => 'icon_align', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza'),
            "std"               => "box-md-icon"
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "param_name"        => "icon_font_size",
            'group'             => esc_html__( 'Icon','munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (in px.)", "munza"),
            "param_name"        => "icon_border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza'),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "icon_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Icon','munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icon_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza'),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "icon_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza'),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "icon_hover_color",
            'group'             => esc_html__( 'Icon','munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "icon_bg_hover_color",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Icon",'munza'),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Border Color", "munza"),
            "param_name"        => "icon_border_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon",'munza'),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'box_shadow',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hover Shadow', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-9',
            'param_name'        => 'hover_shadow',
            'value'             => array(
                '' => '1',
            ),
        ),
    )
);
    
