<?php
return array(
    "name"              => esc_html__("Call to Action", "munza"),
    "base"              => "it_cta",
    'category'          => esc_html__( 'Munza Shortcodes', "munza" ),
    'description'       => esc_html__( 'Catch visitors attention with CTA block', "munza" ),
    "content_element"   => true,
    'icon'              => 'no-bg fa fa-bullhorn',
    'params'            => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape","munza"),
            "param_name"        => "cta_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( "Square",'munza')    => "square",
                esc_html__( "Rounded",'munza')   => "rounded",
                esc_html__( "Round",'munza')     => "round",
            ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Text Alignment",'munza'),
            "param_name"        => "cta_align",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( 'Left','munza')      =>'left',
                esc_html__( 'Center','munza')    =>'center',
                esc_html__( 'Right','munza')     =>'right',
            ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Width",'munza'),
            "param_name"        => "cta_width",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => array(
                '100%'      =>'100%',
                '90%'      =>'90%',
                '80%'      =>'80%',
                '70%'      =>'70%',
                '60%'      =>'60%',
                '50%'      =>'50%',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Box Padding (px)','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp sm_el',
            "param_name"        => "bwdth",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Box Margin (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "mar_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col las_el",
            "param_name"        => "margin_left",
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Add button?",'munza'),
            "param_name"        => "cta_btn",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( 'No','munza')        =>'',
                esc_html__( 'Top','munza')       =>'top',
                esc_html__( 'Bottom','munza')    =>'bottom',
                esc_html__( 'Left','munza')      =>'left',
                esc_html__( 'Right','munza')     =>'right',
            ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Add Icon?",'munza'),
            "param_name"        => "use_icon",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value" => array(
                esc_html__( 'Top','munza')       =>'top',
                esc_html__( 'Bottom','munza')    =>'bottom',
                esc_html__( 'Left','munza')      =>'left',
                esc_html__( 'Right','munza')     =>'right'
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "bg_color",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Border Width (px)','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "bwdth",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "border_color",  
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "cta_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "std"               => "none",
            "value"             => array(
                esc_html__( "None",'munza')     => "none",
                esc_html__( "Solid",'munza')    => "solid",
                esc_html__( "Dashed",'munza')   => "dashed",
                esc_html__( "Dotted",'munza')   => "dotted",
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),    
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Element ID", "munza"),
            "param_name"        => "el_id",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "description"       => esc_html__("Enter element ID (Note: make sure it is unique and valid according to w3c specification).", "munza"),
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),array(
            'type'              => 'textarea_html',
            'heading'           => esc_html__( 'Text', "munza" ),
            'param_name'        => 'content', 
            'admin_label'       => true,
            'group'             => esc_html__( 'Heading','munza'),
            'value'             => esc_html__( 'Hey! I am first heading line feel free to change me', "munza" ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "tag",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Heading','munza'),
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"               => 'h3'
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'size',
            'group'             => esc_html__( 'Heading','munza'),
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', "munza" ),
            'param_name'        => 'family',
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Heading','munza'),
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', "munza" ),
            'param_name'        => 'gfont',
            'group'             => esc_html__( 'Heading','munza'),
            'edit_field_class'  => 'gfonts',
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', "munza" ),
            'param_name'        => 'weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Heading','munza'),
            'value'             => array(
                esc_html__('-- Select --' ,'munza') => '',
                esc_html__( 'normal','munza') => 'normal',
                esc_html__( 'bold','munza') => 'bold',
                esc_html__( 'lighter','munza') => 'lighter',
                esc_html__( 'bolder','munza') => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit','munza') => 'inherit'
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Letter Spacing (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Heading','munza'),
            "param_name"        => "hd_lett_spacing",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Line Height (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Heading','munza'),
            "param_name"        => "hd_lin_height",
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<u>Underline</u>', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Heading','munza'),
            'param_name'        => 'hd_b_underline',
            'value'             => array(
                '' => '1',
            ),
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Margin Top (px)", "munza"),
            'group'             => esc_html__( 'Heading','munza'),
            "edit_field_class"  => "vc_col-xs-2 sm_col",
            "param_name"        => "hd_marg_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Margin Bottom (px)", "munza"),
            'group'             => esc_html__( 'Heading','munza'),
            "edit_field_class"  => "vc_col-xs-2 sm_col",
            "param_name"        => "hd_marg_bottom",
        ),array(
            'type'              => 'textarea',
            'heading'           => esc_html__( 'Text', "munza" ),
            'param_name'        => 'sub_text',
            'admin_label'       => true,
            'std'               => 'I am promo text. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
            'group'             => esc_html__( 'Text','munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Margin Top (px)", "munza"),
            'group'             => esc_html__( 'Text','munza'),
            "edit_field_class"  => "vc_col-xs-2 sm_col",
            "param_name"        => "sub_marg_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Margin Bottom (px)", "munza"),
            'group'             => esc_html__( 'Text','munza'),
            "edit_field_class"  => "vc_col-xs-2 sm_col",
            "param_name"        => "sub_marg_bottom",
        ),array(
            'type'              => 'numberfield',
            'heading'           => '',
            'param_name'        => 'sss',
            "edit_field_class"  => "vc_column vc_col-xs-2 no-input",
            'group'             => esc_html__( 'Text','munza'),
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', "munza" ),
            'param_name'        => 'sub_size',
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Text','munza'),
            'std'               => '15'
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', "munza" ),
            'param_name'        => 'sub_family',
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Text','munza'),
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', "munza" ),
            'param_name'        => 'sgfont',
            'group'             => esc_html__( 'Text','munza'),
            'edit_field_class'  => 'gfonts',
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', "munza" ),
            'param_name'        => 'sub_color',
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Text','munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Letter Spacing (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Text','munza'),
            "param_name"        => "sub_lett_spacing",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Line Height (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Text','munza'),
            "param_name"        => "sub_lin_height",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Font Style','munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-1 nowrp no-input mtop',
            "param_name"        => "sub_f_st",
            'group'             => esc_html__( 'Text','munza'),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', "munza" ),
            'param_name'        => 'sub_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Text','munza'),
            'std'               => 'normal',
            'value'             => array(
                esc_html__( '-- Select --','munza') => '',
                esc_html__( 'normal','munza') => 'normal',
                esc_html__( 'bold','munza') => 'bold',
                esc_html__( 'lighter','munza') => 'lighter',
                esc_html__( 'bolder','munza') => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit','munza') => 'inherit'
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<i>Italic</i>', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'sub_b_italic',
            'group'             => esc_html__( 'Text','munza'),
            'value'             => array(
                '' => '1',
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( '<u>Underline</u>', "munza" ),
            'edit_field_class'  => 'vc_column vc_col-xs-1',
            'param_name'        => 'sub_b_underline',
            'group'             => esc_html__( 'Text','munza'),
            'value'             => array(
                '' => '1',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop',
            "param_name"        => "su_f_st",
            'group'             => esc_html__( 'Text','munza'),
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Text",'munza'),
            "param_name"        => "btn_text",
            "std"               => "BUTTON TEXT",
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')
        ),
        array(
            "type"              => "vc_link",
            "heading"           => esc_html__( "Link",'munza'),
            "param_name"        => "btn_link",
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')  
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size","munza"),
            "param_name"        => "btn_size", 
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value" => array(
                esc_html__( "Small",'munza')         => "btn-sm",
                esc_html__( "Normal",'munza')        => "btn-md",
                esc_html__( "Large",'munza')         => "btn-lg",
                esc_html__( "X Large",'munza')       => "btn-xl",
            ),
            "std"               => "btn-md",
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape","munza"),
            "param_name"        => "btn_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( "Square",'munza')    => "square",
                esc_html__( "Rounded",'munza')   => "rounded",
                esc_html__( "Round",'munza')     => "round",
            ),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'full width', "munza" ),
            'param_name'        => 'btn_full_width',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza'),
            'value'             => array(
                '' => '1',
            ),
        ),        
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Button",'munza'),
            "param_name"        => "btn_font_size",
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', "munza" ),
            'param_name'        => 'btn_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', "munza" ),
            'param_name'        => 'btn_bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__( 'Border Width (px)','munza'),
            "group"             => esc_html__( "Button",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "btn_bord_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "btn_bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "btn_bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "btn_bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "btn_bord_left",
        ),
        array(
            "type"              => "textfield",
            "heading"           => '',
            "group"             => esc_html__( "Button",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop',
            "param_name"        => "btn_bord_lblnnn",
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Border Color', "munza" ),
            'param_name'        => 'btn_border_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "btn_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Button",'munza'), 
            "value"             => array(
                esc_html__( "None",'munza')  => "none",
                esc_html__( "Solid",'munza')    => "solid",
                esc_html__( "Dashed",'munza')   => "dashed",
                esc_html__( "Dotted",'munza')  => "dotted",
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => '',
            "group"             => esc_html__( "Button",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop',
            "param_name"        => "btn_bord_lblnnn"
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Color', "munza" ),
            'param_name'        => 'btn_hov_color',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Background Color', "munza" ),
            'param_name'        => 'btn_hov_bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Border Color', "munza" ),
            'param_name'        => 'btn_hov_border_color',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Button','munza'),
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true)
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Shadow', "munza" ),
            'param_name'        => 'idl_shad',
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            'group'             => esc_html__( 'Button','munza'), 
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)','munza'),
            "group"             => esc_html__( "Button",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lblss",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shd1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad2",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad3",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad4",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "idl_shad_color",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hover Shadow', "munza" ),
            'param_name'        => 'hover_shad',
            'dependency'        => array( 'element' => 'cta_btn', 'not_empty' => true),
            'group'             => esc_html__( 'Button','munza'), 
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)','munza'),
            "group"             => esc_html__( "Button",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd1",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd2",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd3",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "group"             => esc_html__( "Button",'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd4",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "hover_shd_color",
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
            "group"             => esc_html__( "Button",'munza')
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Add Icon ?",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "value"             => array(
                esc_html__( 'No','munza')         => '',
                esc_html__( 'Left','munza')       => 'left',
                esc_html__( 'Right','munza')      => 'right',
            ),
            "param_name"        => "btn_add_icon",
            "group"             => esc_html__( "Button",'munza'),
        ),array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "btn_icon_param",
            "group"             => esc_html__( 'Button' ,'munza'),
            'dependency'        => array( 'element' => 'btn_add_icon', 'not_empty' => true)
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Icon Color', "munza" ),
            'param_name'        => 'btn_ic_color',
            'group'             => esc_html__( 'Button' ,'munza'),
            'dependency'        => array( 'element' => 'btn_add_icon', 'not_empty' => true)
        ),array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            "group"             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape","munza"),
            "param_name"        => "icon_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' ,'munza'),
            "value"             => array(
                esc_html__( "Square" ,'munza')    => "",
                esc_html__( "Rounded" ,'munza')   => "rounded",
                esc_html__( "Round" ,'munza')     => "round",
                esc_html__( "Circle" ,'munza')    => "circle",
            ),
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size","munza"),
            "param_name"        => "icon_size",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' ,'munza'),
            "value"             => array(
                esc_html__( "Small" ,'munza')         => "sm-icon",
                esc_html__( "Medium" ,'munza')        => "md-icon",
                esc_html__( "Large" ,'munza')         => "lg-icon",
                esc_html__( "X - Large" ,'munza')     => "xl-icon",
            ),
            "std"               => "md-icon"
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (in px.)", "munza"),
            "param_name"        => "icon_font_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon" ,'munza'),
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', "munza" ),
            'param_name'        => 'icon_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', "munza" ),
            'param_name'        => 'icon_bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (px)", "munza"),
            "param_name"        => "icon_border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon" ,'munza'),
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Border Color', "munza" ),
            'param_name'        => 'icon_border_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "icon_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            "group"             => esc_html__( "Icon" ,'munza'), 
            "value"             => array(
                esc_html__( "None" ,'munza')  => "none",
                esc_html__( "Solid" ,'munza')    => "solid",
                esc_html__( "Dashed" ,'munza')   => "dashed",
                esc_html__( "Dotted" ,'munza')  => "dotted",
            ),
        ),
    )
);
    
