<?php
return array(
    "name"                      => esc_html__("Divider", "munza"),
    "base"                      => "it_divider",
    'category'                  => esc_html__( 'Munza Shortcodes', "munza" ),
    'description'               => esc_html__( 'Add block separator with styles', "munza" ),
    'icon'                      => 'no-bg stline-loading-line-1',
    "show_settings_on_create"   => true,
    "params"                    => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Divider Style",'munza'),
            "param_name"        => "divider_class",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            "value" => array(
                esc_html__( 'Short' ,'munza')         => 'short',
                esc_html__( 'Wide' ,'munza')          => 'wide',
                esc_html__( 'Style 1' ,'munza')       => 'skimg',
                esc_html__( 'Style 2' ,'munza')       => 'trimg',
                esc_html__( 'Double' ,'munza')        => 'double',
                esc_html__( 'Small Dotted' ,'munza')  => 'dotted-sm',
                esc_html__( 'Large Dotted' ,'munza')  => 'dotted-lg',
                esc_html__( 'Small Dashed' ,'munza')  => 'dashed-sm',
                esc_html__( 'Large Dashed' ,'munza')  => 'dashed-lg',
            ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "divider_color", 
            'edit_field_class'  => 'vc_column vc_col-xs-2',
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', "munza" ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'vc_column vc_col-xs-10',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1'
        ),
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Type', "munza" ),
            'param_name'        => 'icon_typ',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            'group'             => 'Icon',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'value' => array(
                esc_html__( 'Icon' ,'munza') => 'icon',
                esc_html__( 'Text' ,'munza') => 'text',
                esc_html__( 'Image' ,'munza') => 'img',
            ),
        ),
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            "group"             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'icon')
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Text",'munza'),
            "param_name"        => "div_text",
            "group"             => esc_html__( "Icon" ,'munza'),
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'text')
        ),
        array(
            'type'              => 'attach_image',
            'heading'           => esc_html__( 'Image', "munza" ),
            'param_name'        => 'it_bg_img',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'img')
        ),
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Shape', "munza" ),
            'param_name'        => 'icon_shape',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-7',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'value'             => array(
                esc_html__( 'Square' ,'munza') => '',
                esc_html__( 'Rounded' ,'munza') => 'rounded',
                esc_html__( 'Circle' ,'munza') => 'circle',
            ),
         ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Align', "munza" ),
            'param_name'        => 'icon_align',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            'group'             => esc_html__( 'Icon' ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'value'             => array(
                esc_html__( 'Left' ,'munza')      => '',
                esc_html__( 'Center' ,'munza')    => 'center',
                esc_html__( 'Right' ,'munza')     => 'right',
            ),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size",'munza'),
            "param_name"        => "div_font_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Icon" ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "div_i_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Icon" ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "div_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Icon" ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            "param_name"        => "div_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "group"             => esc_html__( "Icon" ,'munza'),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        )
    )
);
    
