<?php
return array(
    "name"                      => esc_html__("Facebook Box", 'munza'),
    "base"                      => "it_facebook",
    'category'                  => array(esc_html__( 'Munza Shortcodes', 'munza' ),'Social'),
    'icon'                      => 'no-bg fa fa-facebook',
    'description'               => esc_html__( 'Add Facebook box', 'munza' ),
    "content_element"           => true,
    "show_settings_on_create"   => true,
    "params"                    => array(
         array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Facebook Page URL', 'munza' ),
            'param_name'        => 'facebook_user',
            'description'       => esc_html__( 'e.g., http://www.facebook.com/itrays', 'munza' ),
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Tabs', 'js_composer' ),
            'param_name'        => 'facebook_tabs',
            "edit_field_class"  => "vc_column vc_col-xs-4",
            'std'               => 'timeline',
            'description'       => esc_html__( 'e.g., timeline, messages, events.', 'munza' ),
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Width (px)', 'js_composer' ),
            'param_name'        => 'facebook_width',
            "edit_field_class"  => "vc_column vc_col-xs-4",
            'std'               => '250',
            'description'       => esc_html__( 'The pixel width of the embed (Min. 180 to Max. 500)', 'munza' ),
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Height (px)', 'js_composer' ),
            'param_name'        => 'facebook_height',
            "edit_field_class"  => "vc_column vc_col-xs-4",
            'std'               => '350',
            'description'       => esc_html__( 'The pixel height of the embed (Min. 70)', 'munza' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Small Header', 'munza' ),
            'param_name'        => 'fb_sm_header',
            "edit_field_class"  => "vc_column vc_col-xs-3",
            'value'             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Adapt to container width', 'munza' ),
            'param_name'        => 'fb_adapt_width',
            "edit_field_class"  => "vc_column vc_col-xs-3",
            'value'             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hide Cover Photo', 'munza' ),
            'param_name'        => 'fb_hide_cover',
            "edit_field_class"  => "vc_column vc_col-xs-3",
            'value'             => array( esc_html__( 'Yes', 'js_composer' ) => '1' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Show Friends Faces', 'munza' ),
            'param_name'        => 'fb_friends',
            "edit_field_class"  => "vc_column vc_col-xs-3",
            'value'             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Extra class name', 'munza' ),
            'param_name'        => 'el_class',
            'description'       => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'munza' )
        )
    )
);
    
