<?php
return array(
    "name"              => esc_html__("Featured Box", "munza"),
    "base"              => "it_feature", 
    'category'          => esc_html__( 'Munza Shortcodes', "munza" ),
    'description'       => esc_html__( 'Box with image and animations.', "munza" ),
    'icon'              => 'no-bg stline-bookmarks-document',
    "content_element"   => true,
    "params"            => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Box Style",'munza'),
            'edit_field_class'  => 'select_bxs list_imgs ov_vis vc_column vc_col-xs-12',
            "param_name"        => "feature_style",
            "group"             => esc_html__( "Box Style" ,'munza'),
            "value"             => array(
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/bx1.jpg"><span class="ttips">'.esc_html__( 'Image First','munza').'</span>'            => 'style1',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/bx2.jpg"><span class="ttips">'.esc_html__( 'Title First','munza') .'</span>'           => 'style2',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/bx3.jpg"><span class="ttips">'.esc_html__( 'Image Bottom','munza') .'</span>'          => 'style3',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/bx4.jpg"><span class="ttips">'.esc_html__( 'Content Over Image','munza') .'</span>'    => 'style4',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/bx4.jpg"><span class="ttips">'.esc_html__( 'Read More Hover','munza') .'</span>'       => 'style5',
            )
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Box Shape",'munza'),
            "param_name"        => "box_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "group"             => esc_html__( "Box Style" ,'munza'),
            "value"             => array(
                esc_html__( 'Square' ,'munza') =>'',
                esc_html__( 'Rounded' ,'munza') =>'rounded',
                esc_html__( 'Round' ,'munza') =>'round'
            )
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            "group"             => esc_html__( "Box Style" ,'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "param_name"        => "align",
            "value"             => array(
                esc_html__( 'Left' ,'munza')      => '',
                esc_html__( 'Center' ,'munza')    => 'text-center',
                esc_html__( 'Right' ,'munza')     => 'text-right'
            )
        ),array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Read More ?", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Box Style" ,'munza'),
            "param_name"        => "show_more",
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Box Style' ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Border Width (px)' ,'munza'),
            "group"             => esc_html__( "Box Style" ,'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "bord_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "border_color",
            "group"             => esc_html__( "Box Style" ,'munza')
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Box Style" ,'munza'), 
            "value"             => array(
                esc_html__( "None" ,'munza')  => "none",
                esc_html__( "Solid" ,'munza') => "solid",
                esc_html__( "Dashed" ,'munza')=> "dashed",
                esc_html__( "Dotted" ,'munza')=> "dotted",
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', "munza" ),
            'param_name'        => 'idl_shad',
            'group'             => esc_html__( 'Box Style' ,'munza'), 
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)' ,'munza'),
            "group"             => esc_html__( "Box Style" ,'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad2",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad3",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad4",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "shd_color",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
            "group"             => esc_html__( "Box Style" ,'munza')
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Box Padding (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp sm_el',
            "param_name"        => "bwdth",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Box Margin (px)" ,'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "mar_lbl",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col las_el",
            "param_name"        => "margin_left",
            "group"             => esc_html__( "Box Style" ,'munza'),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Overlay Color", "munza"),
            "param_name"        => "over_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "group"             => esc_html__( "Box Style" ,'munza'),
            'dependency'        => array('element' => 'feature_style', 'value' => array( 'style4','style5' )),
         ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "group"             => esc_html__( "Box Style" ,'munza'),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element - add a class name and refer to it in custom CSS.", "munza")
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Title",'munza'),
            "param_name"        => "feature_title",
            "value"             => esc_html__( "Featured Box Heading" ,'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "title_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "title_size",
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Sub Title",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            "param_name"        => "feature_subtitle",
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "subtitle_color",
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "subtitle_size",
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Link",'munza'),
            "param_name"        => "feature_link",
            "group"             => esc_html__( "Content" ,'munza'),
         ),array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Content",'munza'),
            "holder"            => "div",
            "param_name"        => "content",
            "group"             => esc_html__( "Content" ,'munza'),
            "value"             => 'Lorem ipsum dolor sit amet, co sectetur adipiscing elit. Nullam convallis euismod mollis. Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            "param_name"        => "img_shape",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "group"             => esc_html__( "Image" ,'munza'),
            "value"             => array(
                esc_html__( 'Square' ,'munza')  => '',
                esc_html__( 'Rounded' ,'munza') => 'rounded',
                esc_html__( 'Round' ,'munza')   => 'round',
                esc_html__( 'Circle' ,'munza')  => 'circle'
            )
        ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Image",'munza'),
            "param_name"        => "feature_image",
            "group"             => esc_html__( "Image" ,'munza'),
         ),
         array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Title Color", "munza"),
            "param_name"        => "hover_title_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Subtitle Color", "munza"),
            "param_name"        => "hover_subtitle_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Content Color", "munza"),
            "param_name"        => "hover_content_color",
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),
         array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Border Width (px)' , 'munza' ),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "hover_bord_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_bord_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "hover_border_color",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style","munza"),
            "param_name"        => "hover_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover Style' , 'munza' ), 
            "value"             => array(
                esc_html__( "None" , 'munza' )     => "none",
                esc_html__( "Solid" , 'munza' )    => "solid",
                esc_html__( "Dashed" , 'munza' )   => "dashed",
                esc_html__( "Dotted" , 'munza' )   => "dotted",
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', "munza" ),
            'param_name'        => 'hover_shad',
            'group'             => esc_html__( 'Hover Style' , 'munza' ), 
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "hover_lbl1",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shad1",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shad2",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shad3",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shad4",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color","munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "hover_shd_color",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Box Padding (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp sm_el',
            "param_name"        => "hover_bwdth",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_padd_top",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_padd_right",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_padd_bottom",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_padd_left",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => "Box Margin (px)",
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "hover_mar_lbl",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_margin_top",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_margin_right",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_margin_bottom",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col las_el",
            "param_name"        => "hover_margin_left",
            'group'             => esc_html__( 'Hover Style' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Button Text",'munza'),
            "param_name"        => "more_text",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "std"               => "Read More",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            "param_name"        => "more_align",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            "value"             => array(
                esc_html__( 'Left' , 'munza' )      => 'left',
                esc_html__( 'Center' , 'munza' )    => 'centered',
                esc_html__( 'Right' , 'munza' )     => 'right',
            ),
            'std'               => 'centered',
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            "param_name"        => "more_size",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            "std"               => "btn-sm",
            "value"             => array(
                esc_html__( 'Small' , 'munza' )     => 'btn-sm',
                esc_html__( 'Medium' , 'munza' )    => 'btn-md',
                esc_html__( 'Large' , 'munza' )     => 'btn-lg',
            ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Only On Hover', "munza" ),
            'param_name'        => 'more_show_hover',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
            'value'             => array(
                '' => '1',
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "more_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "more_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "more_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array(
                'element' => 'show_more', 'not_empty' => true,
            ),
        )
    )
);
    
