<?php
return array(
    "name"                      => esc_html__("Google Map", 'munza'),
    "base"                      => "it_gmap",
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    'icon'                      => 'no-bg stline-maps-pin',
    'description'               => esc_html__( 'Add google maps with many styles', 'munza' ),
    "content_element"           => true,
    "show_settings_on_create"   => true,
    "params"                    => array(
         array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Zoom', 'munza' ),
            'param_name'        => 'gmap_zoom',
            'std'               => '12',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'Change zoom value.', 'munza' ),
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Height (px)', 'munza' ),
            'param_name'        => 'gmap_height',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'std'               => '500',
            'description'       => esc_html__( 'Add map height value.', 'munza' ),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Map Color", "munza"),
            "param_name"        => "map_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "std"               => '#e7512f',
            "defcolor"          => '#e7512f'
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Disable Mouse Wheel', 'munza' ),
            'param_name'        => 'no_scroll',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'Disable map scroll.', 'munza' ),
            'value'             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'API Key', 'munza' ),
            'param_name'        => 'gmap_key',
            'description'       => esc_html__( 'Enter yor google map API Key', 'munza' )
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Extra class name', 'munza' ),
            'param_name'        => 'el_class',
            'description'       => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'munza' )
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Latitude', 'munza' ),
            'param_name'        => 'gmap_latitude',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Address' , 'munza' ),
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Longitude', 'munza' ),
            'param_name'        => 'gmap_longitude',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Address' , 'munza' ),
        ),
        array(
            'type'              => 'textarea_safe',
            'heading'           => esc_html__( 'Address', 'munza' ),
            'param_name'        => 'gmap_address',
            'group'             => esc_html__( 'Address' , 'munza' ),
        ),
        array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Icon",'munza'),
            "param_name"        => "gmap_icon",
            'group'             => esc_html__( 'Address' , 'munza' ),
        )
    )
);
    
