<?php
return array(
    'name'                      => esc_html__( 'Heading', 'munza' ),
    'base'                      => 'it_heading',
    'icon'                      => 'no-bg stline-bulb-1',
    'save_always'               => true,
    'show_settings_on_create'   => true,
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'               => esc_html__( 'Add heading with custom styles', 'munza' ),
    'params'                    => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Style",'munza'),
            "param_name"        => "heading_style",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( 'Style 1' , 'munza' )  => 'main',
                esc_html__( 'Style 2' , 'munza' )  => 'style2',
                esc_html__( 'Simple' , 'munza' )   => 'simple',
            ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            "param_name"        => "heading_align",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( 'Left' , 'munza' )      =>'left',
                esc_html__( 'Center' , 'munza' )    =>'centered',
                esc_html__( 'Right' , 'munza' )     =>'right',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Margin (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            "param_name"        => "mr_lbl",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),
        array(
            'type'              => 'textarea_html',
            'heading'           => esc_html__( 'Text', 'munza' ),
            'param_name'        => 'content', 
            'admin_label'       => true,
            'value'             => esc_html__( 'This is custom heading element', 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "tag",
            'edit_field_class'  => 'vc_column sm_cell vc_col-xs-1',
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"               => 'h3'
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'size',
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Line Height (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'line_height',
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Letter Spacing (px)', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'param_name'        => 'letter_spacing',
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'font_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( '-- Select --' , 'munza' )  => '',
                esc_html__( 'normal' , 'munza' )        => 'normal',
                esc_html__( 'bold' , 'munza' )          => 'bold',
                esc_html__( 'lighter' , 'munza' )       => 'lighter',
                esc_html__( 'bolder' , 'munza' )        => 'bolder',
                '100'           => '100',
                '200'           => '200',
                '300'           => '300',
                '400'           => '400',
                '500'           => '500',
                '600'           => '600',
                '700'           => '700',
                '800'           => '800',
                '900'           => '900',
                esc_html__( 'inherit' , 'munza' )       => 'inherit'
            ),
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'family',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
            'param_name'        => 'gfont',
            'edit_field_class'  => 'gfonts',
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color", "munza"),
            "param_name"        => "head1_shad_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element' => 'heading_style', "value"             => 'main'
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),    
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Extra class name', 'munza' ),
            'param_name'        => 'el_class',
            'description'       => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'munza' ),
        ),
    )
);
    
