<?php
return array(
    "name"          => esc_html__("Icon Box", 'munza'),
    "base"          => "it_iconbox",
    'category'      => esc_html__( 'Munza Shortcodes', 'munza' ),
    'icon'          => 'no-bg stline-check-badge',
    'description'   => esc_html__( 'icon boxes with many styles', 'munza' ),
    "params"        => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Box Align",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "icbx_align",
            "std"               => "text-center",
            "value"             => array(
                esc_html__( 'Left' , 'munza' ) => 'text-left',
                esc_html__( 'Center' , 'munza' ) => 'text-center',
                esc_html__( 'Right' , 'munza' ) => 'text-right',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'box_shadow',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hover Shadow', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'hover_shadow',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Reverse Content', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'reverse_content',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'use_icon',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1'
        ),array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Read More", "munza"),
            "param_name"        => "show_more",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Custom Style",'munza'),
            "param_name"        => "icbx_cust_shape",
            'edit_field_class'  => 'select_bxs list_imgs vc_column vc_col-xs-12',
            "value"             => array(
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn0.jpg">'   => '',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn1.jpg">'   => 'btn1',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn2.jpg">'   => 'btn2',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn3.jpg">'   => 'btn3',
                '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn4.jpg">'   => 'btn4',
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Styling Options" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hovsss_lbl", 
        ),array(
            "type"              => "label",
            "heading"           => esc_html__( 'Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 txt-right no-input mtop',
            "param_name"        => "padd_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
        ),array(
            "type"              => "label",
            "heading"           => esc_html__( 'Margin (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 txt-right no-input mtop',
            "param_name"        => "marg_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "marg_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "marg_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "marg_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "marg_left",
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', 'munza' ),
            'param_name'        => 'icbx_bg',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
            'std'               => 'color',
            'value'             => array(
                  esc_html__( 'Color', 'munza' )      => 'color',
                  esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_width",
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "border_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( "None" , 'munza' )      => "none",
                esc_html__( "Solid" , 'munza' )     => "solid",
                esc_html__( "Dashed" , 'munza' )    => "dashed",
                esc_html__( "Dotted" , 'munza' )    => "dotted",
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius ( PX )", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_radius",
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', 'munza' ),
            'param_name'        => 'icbx_bg_color',
            'dependency'        => array(
                'element'   => 'icbx_bg',
                'value'     => 'color',
            ),
        ),array(
            'type'              => 'gradientpicker',
            'heading'           => '',
            'param_name'        => 'icbx_bg_grad',
            'dependency'        => array(
                'element'   => 'icbx_bg',
                'value'     => 'gradient',
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Hover Styling" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hov_lbl", 
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', 'munza' ),
            'param_name'        => 'icbx_hover_bg',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-6',
            'std'               => 'color',
            'value'             => array(
                  esc_html__( 'Color', 'munza' )      => 'color',
                  esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "border_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (PX)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_hover_width",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius ( PX )", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_hover_radius",
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', 'munza' ),
            'param_name'        => 'icbx_hover_bg_color',
            'dependency'        => array(
                'element'   => 'icbx_hover_bg',
                'value'     => array('color','image'),
            ),
        ),array(
            'type'              => 'gradientpicker',
            'heading'           => '',
            'param_name'        => 'icbx_hover_bg_grad',
            'dependency'        => array(
                'element'   => 'icbx_hover_bg',
                'value'     => 'gradient',
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(), 
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",     
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Title",'munza'),
            "param_name"        => "icbx_title",
            'group'             => esc_html__( 'Title' , 'munza' ),
            "value"             => "Icon Box Title"
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Link", "munza"),
            "param_name"        => "icbx_link",
            'group'             => esc_html__( 'Title' , 'munza' ),
            "description"       => esc_html__("enter the link for title and read more link.", "munza")
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Title Tag",'munza'),
            "param_name"        => "icbx_title_tag",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Title' , 'munza' ),
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"             => 'h4'
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            'group'             => esc_html__( 'Title' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "title_size",
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'icbx_title_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Title' , 'munza' ),
            'value'             => array(
                esc_html__( '-- Select --' , 'munza' ) => '',
                esc_html__( 'normal' , 'munza' ) => 'normal',
                esc_html__( 'bold' , 'munza' ) => 'bold',
                esc_html__( 'lighter' , 'munza' ) => 'lighter',
                esc_html__( 'bolder' , 'munza' ) => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit' , 'munza' ) => 'inherit'
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "icbx_title_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Title' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "icbx_title_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Title' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Sub Title",'munza'),
            "param_name"        => "icbx_subtitle",
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "icbx_subtitle_tag",
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"               => 'h6'
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "subtitle_size",
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'icbx_subtitle_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            'value'             => array(
                esc_html__( '-- Select --' , 'munza' ) => '',
                esc_html__( 'normal' , 'munza' )       => 'normal',
                esc_html__( 'bold' , 'munza' )         => 'bold',
                esc_html__( 'lighter' , 'munza' )      => 'lighter',
                esc_html__( 'bolder' , 'munza' )       => 'bolder',
                '100'          => '100',
                '200'          => '200',
                '300'          => '300',
                '400'          => '400',
                '500'          => '500',
                '600'          => '600',
                '700'          => '700',
                '800'          => '800',
                '900'          => '900',
                esc_html__( 'inherit' , 'munza' )      => 'inherit'
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "icbx_subtitle_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icbx_subtitle_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "icbx_sub_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "icbx_sub_hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Margin (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            "param_name"        => "icbx_sub_marg_lbl",
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "icbx_sub_marg_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "icbx_sub_marg_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "icbx_sub_marg_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "icbx_sub_marg_left",
        ),array(
            "type"              => "label",
            "heading"           => '',
            'group'             => esc_html__( 'Sub Title' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "ddddd",
        ),array(
            "type"              => "textarea_html",
            'group'             => esc_html__( 'Content' , 'munza' ),
            "heading"           => esc_html__("Content",'munza'),
            'param_name'        => 'content',
            "value"             => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar.",
            "description"       => esc_html__("type here the description for the icon box content.",'munza')
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "content_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Type",'munza'),
            "param_name"        => "icon_typ",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( 'Icon' , 'munza' ) => 'icon',
                esc_html__( 'Text' , 'munza' ) => 'text',
                esc_html__( 'Image' , 'munza' ) => 'image',
            ),
            'std'               => 'icon',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true ),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Position",'munza'),
            "param_name"        => "icon_position",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-3',
            "value"             => array(
                esc_html__( 'Block' , 'munza' )     => 'itr_block_icn',
                esc_html__( 'Side' , 'munza' )      => 'itr_side_icn',
                esc_html__( 'Inline' , 'munza' )    => 'itr_inline_icn',
            ),
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            "param_name"        => "icon_size",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( 'Medium' , 'munza' )    => '',
                esc_html__( 'Small' , 'munza' )     => 'itr_sm_icn',
                esc_html__( 'Large' , 'munza' )     => 'itr_lg_icn',
                esc_html__( 'Custom' , 'munza' )    => 'custom'
            ),
            'group'             => esc_html__( 'Icon' , 'munza' ),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            "param_name"        => "icon_font_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'icon_size', 'value' => 'custom'),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Width (px)", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "icon_width",
            'dependency'        => array( 'element' => 'icon_size', 'value' => 'custom'),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Height (px)", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "icon_height",
            'dependency'        => array( 'element' => 'icon_size', 'value' => 'custom'),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-6 no-input mtop nowrp',
            'dependency'        => array( 'element' => 'icon_size', 'value' => 'custom'),
            "param_name"        => "sss",
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "param_name"        => "icon_align",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            "std"               => "center",
            "value"             => array(
                esc_html__( 'Left' , 'munza' )      => 'left',
                esc_html__( 'Center' , 'munza' )    => 'center',
                esc_html__( 'Right' , 'munza' )     => 'right',
            ),
            'dependency'        => array(
                'element'       => 'icon_position', 
                'value'         => array('itr_block_icn','itr_side_icn')
            ),
         ),array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'std'               => 'outlinefont-Asset-180',
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'icon' )
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Text",'munza'),
            "param_name"        => "icon_text",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'text' ),
            "description"       => esc_html__("This Will replace the icon with your new text.",'munza')
         ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Image",'munza'),
            "param_name"        => "icon_image",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'icon_typ', 'value' => 'image' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "icon_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icon_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (px)", "munza"),
            "param_name"        => "icon_border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "icon_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "icon_border_style",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( "None" , 'munza' )      => "none",
                esc_html__( "Solid" , 'munza' )     => "solid",
                esc_html__( "Dashed" , 'munza' )    => "dashed",
                esc_html__( "Dotted" , 'munza' )    => "dotted",
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius (px)", "munza"),
            "param_name"        => "icon_border_rad",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Hover Styling" , 'munza' ),
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hoverddd_lbl",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "icon_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icon_hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "icon_hover_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius (px)", "munza"),
            "param_name"        => "icon_hover_border_rad",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Button Text",'munza'),
            "param_name"        => "more_text",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "std"               => "Read More",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            "param_name"        => "more_align",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            "value"             => array(
                esc_html__( 'Left' , 'munza' )      => 'left',
                esc_html__( 'Center' , 'munza' )    => 'centered',
                esc_html__( 'Right' , 'munza' )     => 'right',
            ),
            'std'               => 'centered',
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            "param_name"        => "more_size",
            'group'             => esc_html__( 'More Link' , 'munza' ),
            "std"               => "btn-sm",
            "value"             => array(
                esc_html__( 'Small' , 'munza' ) => 'btn-sm',
                esc_html__( 'Medium' , 'munza' ) => 'btn-md',
                esc_html__( 'Large' , 'munza' ) => 'btn-lg',
            ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Only On Hover', 'munza' ),
            'param_name'        => 'more_show_hover',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
            'value'             => array(
                '' => '1',
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "more_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "more_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "more_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'More Link' , 'munza' ),
            'dependency'        => array(
                'element' => 'show_more', 'not_empty' => true,
            ),
        )
    )
);
    
