<?php
return array(
    "name"              => esc_html__("Icon", 'munza'),
    "base"              => "it_icon",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'       => esc_html__( 'Add Custom Icon', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-gift-box-1',
    "params"            => array(
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            "param_name"        => "shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( "Square" , 'munza' )    => "square",
                esc_html__( "Rounded" , 'munza' )   => "rounded",
                esc_html__( "Round" , 'munza' )     => "round",
                esc_html__( "Circle" , 'munza' )    => "circle",
            ),
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "size", 
            "value"             => array(
                esc_html__( "Mini" , 'munza' )        => "xs-icon",
                esc_html__( "Small" , 'munza' )       => "sm-icon",
                esc_html__( "Normal" , 'munza' )      => "md-icon",
                esc_html__( "Large" , 'munza' )       => "lg-icon",
                esc_html__( "Extra Large" , 'munza' ) => "xl-icon",
            ),
            "std"               => "md-icon",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Box Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp sm_el',
            "param_name"        => "bwdth",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Box Margin (px)" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "mar_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col las_el",
            "param_name"        => "margin_left",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Idle Styling" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "idle_lbl",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "font_size",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "color",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-8",
            "param_name"        => "bg_color",
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Border Width (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "bord_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "border_color",
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( "None" , 'munza' )      => "none",
                esc_html__( "Solid" , 'munza' )     => "solid",
                esc_html__( "Dashed" , 'munza' )    => "dashed",
                esc_html__( "Dotted" , 'munza' )    => "dotted",
            ),
        ),array(
            "type"              => "label",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "hd2333",
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', 'munza' ),
            'param_name'        => 'idl_shad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl1",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad1",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad2",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad3",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad4",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "shd_color",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),
        array(
            "type"              => "textfield",
            "heading"           => "Hover Styling",
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hover_lbl",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "hover_color",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "hover_bg_color",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "hover_border_color",
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "hover_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( "None" , 'munza' )      => "none",
                esc_html__( "Solid" , 'munza' )     => "solid",
                esc_html__( "Dashed" , 'munza' )    => "dashed",
                esc_html__( "Dotted" , 'munza' )    => "dotted",
            ),
        ),array(
            "type"              => "label",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "hd23133",
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Hover Animation",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            "param_name"        => "hover_anim", 
            "value"             => array(
                esc_html__( "FadeIn" , 'munza' )          => "anim0",
                esc_html__( "Bottom To Top" , 'munza' )   => "anim1",
                esc_html__( "Right To Left" , 'munza' )   => "anim2",
                esc_html__( "Left To Right" , 'munza' )   => "anim3",
                esc_html__( "Top To Bottom" , 'munza' )   => "anim4",
                esc_html__( "Zoom In" , 'munza' )         => "anim5",
                esc_html__( "Zoom Out" , 'munza' )        => "anim6",
                esc_html__( "3D Rotate" , 'munza' )       => "anim7",
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', 'munza' ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'hidden',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', 'munza' ),
            'param_name'        => 'hover_shad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Shadow Properties (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd1",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd2",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd3",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd4",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "hover_shd_color",
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),
        array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Link",'munza'),
            "param_name"        => "link",  
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        )        
    )
);
    
