<?php
return array(
    "name" => esc_html__("Image Layers", 'munza'),
    "base" => "it_images",
    'category' => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element" => true,
    'icon' => 'no-bg stline-picture-polaroid-landscape',
    "params" => array(
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Alignment', 'munza' ),
            'param_name'        => 'align',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            'value'             => array(
                esc_html__( 'Left' , 'munza' ) => '',
                esc_html__( 'Center' , 'munza' ) => 'center',
                esc_html__( 'Right' , 'munza' ) => 'right',
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),
        array(
            'type'              => 'param_group',
            'heading'           => esc_html__('Add Images', 'munzas'),
            'param_name'        => 'images_layers',
            'params'            => array(
                array(
                    "type"              => "attach_image",
                    "heading"           => esc_html__("Image",'munza'),
                    "param_name"        => "layer_image",
                ),array(
                    "type"              => "numberfield",
                    "heading"           => esc_html__("Horizontal Offset ( % )", "munza"),
                    "param_name"        => "h_of",
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                ),array(
                    "type"              => "numberfield",
                    "heading"           => esc_html__("Vertical Offset ( % )", "munza"),
                    "param_name"        => "v_of",
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                ),array(
                    "type"              => "numberfield",
                    "heading"           => esc_html__("Interval", "munza"),
                    "param_name"        => "inv",
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                    "value"             => '300',
                    "description"       => esc_html__('Set the animation delay in milliseconds.','munza'),
                ),array(
                    "type"              => "dropdown",
                    "heading"           => esc_html__("Animation",'munza'),
                    'edit_field_class'  => 'vc_column vc_col-xs-6',
                    "param_name"        => "layer_anim",
                    "value"             => array(
                        esc_html__( 'bounce', 'munza' ) => 'bounce',
                        esc_html__( 'flash', 'munza' ) => 'flash',
                        esc_html__( 'pulse', 'munza' ) => 'pulse',
                        esc_html__( 'rubberBand', 'munza' ) => 'rubberBand',
                        esc_html__( 'shake', 'munza' ) => 'shake',
                        esc_html__( 'swing', 'munza' ) => 'swing',
                        esc_html__( 'tada', 'munza' ) => 'tada',
                        esc_html__( 'wobble', 'munza' ) => 'wobble',
                        esc_html__( 'jello', 'munza' ) => 'jello',

                        esc_html__( 'bounceIn', 'munza' ) => 'bounceIn',
                        esc_html__( 'bounceInDown', 'munza' ) => 'bounceInDown',
                        esc_html__( 'bounceInLeft', 'munza' ) => 'bounceInLeft',
                        esc_html__( 'bounceInRight', 'munza' ) => 'bounceInRight',
                        esc_html__( 'bounceInUp', 'munza' ) => 'bounceInUp',

                        esc_html__( 'bounceOut', 'munza' ) => 'bounceOut',
                        esc_html__( 'bounceOutDown', 'munza' ) => 'bounceOutDown',
                        esc_html__( 'bounceOutLeft', 'munza' ) => 'bounceOutLeft',
                        esc_html__( 'bounceOutRight', 'munza' ) => 'bounceOutRight',
                        esc_html__( 'bounceOutUp', 'munza' ) => 'bounceOutUp',

                        esc_html__( 'fadeIn', 'munza' ) => 'fadeIn',
                        esc_html__( 'fadeInDown', 'munza' ) => 'fadeInDown',
                        esc_html__( 'fadeInDownBig', 'munza' ) => 'fadeInDownBig',
                        esc_html__( 'fadeInLeft', 'munza' ) => 'fadeInLeft',
                        esc_html__( 'fadeInLeftBig', 'munza' ) => 'fadeInLeftBig',
                        esc_html__( 'fadeInRight', 'munza' ) => 'fadeInRight',
                        esc_html__( 'fadeInRightBig', 'munza' ) => 'fadeInRightBig',
                        esc_html__( 'fadeInUp', 'munza' ) => 'fadeInUp',
                        esc_html__( 'fadeInUpBig', 'munza' ) => 'fadeInUpBig',

                        esc_html__( 'fadeOut', 'munza' ) => 'fadeOut',
                        esc_html__( 'fadeOutDown', 'munza' ) => 'fadeOutDown',
                        esc_html__( 'fadeOutDownBig', 'munza' ) => 'fadeOutDownBig',
                        esc_html__( 'fadeOutLeft', 'munza' ) => 'fadeOutLeft',
                        esc_html__( 'fadeOutLeftBig', 'munza' ) => 'fadeOutLeftBig',
                        esc_html__( 'fadeOutRight', 'munza' ) => 'fadeOutRight',
                        esc_html__( 'fadeOutRightBig', 'munza' ) => 'fadeOutRightBig',
                        esc_html__( 'fadeOutUp', 'munza' ) => 'fadeOutUp',
                        esc_html__( 'fadeOutUpBig', 'munza' ) => 'fadeOutUpBig',

                        esc_html__( 'flip', 'munza' ) => 'flip',
                        esc_html__( 'flipInX', 'munza' ) => 'flipInX',
                        esc_html__( 'flipInY', 'munza' ) => 'flipInY',
                        esc_html__( 'flipOutX', 'munza' ) => 'flipOutX',
                        esc_html__( 'flipOutY', 'munza' ) => 'flipOutY',

                        esc_html__( 'lightSpeedIn', 'munza' ) => 'lightSpeedIn',
                        esc_html__( 'lightSpeedOut', 'munza' ) => 'lightSpeedOut',

                        esc_html__( 'rotateIn', 'munza' ) => 'rotateIn',
                        esc_html__( 'rotateInDownLeft', 'munza' ) => 'rotateInDownLeft',
                        esc_html__( 'rotateInDownRight', 'munza' ) => 'rotateInDownRight',
                        esc_html__( 'rotateInUpLeft', 'munza' ) => 'rotateInUpLeft',
                        esc_html__( 'rotateInUpRight', 'munza' ) => 'rotateInUpRight',

                        esc_html__( 'rotateOut', 'munza' ) => 'rotateOut',
                        esc_html__( 'rotateOutDownLeft', 'munza' ) => 'rotateOutDownLeft',
                        esc_html__( 'rotateOutDownRight', 'munza' ) => 'rotateOutDownRight',
                        esc_html__( 'rotateOutUpLeft', 'munza' ) => 'rotateOutUpLeft',
                        esc_html__( 'rotateOutUpRight', 'munza' ) => 'rotateOutUpRight',

                        esc_html__( 'slideInUp', 'munza' ) => 'slideInUp',
                        esc_html__( 'slideInDown', 'munza' ) => 'slideInDown',
                        esc_html__( 'slideInLeft', 'munza' ) => 'slideInLeft',
                        esc_html__( 'slideInRight', 'munza' ) => 'slideInRight',

                        esc_html__( 'slideOutUp', 'munza' ) => 'slideOutUp',
                        esc_html__( 'slideOutDown', 'munza' ) => 'slideOutDown',
                        esc_html__( 'slideOutLeft', 'munza' ) => 'slideOutLeft',
                        esc_html__( 'slideOutRight', 'munza' ) => 'slideOutRight',
                                          
                        esc_html__( 'zoomIn', 'munza' ) => 'zoomIn',
                        esc_html__( 'zoomInDown', 'munza' ) => 'zoomInDown',
                        esc_html__( 'zoomInLeft', 'munza' ) => 'zoomInLeft',
                        esc_html__( 'zoomInRight', 'munza' ) => 'zoomInRight',
                        esc_html__( 'zoomInUp', 'munza' ) => 'zoomInUp',

                        esc_html__( 'zoomOut', 'munza' ) => 'zoomOut',
                        esc_html__( 'zoomOutDown', 'munza' ) => 'zoomOutDown',
                        esc_html__( 'zoomOutLeft', 'munza' ) => 'zoomOutLeft',
                        esc_html__( 'zoomOutRight', 'munza' ) => 'zoomOutRight',
                        esc_html__( 'zoomOutUp', 'munza' ) => 'zoomOutUp',

                        esc_html__( 'hinge', 'munza' ) => 'hinge',
                        esc_html__( 'rollIn', 'munza' ) => 'rollIn',
                        esc_html__( 'rollOut', 'munza' ) => 'rollOut',
                    ),
                 ),
            ),
            'group' => 'Images',
        )
    )
);
