<?php
return array(
    "name"                      => esc_html__("Image Compare Slider", 'munza'),
    "base"                      => "it_img_compare",
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    'icon'                      => 'no-bg stline-camera-double',
    "content_element"           => true,
    "description"               => esc_html__( "Display two images with dragable divider." , 'munza' ),
    "show_settings_on_create"   => true,
    "params"                    => array(
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Start Point (%)",'munza'),
            "param_name"        => "start_point",
            "std"               => "50",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Main Image",'munza'),
            "param_name"        => "image",
            "group"             => esc_html__( "Main Slide" , 'munza' )
         ),array(
            'type'              => 'textarea',
            'heading'           => esc_html__( 'Text', 'munza' ),
            'param_name'        => 'main_text',
            'admin_label'       => true,
            'std'               => 'Original.',
            'group'             => esc_html__( 'Main Slide' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "txt_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Main Slide" , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "txt_color",
            'edit_field_class'  => 'vc_column vc_col-xs-10',
            "group"             => esc_html__( "Main Slide" , 'munza' ),
         ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Second Image",'munza'),
            "param_name"        => "sec_image",
            "group"             => esc_html__( "Second Slide" , 'munza' )
        ),array(
            'type'              => 'textarea',
            'heading'           => esc_html__( 'Text', 'munza' ),
            'param_name'        => 'second_text',
            'admin_label'       => true,
            'std'               => 'Modified.',
            'group'             => esc_html__( 'Second Slide' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "sec_txt_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Second Slide" , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "sec_txt_color",
            'edit_field_class'  => 'vc_column vc_col-xs-10',
            "group"             => "Second Slide",
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Width (px)",'munza'),
            "param_name"        => "div_width",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Divider' , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "div_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Divider' , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Active Background",'munza'),
            "param_name"        => "div_act_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Divider' , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Circle Background",'munza'),
            "param_name"        => "circ_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Divider' , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Active Circle Background",'munza'),
            "param_name"        => "circ_act_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Divider' , 'munza' ),
         ),
    )
);
    
