<?php
return array(
    "name"              => esc_html__("List Item", 'munza'),
    "base"              => "it_list_item",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'       => esc_html__( 'Add List Item', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-checklist-pen',
    "as_child"          => array('only' => 'it_list'),
    "params"            => array(
        array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Content",'munza'),
            "param_name"        => "content",  
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', 'munza' ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'std'               => '0',
            'value'             => array(
                '' => '1',
            ),
        ),
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Width",'munza'),
            "param_name"        => "icon_width",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Height",'munza'),
            "param_name"        => "icon_height",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size",'munza'),
            "param_name"        => "icon_size",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "icon_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icon_bgcolor",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Shape', 'munza' ),
            'param_name'        => 'icon_shape',
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            'value'             => array(
                  esc_html__( 'Square', 'munza' )     => '',
                  esc_html__( 'Rounded', 'munza' )    => 'rounded',
                  esc_html__( 'Round', 'munza' )      => 'round',
                  esc_html__( 'Circle', 'munza' )     => 'circle',
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),
    )
);
    
