<?php
return array(
    "name"                      => esc_html__("List", "munza"),
    "base"                      => "it_list",
    "as_parent"                 => array('only' => 'it_list_item'),
    'icon'                      => 'no-bg stline-layout-bullets',
    "show_settings_on_create"   => true,
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element"           => true,
    'description'               => esc_html__( 'Add Custom List with icon.', 'munza' ),
    "params"                    => array(
        array(
           'type'               => 'dropdown',
            'heading'           => esc_html__( 'Size', 'munza' ),
            'param_name'        => 'size',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-7',
            'value'             => array(
                esc_html__( 'Small' , 'munza' )    => 'sm',
                esc_html__( 'Normal' , 'munza' )   => 'md',
                esc_html__( 'Large' , 'munza' )    => 'lg',
                esc_html__( 'X Large' , 'munza' )  => 'xl',
            ),
            'std'               => 'md'
        ),array(
           'type'               => 'dropdown',
            'heading'           => esc_html__( 'Align', 'munza' ),
            'param_name'        => 'cust_list_align',
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            'value'             => array(
                esc_html__( 'Left' , 'munza' )  => '',
                esc_html__( 'Right' , 'munza' ) => 'text-right',
            )
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-4",
            "param_name"        => "list_border_width",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            "edit_field_class"  => "vc_column vc_col-xs-4",
            "param_name"        => "list_border_color",
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "list_border_style",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( "None" , 'munza' )      => "none",
                esc_html__( "Solid" , 'munza' )     => "solid",
                esc_html__( "Dashed" , 'munza' )    => "dashed",
                esc_html__( "Dotted" , 'munza' )    => "dotted",
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        )
    ),
    "js_view" => 'VcColumnView'
); 
    
