<?php
return array(
    "name"          => esc_html__("Team Member", 'munza'),
    "base"          => "it_member", 
    'category'      => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'   => esc_html__( 'Add team member box to page', 'munza' ),
    'icon'          => 'no-bg stline-people-man-8',
    "params"        => array(
         array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Style",'munza'),
            "param_name"        => "member_style",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( 'style 1' , 'munza' )    => '1',
                esc_html__( 'style 2' , 'munza' )    => '2',
                esc_html__( 'style 3' , 'munza' )    => '3',
                esc_html__( 'style 4' , 'munza' )    => '4',
            )
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Align",'munza'),
            "param_name"        => "align",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( 'Left' , 'munza' )     =>'',
                esc_html__( 'Center' , 'munza' )   =>'text-center',
                esc_html__( 'Right' , 'munza' )    =>'text-right'
            )
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius ( PX )", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_radius",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "bg_color",
            'dependency'        => array(
                'element'               => 'member_style', 
                'value_not_equal_to'    => '1'
            ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Background' , 'munza' ),
        ),array(
            'type'              => 'attach_image',
            'heading'           => esc_html__( 'Background Image', 'munza' ),
            'param_name'        => 'it_bg_img',  
            'edit_field_class'  => 'vc_column vc_col-xs-10',
            'group'             => esc_html__( 'Background' , 'munza' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background Repeat', 'munza' ),
            'param_name'        => 'bg_image_repeat',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Background' , 'munza' ),     
            'value'             => array(
                  esc_html__( 'Repeat', 'munza' )       => '',
                  esc_html__( 'Horizontally', 'munza' ) => 'repeat-x',
                  esc_html__('Vertically', 'munza')     => 'repeat-y',
                  esc_html__('No Repeat', 'munza')      => 'no-repeat'
            ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background Attachment', 'munza' ),
            'param_name'        => 'bg_image_attachment',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Background' , 'munza' ),
            'value'             => array(
                esc_html__( 'Scroll', 'munza' ) => '',
                esc_html__( 'Fixed', 'munza' )  => 'fixed',
            ),     
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background Position', 'munza' ),
            'param_name'        => 'bg_image_position',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Background' , 'munza' ),  
            'value'             => array(
                esc_html__( 'Left Top', 'munza' )     => '',
                esc_html__( 'Left Center', 'munza' )  => '0% 50%',
                esc_html__( 'Left Bottom', 'munza')   => '0% 100%',
                esc_html__( 'Right Top', 'munza')     => '100% 0%',
                esc_html__( 'Right Center', 'munza' ) => '100% 50%',
                esc_html__( 'Right Bottom', 'munza' ) => '100% 100%',
                esc_html__( 'Center Top', 'munza')    => '50% 0%',
                esc_html__( 'Center Center', 'munza') => '50% 50%',
                esc_html__( 'Center Bottom', 'munza' )=> '50% 100%'
            ),  
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background Size', 'munza' ),
            'param_name'        => 'bg_cover', 
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Background' , 'munza' ),
            'value'             => array(
                esc_html__('-- Choose --','munza') => '',
                esc_html__( 'Cover', 'munza' )     => 'cover',
                esc_html__( 'Contain', 'munza' )   => 'contain',
                '100%' => '100% 100%',
            ),    
        ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Image",'munza'),
            "param_name"        => "image",
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Alternative Image",'munza'),
            "param_name"        => "alt_image",
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "img_bg_color",
            "edit_field_class"  => "vc_column vc_col-xs-12",
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius ( PX )", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-12",
            "param_name"        => "img_border_radius",
            'group'             => esc_html__( 'Image' , 'munza' ),
            'dependency'        => array(
                'element'            => 'member_style', 
                'value_not_equal_to' => '1'
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Overlay Color", "munza"),
            "param_name"        => "hover_over_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element' => 'member_style', 
                'value'   => '4'
            ),
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Name",'munza'),
            "param_name"        => "member_name",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "name_tag",
            'group'             => esc_html__( 'Details' , 'munza' ),
            'edit_field_class'  => 'vc_column sm_cell vc_col-xs-2',
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"               => 'h4'
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "name_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "name_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Position",'munza'),
            "param_name"        => "member_position",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Tag",'munza'),
            "param_name"        => "post_tag",
            'group'             => esc_html__( 'Details' , 'munza' ),
            'edit_field_class'  => 'vc_column sm_cell vc_col-xs-2',
            "value"             => array(
                'H1' =>'h1',
                'H2' =>'h2',
                'H3' =>'h3',
                'H4' =>'h4',
                'H5' =>'h5',
                'H6' =>'h6',
            ),
            "std"               => 'h6'
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "position_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "position_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Details",'munza'),
            "param_name"        => "content",
            'group'             => esc_html__( 'Details' , 'munza' ),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Facebook",'munza'),
            "param_name"        => "member_fb",
            'group'             => esc_html__( 'Socials' , 'munza' ),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Twitter",'munza'),
            "param_name"        => "member_tw",
            'group'             => esc_html__( 'Socials' , 'munza' ),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("LinkedIn",'munza'),
            "param_name"        => "member_ln",
            'group'             => esc_html__( 'Socials' , 'munza' ),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Google Plus",'munza'),
            "param_name"        => "member_go",
            'group'             => esc_html__( 'Socials' , 'munza' ),
         ),array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Skype",'munza'),
            "param_name"        => "member_sk",
            'group'             => esc_html__( 'Socials' , 'munza' ),
         ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "soc_color",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Socials' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "soc_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Socials' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "soc_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Socials' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "soc_bg_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Socials' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius ( PX )", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-12",
            "param_name"        => "soc_border_radius",
            'group'             => esc_html__( 'Socials' , 'munza' ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        )
    )
);
    
