<?php
return array(
    "name"                      => esc_html__("Popup Window", 'munza'),
    "base"                      => "it_modal", 
    "as_parent"                 => array('except' => 'row'),
    "content_element"           => true,
    "show_settings_on_create"   => true,
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'               => esc_html__( 'Add Popup window on click', 'munza' ),
    'icon'                      => 'no-bg fa fa-object-ungroup',
    "params"                    => array(
         array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Animation",'munza'),
            "param_name"        => "modal_anim",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( 'Fade in And Scale' , 'munza' )       => 'md-effect-1',
                esc_html__( 'Slide in (right)' , 'munza' )      => 'md-effect-2',
                esc_html__( 'Slide in (bottom)' , 'munza' )     => 'md-effect-3',
                esc_html__( 'Newspaper' , 'munza' )             => 'md-effect-4',
                esc_html__( 'Fall' , 'munza' )                  => 'md-effect-5',
                esc_html__( 'Side Fall' , 'munza' )             => 'md-effect-6',
                esc_html__( 'Sticky Up' , 'munza' )             => 'md-effect-7',
                esc_html__( '3D Flip (horizontal)' , 'munza' )  => 'md-effect-8',
                esc_html__( '3D Flip (vertical)' , 'munza' )    => 'md-effect-9',
                esc_html__( '3D Sign' , 'munza' )               => 'md-effect-10',
                esc_html__( 'Super Scaled' , 'munza' )          => 'md-effect-11',
                esc_html__( '3D Slit' , 'munza' )               => 'md-effect-13',
                esc_html__( '3D Rotate Bottom' , 'munza' )      => 'md-effect-14',
                esc_html__( '3D Rotate In Left' , 'munza' )     => 'md-effect-15',
            )
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Element",'munza'),
            "param_name"        => "modal_element",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( 'Button' , 'munza' ) =>'mod_button',
                esc_html__( 'Image' , 'munza' )  =>'mod_image',
                esc_html__( 'Icon' , 'munza' )   =>'icon',
            )
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Content Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp',
            "param_name"        => "conent_padd_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "conent_padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "conent_padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "conent_padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "conent_padd_left",
        ),array(
            "type"              => "numberfield",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            "param_name"        => "conent_padd_lbl2",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__( 'Content Background', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            "param_name"        => "content_background",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),
        array(
           'type'               => 'dropdown',
            'heading'           => esc_html__( 'Button Type', 'munza' ),
            'param_name'        => 'button_style',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            'description'       => esc_html__( 'Select button type.', 'munza' ),
            'value'             => array(
                esc_html__( 'Button' , 'munza' )     => 'n-button',
                esc_html__('Normal Link' , 'munza' ) => 'n-link',
            ),
            'dependency'        => array(
                'element'   => 'modal_element',
                'value'     => 'mod_button',
            ),
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Text" , 'munza' ),
            "param_name"        => "mod_btn_text",
            "std"               => "BUTTON TEXT",
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array(
                'element' => 'modal_element',
                'value'   => 'mod_button',
            ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            "param_name"        => "mod_btn_size", 
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            "value"             => array(
                esc_html__( "Small" , 'munza' )   => "btn-sm",
                esc_html__( "Medium" , 'munza' )  => "btn-md",
                esc_html__( "Large" , 'munza' )   => "btn-lg",
                esc_html__( "X Large" , 'munza' ) => "btn-xl",
            ),
            "std"               => "btn-md",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button'),
            'group'             => esc_html__( 'Button' , 'munza' ),
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            "param_name"        => "mod_btn_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            "value"             => array(
                esc_html__( "Square" , 'munza' )  => "square",
                esc_html__( "Rounded" , 'munza' ) => "rounded",
                esc_html__( "Round" , 'munza' )   => "round",
            ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button'),
            'group'             => esc_html__( 'Button' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            "param_name"        => "mod_btn_align", 
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-5',
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button'),
            'group'             => esc_html__( 'Button' , 'munza' ),
            "value"             => array(
                esc_html__( "Left" , 'munza' )   => "left",
                esc_html__( "Right" , 'munza' )  => "right",
                esc_html__( "Center" , 'munza' ) => "center",
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            "param_name"        => "mod_btn_font_size",
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', 'munza' ),
            'param_name'        => 'mod_btn_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', 'munza' ),
            'param_name'        => 'mod_btn_bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),array(
            "type"              => "textfield",
            "heading"           => 'Border Width (px)',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "mod_btn_bord_lbl",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            'group'             => esc_html__( 'Button' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "mod_btn_bord_top",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            'group'             => esc_html__( 'Button' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "mod_btn_bord_right",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            'group'             => esc_html__( 'Button' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "mod_btn_bord_bottom",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            'group'             => esc_html__( 'Button' , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "mod_btn_bord_left",
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Border Color', 'munza' ),
            'param_name'        => 'mod_btn_border_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Color', 'munza' ),
            'param_name'        => 'mod_btn_hov_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Background', 'munza' ),
            'param_name'        => 'mod_btn_hov_bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Hover - Border Color', 'munza' ),
            'param_name'        => 'mod_btn_hov_border_color',
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array( 'element' => 'button_style', 'value' => 'n-button')
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("CSS class", "munza"),
            "param_name"        => "mod_btn_class",
            'group'             => esc_html__( 'Button' , 'munza' ),
            'dependency'        => array(
                'element' => 'modal_element',
                'value'   => 'mod_button',
            ),
            "description"       => esc_html__("add extra CSS class for this button.", "munza")
        ),
        array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Image",'munza'),
            "param_name"        => "image",
            'group'             => esc_html__( 'Image' , 'munza' ),
            "value"             => '',
            'dependency'        => array(
                'element' => 'modal_element',
                'value'   => 'mod_image',
            ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Image Size",'munza'),
            "param_name"        => "img_size",
            'group'             => esc_html__( 'Image' , 'munza' ),
            "value"             => array(
                esc_html__( 'Small - 40x40' , 'munza' )               => '40x40',
                esc_html__( 'Small - 55x55' , 'munza' )               => '55x55',
                esc_html__( 'Small - 70x70' , 'munza' )               => '70x70',
                esc_html__( 'Thumbnail - 150x150' , 'munza' )         => 'thumbnail',
                esc_html__( 'Medium - 400x380' , 'munza' )            => 'blog-small-image',
                esc_html__( 'Large - 1024x1024' , 'munza' )           => 'large',
                esc_html__( 'Blog Large Image - 1170x470' , 'munza' ) => 'blog-large-image',
                esc_html__( 'Original Size' , 'munza' )               => 'full'
            ),                           
            "description"       => esc_html__("select the image size.",'munza'),
            "std"               => 'thumbnail',
            'dependency'        => array(
                'element' => 'modal_element',
                'value'   => 'mod_image',
            ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', 'munza' ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'hidden',
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'modal_element', 'value' => 'icon'),
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
        ),
        array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "param_name"        => "icon_align",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            "value"             => array(
                esc_html__( 'Left' , 'munza' )    => 'left',
                esc_html__( 'Center' , 'munza' )  => 'center',
                esc_html__( 'Right' , 'munza' )   => 'right',
            ),
            'dependency'        => array(
                'element'   => 'use_icon', 
                'not_empty' => true
            ),
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "icon_shape",
            "value"             => array(
                esc_html__( 'Square' , 'munza' )    => 'square',
                esc_html__( 'Rounded' , 'munza' )   => 'rounded',
                esc_html__( 'round' , 'munza' )     => 'rounded-lg',
                esc_html__( 'Circle' , 'munza' )    => 'circle',
            ),
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array(
                'element'   => 'icon_align', 
                'not_empty' => true
            )
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Size",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "param_name"        => "icon_size",
            "value"             => array(
                esc_html__( 'X-Small' , 'munza' )   => 'box-xs-icon',
                esc_html__( 'Small' , 'munza' )     => 'box-sm-icon',
                esc_html__( 'Normal' , 'munza' )    => 'box-md-icon',
                esc_html__( 'Large' , 'munza' )     => 'box-lg-icon',
                esc_html__( 'X-Large' , 'munza' )   => 'box-xl-icon',
                esc_html__( 'XX-Large' , 'munza' )  => 'box-xxl-icon'
            ),
            'dependency'        => array(
                'element'   => 'icon_align', 
                'not_empty' => true
            ),
            'group'             => esc_html__( 'Icon' , 'munza' ),
            "std"               => "box-md-icon"
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "param_name"        => "icon_font_size",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (in px.)", "munza"),
            "param_name"        => "icon_border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "icon_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "icon_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "icon_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "icon_hover_color",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "icon_bg_hover_color",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Border Color", "munza"),
            "param_name"        => "icon_border_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        )
    ),
    "js_view" => 'VcColumnView'
);
    
