<?php
return array(
    "name"          => esc_html__("Circle Chart", 'munza'),
    "base"          => "it_pie",
    'category'      => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'   => esc_html__( 'animated circle charts with options', 'munza' ),
    'icon'          => 'no-bg stline-analytics-pie-2',
    "params"        => array(
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Background Border Width",'munza'),
            "param_name"        => "backgroundborderwidth",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'width of background circle border', 'munza' ),
            "std" => "1",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color",'munza'),
            "param_name"        => "backgroundcolor",
            'edit_field_class'  => 'vc_column vc_col-xs-9',
            'description'       => esc_html__( 'color of the background circle', 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Foreground Border Width",'munza'),
            "param_name"        => "foregroundborderwidth",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'width of foreground circle border', 'munza' ),
            "std"               => "2",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Foreground Color",'munza'),
            "param_name"        => "foregroundcolor",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'color of the foreground circle', 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("LineCap",'munza'),
            "param_name"        => "line_cap",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-6',
            "value"             => array(
                esc_html__( 'Square' , 'munza' )  => 'butt',
                esc_html__( 'round' , 'munza' )   => 'round',
            ),
            "std"               => "round"
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Percentage",'munza'),
            "param_name"        => "percent",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => '50',
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Percentage Font Size (PX)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "std"               => "9",
            "param_name"        => "percentagetextsize",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Percentage Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "param_name"        => "fontcolor",
            "description"       => esc_html__('color of the percentage','munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Add Icon', 'munza' ),
            'param_name'        => 'use_icon',
            'value'             => array(
                '' => '1',
            ),
        ),array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (PX)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-3",
            "param_name"        => "icon_size",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Icon Color",'munza'),
            "param_name"        => "icon_color",
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'vc_column vc_col-xs-9',
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Text",'munza'),
            "param_name"        => "text",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (PX)",'munza'),
            "param_name"        => "textsize",
            "std"               => "2.5",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color",'munza'),
            "param_name"        => "textcolor",
            'edit_field_class'  => 'vc_column vc_col-xs-9',
            "description"       => esc_html__('font color of the info text','munza'),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),
    )
);
    
