<?php
return array(
    "name"              => esc_html__("Pricing Table", "munza"),
    "base"              => "it_price_table",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'       => esc_html__( 'Add Pricing Table', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-money-bags',
    "params"            => array(
        array(
           'type'               => 'dropdown',
            'heading'           => esc_html__( 'Style', 'munza' ),
            'param_name'        => 'pricing_style',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-10',
            'description'       => esc_html__( 'Select Style.', 'munza' ),
            'value'             => array(
                esc_html__( 'Style 1' , 'munza' ) => 'pricing-1',
                esc_html__( 'Style 2' , 'munza' ) => 'pricing-2',
                esc_html__( 'Style 3' , 'munza' ) => 'pricing-3',
            ),
        ),array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Featured?", "munza"),
            "param_name"        => "featured",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "param_name"        => "align",
            "value"             => array(
                esc_html__( "Left" , 'munza' )    => "",
                esc_html__( "Center" , 'munza' )  => "center",
                esc_html__( "Right" , 'munza' )   => "right",
            ),
            "std"               => "center"
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Margin (px)" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "mar_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_left",
        ),array(
            "type"              => "label",
            "heading"           => '',
            "edit_field_class"  => "vc_col-xs-6 sm_inps sm_col",
            "param_name"        => "margin_sss",
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', 'munza' ),
            'param_name'        => 'bg_main',
            'edit_field_class'  => 'select_bxs lg-items vc_column vc_col-xs-12',
            'value'             => array(
                  esc_html__( 'Color', 'munza' )      => 'color',
                  esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', 'munza' ),
            'param_name'        => 'bg_color',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element'  => 'bg_main',
                'value'    => array('color'),
            ),
        ),array(
            'type'              => 'gradientpicker',
            'heading'           => esc_html__( 'Gradient', 'munza' ),
            'param_name'        => 'bg_grad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element'  => 'bg_main',
                'value'    => 'gradient',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Border Width (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "bwdth",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "bord_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "border_color",  
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "pric_bord_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "std"               => "none",
            "value"             => array(
                esc_html__( "None" , 'munza' )   => "none",
                esc_html__( "Solid" , 'munza' )  => "solid",
                esc_html__( "Dashed" , 'munza' ) => "dashed",
                esc_html__( "Dotted" , 'munza' ) => "dotted",
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "bor_radius",
            "value"             => "0",
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Box Shadow', 'munza' ),
            'param_name'        => 'idl_shad',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "numberfield",
            "heading"           => 'Shadow Properties (px)',
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lbl1",
            'dependency'        => array('element' => 'idl_shad', 'not_empty' => true),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad1",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad2",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "idl_shad3",
            'dependency'        => array(
                'element'  => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "edit_field_class"  => "vc_col-xs-2 sm_inps sm_col",
            "param_name"        => "idl_shad4",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "shd_color",
            'dependency'        => array(
                'element' => 'idl_shad', 'not_empty' => true
            ),
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),
        
        // Hover...
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "main_bg_hover_color",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Border Width (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "hover_bwdth",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "bord_hover_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "bord_hover_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "bord_hover_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "bord_hover_left",
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "border_hover_color",  
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "pric_hover_bord_style",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "std"               => "none",
            "value"             => array(
                esc_html__( "None" , 'munza' )   => "none",
                esc_html__( "Solid" , 'munza' )  => "solid",
                esc_html__( "Dashed" , 'munza' ) => "dashed",
                esc_html__( "Dotted" , 'munza' ) => "dotted",
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius (px)",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'group'             => esc_html__( 'Hover' , 'munza' ),
            "param_name"        => "bor_hover_radius",
            "value"             => "0",
        ),
        array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Animate On Hover?", "munza"),
            "param_name"        => "anim_hover",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hover Shadow', 'munza' ),
            'param_name'        => 'hover_shad',
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "shd_lblss",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("X-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd1",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Y-axis", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd2",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Blur", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "hover_shd3",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Spread", "munza"),
            "edit_field_class"  => "vc_col-xs-2 sm_inps sm_col",
            "param_name"        => "hover_shd4",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array(
                'element' => 'hover_shad', 'not_empty' => true
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Shadow Color",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "param_name"        => "hover_shd_color",
            'group'             => esc_html__( 'Hover' , 'munza' ),
            'dependency'        => array('element' => 'hover_shad', 'not_empty' => true),
        ),
        
        // Title...
        array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', 'munza' ),
            'param_name'        => 'titl_bg_main',
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'select_bxs lg-items vc_column vc_col-xs-12',
            'value'             => array(
                  esc_html__( 'Color', 'munza' )    => 'color',
                  esc_html__( 'Gradient', 'munza' ) => 'gradient',
            ),
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', 'munza' ),
            'param_name'        => 'titl_bg_color',
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element' => 'titl_bg_main',
                'value'   => array('color'),
            ),
        ),array(
            'type'              => 'gradientpicker',
            'heading'           => esc_html__( 'Background Gradient', 'munza' ),
            'param_name'        => 'titl_bg_grad',
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array(
                'element' => 'titl_bg_main',
                'value'   => 'gradient',
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "titl_bg_hover_color",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Title",'munza'),
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "param_name"        => "price_title",
            "value"             => "Pricing Table Title",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "titl_color", 
            "edit_field_class"  => "vc_column vc_col-xs-6",
            'group'             => esc_html__( 'Head' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "titl_hover_color", 
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Subtitle",'munza'),
            "param_name"        => "price_sub",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "value"             => "Pricing Subtitle",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "subtitle_color",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "subtitle_hover_color",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
        ),
        // Price...
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Price",'munza'),
            "param_name"        => "price_price",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => "99",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Currency symbol",'munza'),
            "param_name"        => "currency",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => "$",
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Interval",'munza'),
            "param_name"        => "interval",
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "value"             => "/ Month",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "price_color", 
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "price_hover_color", 
            'group'             => esc_html__( 'Head' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
        ),
        // Content...
        array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Content",'munza'),
            "param_name"        => "content",
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),array(
            'type'              => 'param_group',
            'heading'           => esc_html__('Features', 'munzas'),
            'param_name'        => 'tbl_feature',
            'value'             => urlencode( 
                json_encode( 
                    array(
                        array(
                            'feature_text' => 'Unlimited Updates',
                            'use_icon'     => '',
                            'icon_color'   => ''
                        ),
                        array(
                            'feature_text' => 'Free Emails',
                            'use_icon'     => '',
                            'icon_color'   => ''
                        ),
                        array(
                            'feature_text'=> 'Online Support',
                            'use_icon'    => '',
                            'icon_color'  => ''
                        ),
                    )
                ) 
            ),
            'params' => array(
                array(
                    'type'              => 'textfield',
                    'heading'           => esc_html__( 'Label', 'munza' ),
                    'param_name'        => 'feature_text',
                    'description'       => esc_html__( 'Enter text used for feature line.', 'munza' ),
                    'admin_label'       => true,
                ),
                array(
                    'type'              => 'checkbox',
                    'heading'           => esc_html__( 'Use Icon', 'munza' ),
                    'param_name'        => 'use_icon',
                    'value'             => array(
                        '' => '1',
                    ),
                ),
                array(
                    "type"              => "it_icon_pop",
                    "heading"           => esc_html__("Icon", "munza"),
                    "param_name"        => "icon_param",
                    'group'             => esc_html__( 'Icon' , 'munza' ),
                    'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
                ),
                array(
                    "type"              => "colorpicker",
                    "heading"           => esc_html__("Icon Color", "munza"),
                    "param_name"        => "icon_color",                  
                    'edit_field_class'  => 'vc_column vc_col-xs-12',
                    'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
                ),
            ),
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Alignment",'munza'),
            'edit_field_class'  => 'vc_column select_bxs vc_col-xs-12',
            "param_name"        => "content_align", 
            'group'             => esc_html__( 'Content' , 'munza' ),
            "value"             => array(
                esc_html__( "Left" , 'munza' )   => "",
                esc_html__( "Center" , 'munza' ) => "center",
                esc_html__( "Right" , 'munza' )  => "right",
            ),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "main_color",
            'group'             => esc_html__( 'Content' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "main_hover_color",
            'group'             => esc_html__( 'Content' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Dividers Color", "munza"),
            "param_name"        => "div_color",
            'group'             => esc_html__( 'Content' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Dividers Hover Color", "munza"),
            "param_name"        => "div_hover_color",
            'group'             => esc_html__( 'Content' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        
        // Label...
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Label Style",'munza'),
            "param_name"        => "pric_lbl_style",
            'group'             => esc_html__( 'Label' , 'munza' ),
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "value"             => array(
                esc_html__( "Clean Tag" , 'munza' )         => "tag",
                esc_html__( "Custom (upload)" , 'munza' )   => "upload",
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Label" , 'munza' ),
            "param_name"        => "lbl_txt",
            'group'             => esc_html__( 'Label' , 'munza' ),
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-12 sm_inps sm_col",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            "param_name"        => "lbl_font_size",
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "lbl_color",
            'edit_field_class'  => 'vc_column vc_col-xs-12', 
            'group'             => esc_html__( 'Label' , 'munza' ),
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "lbl_bg_color",                  
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            'group'             => esc_html__( 'Label' , 'munza' ), 
        ),array(
            "type"              => "label",
            "heading"           => esc_html__( 'Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "lbl_pad_lbl",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "lbl_padd_top",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "lbl_padd_right",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "lbl_padd_bottom",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-7 sm_inps sm_col",
            'dependency'        => array('element' => 'pric_lbl_style', 'value_not_equal_to' => 'upload'),
            "param_name"        => "lbl_padd_left",
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            'type'              => 'attach_image',
            'heading'           => esc_html__( 'Image', 'munza' ),
            'param_name'        => 'it_bg_img',
            'group'             => esc_html__( 'Label' , 'munza' ),
            'dependency'        => array('element' => 'pric_lbl_style','value' => 'upload',),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Offset (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
            "param_name"        => "off_lbl1",
            'group'             => esc_html__( 'Label' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Label' , 'munza' ),
            "param_name"        => "off_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Label' , 'munza' ),
            "param_name"        => "off_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            'group'             => esc_html__( 'Label' , 'munza' ),
            "param_name"        => "off_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-7 sm_inps sm_col",
            'group'             => esc_html__( 'Label' , 'munza' ),
            "param_name"        => "off_left",
        ),
        
        // Footer...
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "footer_bg_color",
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "footer_bg_hover_color",
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Add Button', 'munza' ),
            'param_name'        => 'add_btn',
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Button Text",'munza'),
            "param_name"        => "btn_txt",
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
            'group'             => esc_html__( 'Footer' , 'munza' ),
        ),
        array(
            "type"              => "vc_link",
            "heading"           => esc_html__("Link",'munza'),
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
            "param_name"        => "btn_link"
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Button Size",'munza'),
            "param_name"        => "btn_size",
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Footer' , 'munza' ),
            "value"             => array(
                esc_html__( 'Small' , 'munza' )    => 'sm',
                esc_html__( 'Normal' , 'munza' )   => 'md',
                esc_html__( 'Large' , 'munza' )    => 'lg',
                esc_html__( 'X-Large' , 'munza' )  => 'xl',
                esc_html__( 'XX-Large' , 'munza' ) => 'xxl',
            ),
            "std"               => "sm",
        ),
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Button Shape",'munza'),
            "param_name"        => "btn_shape",
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
            'edit_field_class'  => 'select_bxs vc_column lg_items vc_col-xs-12',
            'group'             => esc_html__( 'Footer' , 'munza' ),
            "value"             => array(
                esc_html__( 'Square' , 'munza' ) => 'square',
                esc_html__('Rounded' , 'munza' ) => 'rounded',
                esc_html__( 'Round' , 'munza' )  => 'round',
            ),
        ),
        array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Full Width", "munza"),
            "param_name"        => "full_btn",
            'edit_field_class'  => 'vc_column vc_col-xs-12 nowrp',
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'value'             => array(
                '' => '1',
            )
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "bt_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4', 
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "bt_bg_color",                  
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Footer' , 'munza' ), 
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "bt_border_color",                  
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Footer' , 'munza' ), 
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "bt_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4', 
            'group'             => esc_html__( 'Footer' , 'munza' ),
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover BG Color", "munza"),
            "param_name"        => "bt_hover_bg_color",                  
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Footer' , 'munza' ), 
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
        array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Hover Color", "munza"),
            "param_name"        => "bt_hover_border_color",                  
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Footer' , 'munza' ), 
            'dependency'        => array('element' => 'add_btn', 'not_empty' => true),
        ),
    )
);
    
