<?php
return array(
    "name"          => esc_html__("Recent Posts", "munza"),
    "base"          => "it_recent_posts",
    'category'      => esc_html__( 'Munza Shortcodes', 'munza' ),
    'icon'          => 'no-bg stline-book-close',
    'description'   => esc_html__( 'Add recent posts in page', 'munza' ),
    "params"        => array(
        array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Style",'munza'),
            "param_name"        => "rp_style",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "value"             => array(
                esc_html__( 'Style 1' , 'munza' )            => '1',
                esc_html__( 'Style 2' , 'munza' )            => '2',
                esc_html__( 'Simple' , 'munza' )             => '3',
                esc_html__( 'First Large Image' , 'munza' )  => '4',
                esc_html__( 'WP Widget Style' , 'munza' )    => '5',
            ),
            "description"       => esc_html__("select the recent posts style.",'munza')
         ),array(
            "type"              => "it_multiselect",
            "heading"           => esc_html__("Category",'munza'),
            "param_name"        => "it_cat",
            "value"             => it_dropdown_cats(),
            "description"       => esc_html__("type the item category.",'munza')
         ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Execlude Posts",'munza'),
            "param_name"        => "posts_exec",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            "description"       => esc_html__("Enter post ID to be execluded (separate each id with comma).",'munza')
         ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Image Size",'munza'),
            "param_name"        => "img_size",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "value"             => array(
                esc_html__( 'No Image' , 'munza' )                     => 'none',
                esc_html__( 'Thumbnail - 150x150' , 'munza' )          => 'thumbnail',
                esc_html__( 'Medium - 400x380' , 'munza' )             => 'blog-small-image',
                esc_html__( 'Large - 1024x1024' , 'munza' )            => 'large',
                esc_html__( 'Blog Large Image - 1170x470' , 'munza' )  => 'blog-large-image',
                esc_html__( 'Original Size' , 'munza' )                => 'full'
            ),                           
            "description"       => esc_html__("select the pager type.",'munza'),
            "std"               => 'large'
         ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Number Of Posts", "munza"),
            "param_name"        => "max_pos",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'value'             => '5',
            "description"       => esc_html__("Max. Number of Posts.", "munza"),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Max. Number of words", "munza"),
            "param_name"        => "max_words",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'value'             => '20',
            "description"       => esc_html__("Enter -1 to disable this.", "munza"),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Columns", "munza"),
            "param_name"        => "rp_cols",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                esc_html__( '1 Column' , 'munza' )   => '12',
                esc_html__( '2 Columns' , 'munza' )  => '6',
                esc_html__( '3 Columns' , 'munza' )  => '4',
                esc_html__( '4 Columns' , 'munza' )  => '3',
            ),
            "description"       => esc_html__("Number of coulmns per row.", "munza"),
            'dependency'        => array( 'element' => 'rp_style', 'value' => array('1','2','3') ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Title', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_title',
            'value'             => array( '' => '1' ),
            'std'               => '1',
            "description"       => esc_html__("Show post title.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Post Media', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_media',
            'value'             => array( '' => '1' ),
            'std'               => '1',
            "description"       => esc_html__("Show post Media.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Date', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_date',
            'std'               => '1',
            'value'             => array( '' => '1' ),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Author', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_auth',
            'value'             => array( '' => '1' ),
            'dependency'        => array( 'element' => 'rp_style', 'value_not_equal_to' => array('4','5') ),
            "description"       => esc_html__("Show Author.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Category', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_cat',
            'value'             => array( '' => '1' ),
            'std'               => '1',
            "description"       => esc_html__("Show post meta.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Content', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_except',
            'value'             => array( '' => '1' ),
            'std'               => '1',
            "description"       => esc_html__("Show post excerpt.",'munza'),
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Social Icons', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_socials',
            'value'             => array( '' => '1' ),
            'dependency'        => array( 'element' => 'rp_style', 'value_not_equal_to' => array('4','5') )
        ),array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Read More', 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'param_name'        => 'show_more',
            'value'             => array(
                '' => '1',
            ),
            'dependency'        => array( 'element' => 'rp_style', 'value_not_equal_to' => array('4','5') )
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Read More Text",'munza'),
            "param_name"        => "mor_txt",
            'std'               => 'Read More',
            'dependency'        => array( 'element' => 'show_more', 'not_empty' => true )
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),  
    )
);
    