<?php
return array(
    "name"              => esc_html__("Step", 'munza'),
    "base"              => "it_step",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    'description'       => esc_html__( 'Add Step', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-send-email',
    "as_child"          => array('only' => 'it_steps'),
    "params"            => array(
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Use Icon', 'munza' ),
            'param_name'        => 'use_icon',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1',
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Title",'munza'),
            "param_name"        => "step_title",
            'edit_field_class'  => 'vc_column vc_col-xs-9',
            "description"       => esc_html__("Step title.",'munza') ,
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "param_name"        => "title_color",
        ),array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Content",'munza'),
            "param_name"        => "content",  
        ),
        array(
            "type"              => "label",
            "heading"           => esc_html__( 'Content Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
            "param_name"        => "cont_padd_lbl",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "edit_field_class"  => "vc_col-xs-2 sm_inps sm_col",
            "param_name"        => "cont_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "edit_field_class"  => "vc_col-xs-2 sm_inps sm_col",
            "param_name"        => "cont_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "edit_field_class"  => "vc_col-xs-2 sm_inps sm_col",
            "param_name"        => "cont_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "edit_field_class"  => "vc_col-xs-3 sm_inps sm_col",
            "param_name"        => "cont_left",
        ),
        it_animation(),
        it_animation_delay(),
        it_animation_duration(),
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza"),
        ),array(
            "type"              => "it_icon_pop",
            "heading"           => esc_html__("Icon", "munza"),
            "param_name"        => "icon_param",
            'group'             => esc_html__( 'Icon' , 'munza' ),
            'dependency'        => array( 'element' => 'use_icon', 'not_empty' => true)
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Shape",'munza'),
            "param_name"        => "shape",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-6',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
            "value"             => array(
                esc_html__( 'Square' , 'munza' )    => '',
                esc_html__( 'Rounded' , 'munza' )   => 'rounded',
                esc_html__( 'Circle' , 'munza' )    => 'circle',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Width (px)", "munza"),
            "param_name"        => "icon_width",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Height (px)", "munza"),
            "param_name"        => "icon_height",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            "param_name"        => "icon_size",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'std'               => '#b400ff',
            "param_name"        => "color",
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "border_color",
            'std'               => '#b400ff',
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width (px)", "munza"),
            "param_name"        => "border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'std'               => '4',
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Border Style",'munza'),
            "param_name"        => "border_style",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ), 
            "value"             => array(
                esc_html__( "None" , 'munza' )    => "",
                esc_html__( "Solid" , 'munza' )   => "solid",
                esc_html__( "Dashed" , 'munza' )  => "dashed",
                esc_html__( "Dotted" , 'munza' )  => "dotted",
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "param_name"        => "hover_color",
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Background Color", "munza"),
            "param_name"        => "hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Border Color", "munza"),
            "param_name"        => "hover_border_color",
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ), array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Separator Color", "munza"),
            "param_name"        => "line_color",
            'std'               => '#b400ff',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Separator Height (PX)", "munza"),
            "param_name"        => "sep_height",
            'std'               => '6',
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            'dependency'        => array('element' => 'use_icon', 'not_empty' => true),
            'group'             => esc_html__( 'Icon' , 'munza' ),
        ),
    )
);
    
