<?php
return array(
    "name"              => esc_html__("Testimonial BlockQuote", 'munza'),
    "base"              => "it_testimonial",
    'category'          => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element"   => true,
    'icon'              => 'no-bg stline-messages-bubble-typing-1',
    "as_child"          => array('only' => 'it_testimonials'),
    "params"            => array(
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Author",'munza'),
            "param_name"        => "author",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)",'munza'),
            "param_name"        => "author_size",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "author_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "hover_author_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Position",'munza'),
            "param_name"        => "slogan",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size (px)", "munza"),
            "param_name"        => "slogan_size",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Color", "munza"),
            "param_name"        => "slogan_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "param_name"        => "hover_slogan_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
        ),array(
            "type"              => "attach_image",
            "heading"           => esc_html__("Image",'munza'),
            "param_name"        => "image",
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "dropdown",
            "heading"           => esc_html__("Image Size",'munza'),
            "param_name"        => "img_size",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Image' , 'munza' ),
            "value"             => array(
                esc_html__( 'Small - 40x40' , 'munza' )                 => '40x40',
                esc_html__( 'Small - 55x55' , 'munza' )                 => '55x55',
                esc_html__( 'Small - 70x70' , 'munza' )                 => '70x70',
                esc_html__( 'Medium - 100x100' , 'munza' )              => '100x100',
                esc_html__( 'Thumbnail - 150x150' , 'munza' )           => 'thumbnail',
                esc_html__( 'Medium - 400x380' , 'munza' )              => 'blog-small-image',
                esc_html__( 'Large - 1024x1024' , 'munza' )             => 'large',
                esc_html__( 'Blog Large Image - 1170x470' , 'munza' )   => 'blog-large-image',
                esc_html__( 'Original Size' , 'munza' )                 => 'full'
            ),                           
            "std"               => '55x55'
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Shape', 'munza' ),
            'param_name'        => 'img_shape',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-8',
            'group'             => esc_html__( 'Image' , 'munza' ),
            'value'             => array(
                esc_html__( 'Rounded', 'munza' )  => 'rounded',
                esc_html__( 'Square', 'munza' )   => 'square',
                esc_html__( 'Circle', 'munza' )   => 'circle',
            ),
            'std'               => 'rounded',
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Width", "munza"),
            "edit_field_class"  => "vc_column vc_col-xs-6",
            'group'             => esc_html__( 'Image' , 'munza' ),
            "param_name"        => "img_bord_width",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "img_border_color",
            "edit_field_class"  => "vc_column vc_col-xs-6",
            'group'             => esc_html__( 'Image' , 'munza' ),
        ),array(
            "type"              => "textarea_html",
            "heading"           => esc_html__("Content",'munza'),
            "param_name"        => "content",
            "group"             => esc_html__( "Content" , 'munza' ),
            "value"             => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar.",
        ),array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'cont_font_family',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
            'param_name'        => 'sgfont',
            'group'             => esc_html__( 'Content' , 'munza' ),
            'edit_field_class'  => 'gfonts',
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Hover Color", "munza"),
            "group"             => esc_html__( "Content" , 'munza' ),   
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "param_name"        => "hover_cont_color",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Font Size", "munza"),
            "param_name"        => "content_size",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Line Height (px)", "munza"),
            "param_name"        => "content_line_height",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content' , 'munza' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'content_weight',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'group'             => esc_html__( 'Content' , 'munza' ),
            'value'             => array(
                esc_html__( '-- Select --' , 'munza' ) => '',
                esc_html__( 'normal' , 'munza' ) => 'normal',
                esc_html__( 'bold' , 'munza' ) => 'bold',
                esc_html__( 'lighter' , 'munza' ) => 'lighter',
                esc_html__( 'bolder' , 'munza' ) => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit' , 'munza' ) => 'inherit'
            ),
        ),array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Show Quote Icon", "munza"),
            "param_name"        => "show_qte",
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Content' , 'munza' ),
            'value'             => array(
                '' => '1',
            ),
            'std'               => '1'
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Icon Style', 'munza' ),
            'param_name'        => 'qte_style',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-5',
            'group'             => esc_html__( 'Content' , 'munza' ),
            'value'             => array(
                esc_html__( 'Style 1', 'munza' ) => '1',
                esc_html__( 'Style 2', 'munza' ) => '2',
                esc_html__( 'Style 3', 'munza' ) => '3',
                esc_html__( 'Style 4', 'munza' ) => '4',
            ),
            'dependency'        => array(
                'element'   => 'show_qte',
                'not_empty' => true,
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Icon size (PX)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "param_name"        => "qte_size",
            "group"             => esc_html__( "Content" , 'munza' ),
            'dependency'        => array(
                'element'   => 'show_qte',
                'not_empty' => true,
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Icon Color", "munza"),
            "param_name"        => "qte_color",
            'edit_field_class'  => 'vc_column vc_col-xs-5',
            'group'             => esc_html__( 'Content' , 'munza' ),
            'dependency'        => array(
                'element'   => 'show_qte',
                'not_empty' => true,
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Icon Position (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop nowrp',
            "param_name"        => "poss_lbl",
            'dependency'        => array( 'element' => 'show_qte','not_empty' => true ),
            "group"             => esc_html__( "Content" , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            'dependency'        => array( 'element' => 'show_qte','not_empty' => true ),
            "group"             => esc_html__( "Content" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "qte_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            'dependency'        => array( 'element' => 'show_qte','not_empty' => true ),
            "group"             => esc_html__( "Content" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "qte_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            'dependency'        => array( 'element' => 'show_qte','not_empty' => true ),
            "group"             => esc_html__( "Content" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "qte_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            'dependency'        => array( 'element' => 'show_qte','not_empty' => true ),
            "group"             => esc_html__( "Content" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "qte_left",
        ),array(
            "type"              => "numberfield",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-6 no-input mtop',
            "param_name"        => "mar_lblaa6",
            "group"             => esc_html__( "Content" , 'munza' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Alignment', 'munza' ),
            'param_name'        => 'box_align',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            "group"             => esc_html__( "Design" , 'munza' ),
            'value'             => array(
                esc_html__( 'Left', 'munza' )     => '',
                esc_html__( 'Center', 'munza' )   => 'text-center',
                esc_html__( 'Right', 'munza' )    => 'text-right',
            ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            "param_name"        => "pad_lbl",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__( 'Margin (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "mar_lbl",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_left",
        ),array(
            "type"              => "numberfield",
            "heading"           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop',
            "param_name"        => "mar_lblaa",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Idle Styling" , 'munza' ),
            "group"             => esc_html__( "Design" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "idle_lbl",
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Background', 'munza' ),
            'param_name'        => 'test_bg',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
            'std'               => 'color',
            "group"             => esc_html__( "Design" , 'munza' ),
            'value'             => array(
                esc_html__( 'Color', 'munza' )      => 'color',
                esc_html__( 'Gradient', 'munza' )   => 'gradient',
            ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "numberfield",
            "heading"           => esc_html__("Border Radius", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_column vc_col-xs-2",
            "param_name"        => "border_radius",
        ),array(
            "type"              => "checkbox",
            "heading"           => esc_html__("Shadow ?", "munza"),
            "param_name"        => "shad",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Design" , 'munza' ),
            'value'             => array(
                '' => '1',
            )
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Background Color', 'munza' ),
            'param_name'        => 'bg_color',
            "group"             => esc_html__( "Design" , 'munza' ),
            'dependency'        => array(
                'element'   => 'test_bg',
                'value'     => array('color'),
            ),
        ),array(
            'type'              => 'gradientpicker',
            'param_name'        => 'test_bg_grad',
            "group"             => esc_html__( "Design" , 'munza' ),
            'dependency'        => array(
                'element'   => 'test_bg',
                'value'     => 'gradient',
            ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__( "Hover Styling" , 'munza' ),
            "group"             => esc_html__( "Design" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hover_lbl",
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Background Color", "munza"),
            "param_name"        => "hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "colorpicker",
            "heading"           => esc_html__("Border Color", "munza"),
            "param_name"        => "hover_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-9',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "group"             => esc_html__( "Design" , 'munza' ),
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        )
    )
);
