<?php
return array(
    "name"                      => esc_html__("Testimonials", "munza"),
    "base"                      => "it_testimonials",
    "as_parent"                 => array('only' => 'it_testimonial'),
    'icon'                      => 'no-bg stline-messages-bubble-text-1',
    'save_always'               => true,
    'category'                  => esc_html__( 'Munza Shortcodes', 'munza' ),
    "content_element"           => true,
    "show_settings_on_create"   => true,
    'description'               => esc_html__( 'Add testimonial parent container', 'munza' ),
    "params"                    => array(
        array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Style",'munza'),
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            "param_name"        => "block_style",
            "value" => array(
                esc_html__( 'Style 1' , 'munza' )   => '1',
                esc_html__( 'Style 2' , 'munza' )   => '2',
                esc_html__( 'Simple' , 'munza' )    => '3',
            ),
        ),
        array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Type",'munza'),
            "param_name"        => "block_type",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
            "value" => array(
                esc_html__( 'Normal' , 'munza' )    => 'normal',
                esc_html__( 'Carousel' , 'munza' )  => 'carousel',
                esc_html__( 'Grid' , 'munza' )      => 'grid',
            ),
         ),array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Columns",'munza'),
            "param_name"        => "grid_cols",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
            'dependency'        => array(
                'element'   => 'block_type',
                'value'     => array('grid','normal')
            ),
            "value" => array(
                esc_html__( '1 Column' , 'munza' )  => '12',
                esc_html__( '2 Columns' , 'munza' ) => '6',
                esc_html__( '3 Columns' , 'munza' ) => '4',
                esc_html__( '4 Columns' , 'munza' ) => '3',
                esc_html__( '5 Columns' , 'munza' ) => '15',
                esc_html__( '6 Columns' , 'munza' ) => '2',
            ),
        ),array(
            'type'              => "textfield",
            'heading'           => esc_html__("Extra class name", "munza"),
            "param_name"        => "el_class",
            "description"       => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "munza")
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__( 'Padding (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
            "param_name"        => "pad_lbl",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_top",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_right",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_bottom",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "padd_left",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__( 'Margin (px)' , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop text-right',
            "param_name"        => "mar_lbl",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Top", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_top",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Right", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_right",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Bottom", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_bottom",
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Left", "munza"),
            "group"             => esc_html__( "Design" , 'munza' ),
            "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
            "param_name"        => "margin_left",
        ),array(
            'type'              => "numberfield",
            'heading'           => '',
            'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop',
            "param_name"        => "mar_lblaa",
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "textfield",
            'heading'           => esc_html__( "Idle Styling" , 'munza' ),
            "group"             => esc_html__( "Design" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "idle_lbl",
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Background Color", "munza"),
            "param_name"        => "bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Border Color", "munza"),
            "param_name"        => "border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Border Width", "munza"),
            "param_name"        => "border_width",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "textfield",
            'heading'           => esc_html__( "Hover Styling" , 'munza' ),
            "group"             => esc_html__( "Design" , 'munza' ),
            'edit_field_class'  => 'vc_head',    
            "param_name"        => "hoverss_lbl",
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Background Color", "munza"),
            "param_name"        => "hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Border Color", "munza"),
            "param_name"        => "hover_border_color",
            'edit_field_class'  => 'vc_column vc_col-xs-8',
            "group"             => esc_html__( "Design" , 'munza' ),
        ),
        array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Type",'munza'),
            "param_name"        => "v_type", 
            "group"             => esc_html__( "Carousel" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value" => array(
                esc_html__( 'Horizontal' , 'munza' ) => 'horizontal',
                esc_html__( 'Vertical' , 'munza' )   => 'vertical',
            )
        ),array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Cursor",'munza'),
            "param_name"        => "v_cursor",      
            "group"             => esc_html__( "Carousel" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value" => array(
                esc_html__( 'Default' , 'munza' )   => '',
                esc_html__( 'Grab' , 'munza' )      => 'grab',
                esc_html__( 'Pointer' , 'munza' )   => 'pointer',
                esc_html__( 'Move' , 'munza' )      => 'move',
                esc_html__( 'Help' , 'munza' )      => 'help',
                esc_html__( 'Resize' , 'munza' )    => 'e-resizr',
                esc_html__( 'Progress' , 'munza' )  => 'progress',
            )
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Slides to show", "munza"),
            "param_name"        => "v_slides",
            "group"             => esc_html__( "Carousel" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => '1',
            "description"       => esc_html__("number of visible slides.", "munza")
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Slides to Scroll", "munza"),  
            'edit_field_class'  => 'vc_column vc_col-xs-2',  
            "group"             => esc_html__( "Carousel" , 'munza' ), 
            "param_name"        => "v_scroll",
            "value"             => '1',
            "description"       => esc_html__("No. of scrollable slides.", "munza")
        ),array(
            'type'              => "dropdown",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Carousel" , 'munza' ),
            'heading'           => esc_html__("Space between slides",'munza'),
            "param_name"        => "gap",
            "value" => array(
                'None' =>'0',
                '1px' =>'1px',
                '2px' =>'2px',
                '3px' =>'3px',
                '4px' =>'4px',
                '5px' =>'5px',
                '10px' =>'10px',
                '15px' =>'15px',
                '20px' =>'20px',
                '25px' =>'25px',
                '30px' =>'30px',
                '35px' =>'35px',
            ),
        ),array(
            'type'              => "checkbox",
            'heading'           => esc_html__("AutoPlay?", "munza"),
            "param_name"        => "v_auto",
            "group"             => esc_html__( "Carousel" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "value"             => array(
                '' => '1',
            )
        ),array(
            'type'              => "checkbox",
            'heading'           => esc_html__("Show Arrows?", "munza"),
            "param_name"        => "v_arrows",
            "group"             => esc_html__( "Navigation" , 'munza' ),
            "value"             => array(
                '' => '1',
            )
        ),array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Shape",'munza'),
            "param_name"        => "arrow_shape",
            'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            "value" => array(
                esc_html__( 'Circle' , 'munza' )    => 'circle',
                esc_html__( 'Rounded' , 'munza' )   => 'rounded',
                esc_html__( 'Square' , 'munza' )    => 'square',                
            ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Position",'munza'),
            "param_name"        => "arrow_pos",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            "value" => array(
                esc_html__( 'Top Right' , 'munza' )     => '',
                esc_html__( 'Top Center' , 'munza' )    => 'top-center',
                esc_html__( 'Top Left' , 'munza' )      => 'top-left',
                esc_html__( 'Bottom Right' , 'munza' )  => 'bottom-right',
                esc_html__( 'Bottom Center' , 'munza' ) => 'bottom-center',
                esc_html__( 'Bottom Left' , 'munza' )   => 'bottom-left',
                esc_html__( 'Sides' , 'munza' )         => 'sides',                
            ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "it_icon_pop",
            'heading'           => esc_html__("Previous Icon",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "param_name"        => "prev_icon",
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "it_icon_pop",
            'heading'           => esc_html__("Next Icon",'munza'),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "param_name"        => "next_icon",
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "textfield",
            'heading'           => esc_html__( "Idle Styling" , 'munza' ),
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "idl_lbl",
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Color", "munza"),
            "param_name"        => "arrow_color",
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Background Color", "munza"),
            "param_name"        => "arrow_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Border Color", "munza"),
            "param_name"        => "arrow_bord_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Border Width", "munza"),
            "param_name"        => "arrow_bord_width",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "textfield",
            'heading'           => esc_html__( "Hover Styling" , 'munza' ),
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'edit_field_class'  => 'vc_head',
            "param_name"        => "hover_lbl",
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Color", "munza"),
            "param_name"        => "arrow_hover_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Background Color", "munza"),
            "param_name"        => "arrow_hover_bg_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Border Color", "munza"),
            "param_name"        => "arrow_hover_bord_color",
            'edit_field_class'  => 'vc_column vc_col-xs-4',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_arrows', 
                'not_empty' => true
            ),
        ),array(
            'type'              => "checkbox",
            'heading'           => esc_html__("Show Bullets?", "munza"),
            "param_name"        => "v_dots",
            "group"             => esc_html__( "Navigation" , 'munza' ),
            "value"             => array(
                '' => '1',
            )
        ),array(
            'type'              => "dropdown",
            'heading'           => esc_html__("Bullets Style",'munza'),
            "param_name"        => "bullet_style",
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-7',
            "value" => array(
                esc_html__( 'Style 1' , 'munza' )   => '1',
                esc_html__( 'Style 2' , 'munza' )   => '2',
                esc_html__( 'Style 3' , 'munza' )   => '3',
            ),
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_dots', 
                'not_empty' => true
            ),
         ),array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Color", "munza"),
            "param_name"        => "bullet_color",
            'edit_field_class'  => 'vc_column vc_col-xs-2',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_dots', 
                'not_empty' => true
            ),
        ),
        array(
            'type'              => "colorpicker",
            'heading'           => esc_html__("Active Color", "munza"),
            "param_name"        => "act_bullet_color",
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "group"             => esc_html__( "Navigation" , 'munza' ),
            'dependency'        => array(
                'element'   => 'v_dots', 
                'not_empty' => true
            ),
        ),
        
    ),
    "js_view" => 'VcColumnView'
);