<?php
return array(
    "name"                      => esc_html__("Twitter Box", 'munza'),
    "base"                      => "it_twitter",
    'category'                  => array(esc_html__( 'Munza Shortcodes', 'munza' ),'Social'),
    'icon'                      => 'no-bg fa fa-twitter',
    'description'               => esc_html__( 'Add Latest tweets box', 'munza' ),
    "content_element"           => true,
    "show_settings_on_create"   => true,
    "params"                    => array(
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Twitter User Name', 'munza' ),
            'param_name'        => 'twit_user',
            'description'       => esc_html__( 'Add your twitter user name.', 'munza' ),
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Tweets Number', 'munza' ),
            'param_name'        => 'tw_num',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "std"               => '4',
            'description'       => esc_html__( 'Maximum number of tweets.', 'munza' ),
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Height (px)', 'munza' ),
            'param_name'        => 'twit_height',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            'description'       => esc_html__( 'Set box Height ( Not applied if you select Carousel ).', 'munza' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Hide Avatar ?', 'munza' ),
            'param_name'        => 'hide_avatar',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "value"             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),
        array(
            'type'              => 'checkbox',
            'heading'           => esc_html__( 'Carousel ?', 'munza' ),
            'param_name'        => 'is_slider',
            'edit_field_class'  => 'vc_column vc_col-xs-3',
            "std"               => '1',
            'description'       => esc_html__( 'If selected, tweets will be shown in Carousel mode.', 'munza' ),
            "value"             => array( esc_html__( 'Yes', 'munza' ) => '1' ),
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Slides to show", "munza"),
            'param_name'        => "v_slides",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "value"             => '1',
            'dependency'        => array( 'element' => 'is_slider', 'not_empty' => true),
            "description"       => esc_html__("number of visible slides.", "munza")
        ),array(
            'type'              => "numberfield",
            'heading'           => esc_html__("Slides to Scroll", "munza"),
            'param_name'        => "v_scroll",
            'edit_field_class'  => 'vc_column vc_col-xs-6',
            "value"             => '1',
            'dependency'        => array( 'element' => 'is_slider', 'not_empty' => true),
            "description"       => esc_html__("number of slides that will scroll.", "munza")
        ),
        array(
            'type'              => 'it_google_fonts',
            'heading'           => esc_html__( 'Font Family', 'munza' ),
            'param_name'        => 'font_family',
            'edit_field_class'  => 'vc_column vc_col-xs-12',
            'group'             => esc_html__( 'Typography' , 'munza' ),
        ),array(
            'type'              => 'label',
            'heading'           => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
            'param_name'        => 'sgfont',
            'group'             => esc_html__( 'Typography' , 'munza' ),
            'edit_field_class'  => 'gfonts',
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Color', 'munza' ),
            'param_name'        => 'font_color',
            'edit_field_class'  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Typography' , 'munza' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Weight', 'munza' ),
            'param_name'        => 'font_weight',
            'edit_field_class'  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Typography' , 'munza' ),
            "value"             => array(
                esc_html__( '-- Select --' , 'munza' ) => '',
                esc_html__( 'normal' , 'munza' ) => 'normal',
                esc_html__( 'bold' , 'munza' ) => 'bold',
                esc_html__( 'lighter' , 'munza' ) => 'lighter',
                esc_html__( 'bolder' , 'munza' ) => 'bolder',
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
                esc_html__( 'inherit' , 'munza' ) => 'inherit'
            ),
        ),
        array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Font Size (px)', 'munza' ),
            'param_name'        => 'font_size',
            'edit_field_class'  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Typography' , 'munza' ),
            "std"               => '15'
        ),array(
            'type'              => 'numberfield',
            'heading'           => esc_html__( 'Line Height (px)', 'munza' ),
            'param_name'        => 'line_height',
            'edit_field_class'  => "vc_column vc_col-xs-2",
            'group'             => esc_html__( 'Typography' , 'munza' ),
        ),array(
            'type'              => 'dropdown',
            'heading'           => esc_html__( 'Font Style', 'munza' ),
            'param_name'        => 'font_style',
            'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
            'group'             => esc_html__( 'Typography' , 'munza' ),
            "value"             => array(
                'Normal' => '',
                'Italic' => 'italic',                
            ),
        ),array(
            'type'              => 'colorpicker',
            'heading'           => esc_html__( 'Links Color', 'munza' ),
            'param_name'        => 'links_color',
            'edit_field_class'  => "vc_column vc_col-xs-12",
            'group'             => esc_html__( 'Typography' , 'munza' ),
        ),
        array(
            'type'              => 'textfield',
            'heading'           => esc_html__( 'Extra class name', 'munza' ),
            'param_name'        => 'el_class',
            'description'       => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'munza' )
        )
    )
);
    
