<?php

if( ! function_exists( 'accordion_atts' ) ){
    function accordion_atts() {
        return array (
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Shape', 'munza' ),
                'base'              => 'vc_tta_accordion',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
                'param_name'        => 'shape',
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'value'             => array(
                    esc_html__( 'Square' , 'munza' )    => 'square',
                    esc_html__( 'Rounded' , 'munza' )   => 'rounded',
                    esc_html__( 'Round' , 'munza' )     => 'round',
                ),
                'std'               => 'square',
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Heading" , 'munza' ),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idle_lbl",
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Color', 'munza' ),
                'param_name'        => 'acc_t_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Background Color', 'munza' ),
                'param_name'        => 'acc_t_bg_color',
                'edit_field_class'  => 'vc_column vc_col-xs-10',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => "label",
                'heading'           => esc_html__( 'Border Width (px)' , 'munza' ),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-2 no-input mtop',
                'param_name'        => "bord_lbl",
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Top", 'munza'),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "acc_t_border_top",
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Right", 'munza'),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "acc_t_border_right",
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Bottom", 'munza'),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "acc_t_border_bottom",
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Left", 'munza'),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "acc_t_border_left",
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Border Color', 'munza' ),
                'param_name'        => 'acc_t_border_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => "dropdown",
                'heading'           => esc_html__("Border Style",'munza'),
                'param_name'        => "acc_t_border_style",
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ), 
                "value"             => array(
                    esc_html__( "None" , 'munza' )     => "none",
                    esc_html__( "Solid" , 'munza' )    => "solid",
                    esc_html__( "Dashed" , 'munza' )   => "dashed",
                    esc_html__( "Dotted" , 'munza' )   => "dotted",
                ),
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Active Heading" , 'munza' ),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "act_lbl",
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Color', 'munza' ),
                'param_name'        => 'act_acc_t_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Background Color', 'munza' ),
                'param_name'        => 'act_acc_t_bg_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => "dropdown",
                'heading'           => esc_html__("Border Style",'munza'),
                'param_name'        => "act_acc_t_border_style",
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ), 
                "value"             => array(
                    esc_html__( "Inherit" , 'munza' )  => "",
                    esc_html__( "Solid" , 'munza' )    => "solid",
                    esc_html__( "Dashed" , 'munza' )   => "dashed",
                    esc_html__( "Dotted" , 'munza' )   => "dotted",
                ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Border Color', 'munza' ),
                'param_name'        => 'act_acc_t_border_color',
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Icon Styling" , 'munza' ),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "icon_lbl",
            ),array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'Font size', 'munza' ),
                'param_name'        => 'acc_icon_size',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Color', 'munza' ),
                'param_name'        => 'acc_icon_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Active Color', 'munza' ),
                'param_name'        => 'act_acc_icon_color',
                'edit_field_class'  => 'vc_column vc_col-xs-8',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Content Styling" , 'munza' ),
                'group'             => esc_html__( 'Styling' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "cont_lbl",
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Color', 'munza' ),
                'param_name'        => 'sec_acc_color',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Background Color', 'munza' ),
                'param_name'        => 'sec_acc_bg_color',
                'edit_field_class'  => 'vc_column vc_col-xs-10',
                'group'             => esc_html__( 'Styling' , 'munza' ),
            ),array(
                'type'              => 'css_editor',
                'heading'           => esc_html__( 'Css', 'munza' ),
                'param_name'        => 'css',
                'group'             => esc_html__( 'Design Options' , 'munza' ),
                'base'              => 'vc_tta_accordion',
            ),                
        );    
    }    
}

$ac_nf_param = WPBMap::getParam( 'vc_tta_accordion', 'no_fill' );
$ac_nf_param['edit_field_class'] = 'vc_column vc_col-xs-3';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_nf_param );

$ac_gp_param = WPBMap::getParam( 'vc_tta_accordion', 'gap' );
$ac_gp_param['edit_field_class'] = 'vc_column vc_col-xs-2';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_gp_param );
        
$ac_sp_param = WPBMap::getParam( 'vc_tta_accordion', 'spacing' );
$ac_sp_param['edit_field_class'] = 'vc_column vc_col-xs-2';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_sp_param );

$ac_al_param = WPBMap::getParam( 'vc_tta_accordion', 'c_align' );
$ac_al_param['edit_field_class'] = 'select_bxs vc_column vc_col-xs-5';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_al_param );

$ac_colp_param = WPBMap::getParam( 'vc_tta_accordion', 'collapsible_all' );
$ac_colp_param['edit_field_class'] = 'vc_column vc_col-xs-3';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_colp_param );

$ac_aut_param = WPBMap::getParam( 'vc_tta_accordion', 'autoplay' );
$ac_aut_param['edit_field_class'] = 'vc_column vc_col-xs-2';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_aut_param );

$ac_ic_param = WPBMap::getParam( 'vc_tta_accordion', 'c_icon' );
$ac_ic_param['edit_field_class'] = 'select_bxs lg_items vc_column vc_col-xs-7';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_ic_param );

$ac_icp_param = WPBMap::getParam( 'vc_tta_accordion', 'c_position' );
$ac_icp_param['edit_field_class'] = 'select_bxs lg_items hidden vc_column vc_col-xs-3';
$ac_icp_param['std'] = 'right';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_icp_param );  

$ac_acs_param = WPBMap::getParam( 'vc_tta_accordion', 'active_section' );
$ac_acs_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_acs_param );


$ac_anm_param = WPBMap::getParam( 'vc_tta_accordion', 'css_animation' );
$ac_anm_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_accordion', $ac_anm_param );

vc_remove_param( 'vc_tta_accordion',    "title" );
vc_remove_param( 'vc_tta_accordion',    "css" );
vc_remove_param( 'vc_tta_accordion',    "color" );
vc_remove_param( 'vc_tta_accordion',    "shape" );
vc_remove_param( 'vc_tta_accordion',    "style" );
vc_add_params( 'vc_tta_accordion',      accordion_atts() );
vc_map_update( 'vc_tta_accordion',      accordion_atts() );