<?php

if( ! function_exists( 'column_atts' ) ){
    function column_atts() {
        return array (
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Gradient Background ?', 'munza' ),
                'param_name'        => 'grad_bg',
                'value'             => array( '' => '1' ),
                'weight'            => 5,
            ),
            array(
                'type'              => 'gradientpicker',
                'heading'           => '',
                'param_name'        => 'col_bg_grad',
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'grad_bg',
                    'not_empty' => true
                ),
            ),
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background Position', 'munza' ),
                'param_name'        => 'bg_image_position',
                'value'             => array(
                    esc_html__( 'Left Top', 'munza' ) => '',
                    esc_html__( 'Left Center', 'munza' ) => '0% 50%',
                    esc_html__( 'Left Bottom', 'munza') => '0% 100%',
                    esc_html__( 'Right Top', 'munza') => '100% 0%',
                    esc_html__( 'Right Center', 'munza' ) => '100% 50%',
                    esc_html__( 'Right Bottom', 'munza' ) => '100% 100%',
                    esc_html__( 'Center Top', 'munza') => '50% 0%',
                    esc_html__( 'Center Center', 'munza') => '50% 50%',
                    esc_html__( 'Center Bottom', 'munza' ) => '50% 100%'
                ),   
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Box Shadow', 'munza' ),
                'param_name'        => 'idl_shad',
                'weight'            => 4,
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'value'             => array(
                    '' => '1',
                )
            ),
            array(
                'type'              => "label",
                'heading'           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
                'param_name'        => "shd_lbl1",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("X", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad1",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Y", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad2",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Blur", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad3",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Spread", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad4",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "colorpicker",
                'heading'           => esc_html__("Shadow Color",'munza'),
                'edit_field_class'  => 'vc_column vc_col-xs-5',
                'param_name'        => "shd_color",
                'weight'            => 4,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),              
        );    
    }    
}

vc_remove_param( "vc_column",           "css_animation" );
vc_remove_param( "vc_column_inner",     "css_animation" );
vc_add_params( "vc_column",             column_atts() );
vc_map_update( 'vc_column',             column_atts() );
vc_add_params( "vc_column_inner",       column_atts() );
vc_map_update( 'vc_column_inner',       column_atts() );