<?php

if( ! function_exists( 'progress_atts' ) ){
    function progress_atts() {
        return array (
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Style', 'js_composer' ),
                'param_name'        => 'barsstyle',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
                'weight'            => 99,
                'value'             => array(
                    esc_html__( 'Style 1', 'munza' ) => 'prog1',
                    esc_html__( 'Style 2', 'munza' ) => 'prog2',
                    esc_html__( 'Style 3', 'munza' ) => 'prog3',
                    esc_html__( 'Style 4', 'munza' ) => 'prog4',
                ),
                'description'       => esc_html__( 'Select bar Style.', 'js_composer' ),
                'admin_label'       => true
            ),
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Shape', 'js_composer' ),
                'param_name'        => 'barshape',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-8',
                'weight'            => 99,
                'value'             => array(
                    esc_html__( 'Square', 'munza' ) => 'square',
                    esc_html__( 'Rounded', 'munza' ) => 'rounded',
                ),
                'description'       => esc_html__( 'Select bar Shape.', 'js_composer' ),
                'admin_label'       => true
            ),
            array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Bars Background color', 'js_composer' ),
                'param_name'        => 'barsbgcolor',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
                'weight'            => 99,
                'description'       => esc_html__( 'Select custom color.', 'js_composer' ),
            )                
        );    
    }    
}

$pr_param = WPBMap::getParam( 'vc_progress_bar', 'title' );
$pr_param['weight'] = 1000;        
vc_update_shortcode_param( 'vc_progress_bar', $pr_param );

$pr_un_param = WPBMap::getParam( 'vc_progress_bar', 'units' );
$pr_un_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_progress_bar', $pr_un_param );

$pr_col_param = WPBMap::getParam( 'vc_progress_bar', 'bgcolor' );
$pr_col_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_progress_bar', $pr_col_param );

$pr_tcol_param = WPBMap::getParam( 'vc_progress_bar', 'customtxtcolor' );
$pr_tcol_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_progress_bar', $pr_tcol_param );

$pr_bcol_param = WPBMap::getParam( 'vc_progress_bar', 'custombgcolor' );
$pr_bcol_param['edit_field_class'] = 'vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_progress_bar', $pr_bcol_param );

vc_add_params( 'vc_progress_bar',       progress_atts() );
vc_map_update( 'vc_progress_bar',       progress_atts() );