<?php

if( ! function_exists( 'row_atts' ) ){
    function row_atts() {
        return array (
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Padding', 'munza' ),
                'param_name'        => 'row_padd',
                'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
                'value'             => array(
                    esc_html__( 'None', 'munza' )     => 'no-padding',
                    esc_html__( 'XX-Small', 'munza' ) => 'xxs-padding',
                    esc_html__( 'X-Small', 'munza' )  => 'xs-padding',
                    esc_html__( 'Small', 'munza' )    => 'sm-padding',
                    esc_html__( 'Normal', 'munza' )   => 'md-padding',
                    esc_html__( 'Large', 'munza' )    => 'lg-padding',
                    esc_html__( 'X-Large', 'munza' )  => "xl-padding",
                    esc_html__( 'XX-Large', 'munza' ) => "xxl-padding",
                ),
                "std"               => 'md-padding',
                'weight' => 10,
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Full Width', 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'param_name'        => 'fluid',
                'value'             => array( '' => '1' ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Stretch Content', 'munza' ),
                'param_name'        => 'full_content',
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'value'             => array( '' => '1' ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Equal height', 'munza' ),
                'param_name'        => 'equal_height',
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'value'             => array( esc_html__( 'Yes', 'munza' ) => 'yes' )
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Full height', 'munza' ),
                'param_name'        => 'full_height',
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'value'             => array( esc_html__( 'Yes', 'munza' ) => 'yes' ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Align', 'munza' ),
                'param_name'        => 'row_align',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'value'             => array(
                      esc_html__( 'Default', 'munza' )  => '',
                      esc_html__( 'Left', 'munza' )     => 'text-left',
                      esc_html__( 'Center', 'munza' )   => 'text-center',
                      esc_html__( 'Right', 'munza' )    => 'text-right',
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Z-index", "munza"),
                'edit_field_class'  => "vc_column vc_col-xs-2",
                'param_name'        => "row_ind",
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Box Shadow', 'munza' ),
                'param_name'        => 'idl_shad',
                'edit_field_class'  => 'vc_column vc_col-xs-8',
                'value'             => array(
                    '' => '1',
                )
            ),
            array(
                'type'              => "label",
                'heading'           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
                'param_name'        => "shd_lbl1",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("X", "munza"),
                'edit_field_class'  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad1",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Y", "munza"),
                'edit_field_class'  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad2",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Blur", "munza"),
                'edit_field_class'  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad3",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Spread", "munza"),
                'edit_field_class'  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad4",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "colorpicker",
                'heading'           => esc_html__("Shadow Color",'munza'),
                'edit_field_class'  => 'vc_column vc_col-xs-5',
                'param_name'        => "shd_color",
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__("Extra class name", "munza"),
                'param_name'        => "el_class",
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                "description"       => esc_html__("Add an extra class name to this element.", "munza")
            ),array(
                'type'              => 'textfield',
                'heading'           => esc_html__( 'Row ID', 'munza' ),
                'param_name'        => 'extra_id',
                'edit_field_class'  => 'vc_column vc_col-xs-6',
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background', 'munza' ),
                'param_name'        => 'bg_main',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                      esc_html__( 'None', 'munza' )       => '',
                      esc_html__( 'Color', 'munza' )      => 'color',
                      esc_html__( 'Gradient', 'munza' )   => 'gradient',
                      esc_html__('Image', 'munza')        => 'image',
                      esc_html__('Video', 'munza')        => 'video'
                ),
                'weight'            => 9,
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Background Color', 'munza' ),
                'param_name'        => 'section_bg_color',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => array('color','image','video'),
                ),
            ),array(
                'type'              => 'gradientpicker',
                'param_name'        => 'section_bg_grad',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => 'gradient',
                ),
            ),array(
                'type'              => 'attach_image',
                'heading'           => esc_html__( 'Background Image', 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'param_name'        => 'it_bg_img',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => 'image',
                ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background Repeat', 'munza' ),
                'param_name'        => 'bg_image_repeat',
                'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-8',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                      esc_html__( 'Repeat', 'munza' )       => '',
                      esc_html__( 'Horizontally', 'munza' ) => 'repeat-x',
                      esc_html__('Vertically', 'munza')     => 'repeat-y',
                      esc_html__('None', 'munza')           => 'no-repeat'
                ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => 'image',
                ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background Attachment', 'munza' ),
                'param_name'        => 'bg_image_attachment',
                'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-4',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                    esc_html__( 'Scroll', 'munza' ) => '',
                    esc_html__( 'Fixed', 'munza' ) => 'fixed',
                ),     
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'             => 'image',
                ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background Size', 'munza' ),
                'param_name'        => 'bg_cover',
                'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-8',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                    esc_html__('Inherit','munza') => '',
                    esc_html__( 'Cover', 'munza' ) => 'cover',
                    esc_html__( 'Contain', 'munza' ) => 'contain',
                    '100%' => '100% 100%',
                ),    
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'             => 'image',
                ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Background Position', 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-4',
                'param_name'        => 'bg_image_position',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                    esc_html__( 'Left Top', 'munza' ) => '',
                    esc_html__( 'Left Center', 'munza' ) => '0% 50%',
                    esc_html__( 'Left Bottom', 'munza') => '0% 100%',
                    esc_html__( 'Right Top', 'munza') => '100% 0%',
                    esc_html__( 'Right Center', 'munza' ) => '100% 50%',
                    esc_html__( 'Right Bottom', 'munza' ) => '100% 100%',
                    esc_html__( 'Center Top', 'munza') => '50% 0%',
                    esc_html__( 'Center Center', 'munza') => '50% 50%',
                    esc_html__( 'Center Bottom', 'munza' ) => '50% 100%'
                ),  
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => 'image',
                ), 
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Video Type', 'munza' ),
                'param_name'        => 'vid_type',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-12',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                    esc_html__( 'Self Hosted', 'munza' ) => 'self',
                    esc_html__( 'Youtube', 'munza' ) => 'yout',
                ),    
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'   => 'video',
                ),
            ),array(
                'type'              => 'attach_image',
                'heading'           => esc_html__( 'Video Poster', 'munza' ),
                'param_name'        => 'video_poster',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'self',
                ),
            ),array(
                'type'              => 'it_video_bg',
                'heading'           => esc_html__( 'video/mp4', 'munza' ),
                'param_name'        => 'video_mp4',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'self',
                ),
            ),array(
                'type'              => 'it_video_bg',
                'heading'           => esc_html__( 'video/webm', 'munza' ),
                'param_name'        => 'video_webm',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'self',
                ),
            ),array(
                'type'              => 'it_video_bg',
                'heading'           => esc_html__( 'video/ogv', 'munza' ),
                'param_name'        => 'video_ogv',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'self',
                ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Loop Video', 'munza' ),
                'param_name'        => 'video_loop',
                'value'             => array( '' => '1' ),
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'self',
                ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'YouTube video', 'munza' ),
                'param_name'        => 'video_bg',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'description'       => esc_html__( 'If checked, YouTube video will be used as row background.', 'munza' ),
                'value'             => array( esc_html__( 'Yes', 'munza' ) => 'yes' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'yout',
                ),
            ),array(
                'type'              => 'textfield',
                'heading'           => esc_html__( 'YouTube link', 'munza' ),
                'param_name'        => 'video_bg_url',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => 'https://www.youtube.com/watch?v=lMJXxhRFO1k',
                'description'       => esc_html__( 'Add YouTube link.', 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'   => 'yout',
                ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Parallax', 'munza' ),
                'param_name'        => 'video_bg_parallax',
                'value'             => array( '' => '1' ),
                'group'             => esc_html__( 'Background' , 'munza' ),
                'description'       => esc_html__( 'Add parallax type background for row.', 'munza' ),
                'dependency'        => array(
                    'element' => 'vid_type',
                    'value'             => 'yout',
                ),
            ),
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Animate Background', 'munza' ),
                'param_name'        => 'anim_bg',
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'value'             => array( '' => '1' ),
                'group'             => esc_html__( 'Background' , 'munza' ),
                'description'       => esc_html__( 'make the row background moves continuously.', 'munza' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value'             => 'image',
                ),
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Animation Direction', 'munza' ),
                'param_name'        => 'anim_dir',
                'description'       => 'Choose the background animation direction',
                'edit_field_class'  => 'select_bxs lg_items vc_column vc_col-xs-12',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'value'             => array(
                    esc_html__( 'To Right' , 'munza' )  => 'toright',
                    esc_html__( 'To Left' , 'munza' )   => 'toleft',
                    esc_html__( 'To Top' , 'munza' )    => 'totop',
                    esc_html__( 'To Bottom' , 'munza' ) => 'tobottom',
                ),    
                'dependency'        => array(
                    'element' => 'anim_bg',
                    'not_empty' => true
                ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Parallax', 'munza' ),
                'param_name'        => 'parallax',
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'value'             => array( '' => '1' ),
                'group'             => esc_html__( 'Background' , 'munza' ),
                'description'       => esc_html__( 'Add parallax type background for row.', 'munza' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value' => 'image',
                ),
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Overlay ?', 'munza' ),
                'param_name'        => 'bg_overlay',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'description'       => esc_html__( 'Overlay on the background image.', 'munza' ),
                'value'             => array( '' => '1' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value' => array('image','video'),
                ),
            ),array(
                'type'              => 'colorpicker',
                'heading'           => esc_html__( 'Overlay Color', 'munza' ),
                'param_name'        => 'overlay_color',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'dependency'        => array( 'element' => 'bg_overlay', 'not_empty' => true)
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Skew ?', 'munza' ),
                'param_name'        => 'skew_bg',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'value'             => array( __( 'Yes', 'munza' ) => 'yes' ),
                'dependency'        => array(
                    'element' => 'bg_main',
                    'value' => array('color','image','gradient','video'),
                ),
            ),array(
                'type'              => "dropdown",
                'heading'           => esc_html__("Custom Shape",'munza'),
                'param_name'        => "row_shape",
                'group'             => esc_html__( 'Background' , 'munza' ),
                'edit_field_class'  => 'select_bxs list_imgs vc_column vc_col-xs-12',
                "value" => array(
                    '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/skew.jpg">'   => '',
                    '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn1.jpg">'   => 'btn1',
                    '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn2.jpg">'   => 'btn2',
                    '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn3.jpg">'   => 'btn3',
                    '<img alt="" src="'.Munza_THM_URI . 'assets/admin/images/btn4.jpg">'   => 'btn4',
                ),
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Alignment', 'munza' ),
                'param_name'        => 'skew_dir',
                'edit_field_class'  => 'select_bxs vc_column vc_col-xs-4',
                'group'             => esc_html__( 'Background' , 'munza' ),
                "std"               => 'left',
                'value'             => array(
                      esc_html__( 'Left', 'munza' )    => 'left',
                      esc_html__( 'Center', 'munza' )  => 'center',
                      esc_html__( 'Right', 'munza' )   => 'right',
                ),
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Width (%)", "munza"),
                'edit_field_class'  => "vc_column vc_col-xs-2",
                'group'             => esc_html__( 'Background' , 'munza' ),
                "std"               => '97',
                'param_name'        => "skew_width",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Height (%)", "munza"),
                'edit_field_class'  => "vc_column vc_col-xs-2",
                'group'             => esc_html__( 'Background' , 'munza' ),
                "std"               => '60',
                'param_name'        => "skew_height",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Degree", "munza"),
                'edit_field_class'  => "vc_column vc_col-xs-2",
                'group'             => esc_html__( 'Background' , 'munza' ),
                "std"               => '-12',
                'param_name'        => "skew_deg",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Border Radius (px)' , 'munza' ),
                'group'             => esc_html__( 'Background' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop nowrp text-right',
                'param_name'        => "padsss_lbl11",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'group'             => esc_html__( 'Background' , 'munza' ),
                'heading'           => esc_html__("Top Left", "munza"),
                'edit_field_class'  => "vc_col-xs-2 sm_inps sm_col",
                'param_name'        => "skew_radius_top",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'group'             => esc_html__( 'Background' , 'munza' ),
                'heading'           => esc_html__("Top Right", "munza"),
                'edit_field_class'  => "vc_col-xs-2 sm_inps sm_col",
                'param_name'        => "skew_radius_right",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'group'             => esc_html__( 'Background' , 'munza' ),
                'heading'           => esc_html__("Bottom Right", "munza"),
                'edit_field_class'  => "vc_col-xs-2 sm_inps sm_col",
                'param_name'        => "skew_radius_bottom",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'group'             => esc_html__( 'Background' , 'munza' ),
                'heading'           => esc_html__("Bottom Left", "munza"),
                'edit_field_class'  => "vc_col-xs-2 sm_inps sm_col",
                'param_name'        => "skew_radius_left",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => '',
                'group'             => esc_html__( 'Background' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-1 no-input mtop nowrp',
                'param_name'        => "padss_lbl11",
                'dependency'        => array( 'element' => 'skew_bg', 'not_empty' => true )
            ),array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Parallax ?', 'munza' ),
                'param_name'        => 'row_parallax',
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-12',
                'value'             => array( __( 'Yes', 'munza' ) => 'yes' ),
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Opacity" , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idl_lbl",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Start ( from 0 to 1)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "opacity_start",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'End ( from 0 to 1)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "opacity_end",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),
            array(
                'type'              => "textfield",
                'heading'           => esc_html__( "X-Axis" , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idls_lbl",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Start (in px)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "x_start",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'End (in px)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "x_end",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Y-Axis" , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idlss_lbl",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Start (in px)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "y_start",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'End (in px)' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "y_end",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Scale" , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idlsss_lbl",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Start ( from 0 to 1 )' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "scale_start",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'End ( from 0 to 1 )' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "scale_end",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "textfield",
                'heading'           => esc_html__( "Rotate" , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_head',
                'param_name'        => "idlssss_lbl",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'Start ( from 0 to 360 ) degree' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "rotate_start",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__( 'End ( from 0 to 360 ) degree' , 'munza' ),
                'group'             => esc_html__( 'Parallax' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-6',
                'param_name'        => "rotate_end",
                'dependency'        => array( 'element' => 'row_parallax', 'not_empty' => true )
            ),           
        );    
    }
}

vc_remove_param( "vc_row",  "gap" );
vc_remove_param( "vc_row",  "el_id" );
vc_remove_param( "vc_row",  "el_class" );
vc_remove_param( "vc_row",  "video_bg" );
vc_remove_param( "vc_row",  "parallax" );
vc_remove_param( "vc_row",  "full_width" );
vc_remove_param( "vc_row",  "full_height" );
vc_remove_param( "vc_row",  "video_bg_url" );
vc_remove_param( "vc_row",  "equal_height" );
vc_remove_param( "vc_row",  "video_bg_url" );
vc_remove_param( "vc_row",  "css_animation" );
vc_remove_param( "vc_row",  "parallax_image" );
vc_remove_param( "vc_row",  "disable_element" );
vc_remove_param( "vc_row",  "parallax_speed_bg" );
vc_remove_param( "vc_row",  "video_bg_parallax" );
vc_remove_param( "vc_row",  "content_placement" );
vc_remove_param( "vc_row",  "columns_placement" ); 
vc_remove_param( "vc_row",  "parallax_speed_video" );
vc_remove_param( "vc_row",  "rtl_reverse" );
vc_add_params( 'vc_row',    row_atts() );
vc_map_update( 'vc_row',    row_atts() );