<?php

if( ! function_exists( 'row_inner_atts' ) ){
    function row_inner_atts() {
        return array (
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Equal Height', 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'param_name'        => 'equal_height',
                'weight'            => 5,
                'value'             => array( '' => '1' ),
            ),
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Full Width', 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3',
                'param_name'        => 'full_row',
                'weight'            => 5,
                'value'             => array( '' => '1' ),
            ),
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Box Shadow', 'munza' ),
                'param_name'        => 'idl_shad',
                'weight'            => 5,
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'value'             => array(
                    '' => '1',
                )
            ),
            array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Z-index", 'munza'),
                "edit_field_class"  => "vc_column vc_col-xs-2",
                'param_name'        => "z_ind",
                'weight'            => 5,
            ),
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Align', 'munza' ),
                'param_name'        => 'row_align',
                'weight'            => 5,
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'value'             => array(
                      esc_html__( 'Default', 'munza' )  => '',
                      esc_html__( 'Left', 'munza' )     => 'text-left',
                      esc_html__( 'Center', 'munza' )   => 'text-center',
                      esc_html__( 'Right', 'munza' )    => 'text-right',
                ),
            ),
            array(
                'type'              => "label",
                'heading'           => esc_html__( 'Shadow Properties (px)' , 'munza' ),
                'edit_field_class'  => 'vc_column vc_col-xs-3 no-input mtop',
                'param_name'        => "shd_lbl1",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("X", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad1",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Y", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad2",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Blur", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad3",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "numberfield",
                'heading'           => esc_html__("Spread", 'munza'),
                "edit_field_class"  => "vc_col-xs-1 sm_inps sm_col",
                'param_name'        => "idl_shad4",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),array(
                'type'              => "colorpicker",
                'heading'           => esc_html__("Shadow Color",'munza'),
                'edit_field_class'  => 'vc_column vc_col-xs-5',
                'param_name'        => "shd_color",
                'weight'            => 5,
                'dependency'        => array(
                    'element' => 'idl_shad', 'not_empty' => true
                ),
            ),
            /*it_animation(),
            it_animation_delay(),
            it_animation_duration(),*/            
        );    
    }    
}

vc_remove_param( "vc_row_inner",        "gap" );
vc_remove_param( "vc_row_inner",        "equal_height" );        
vc_remove_param( "vc_row_inner",        "css_animation" );
vc_remove_param( "vc_row_inner",        "disable_element" );
vc_remove_param( "vc_row_inner",        "content_placement" );
vc_remove_param( "vc_row_inner",        "rtl_reverse" );
vc_add_params( 'vc_row_inner',          row_inner_atts() );
vc_map_update( 'vc_row_inner',          row_inner_atts() );
