<?php

if( ! function_exists( 'tabs_atts' ) ){
    function tabs_atts() {
        return array (
            array(
                'type'              => 'dropdown',
                'heading'           => esc_html__( 'Style', 'munza' ),
                'param_name'        => 'style',
                'edit_field_class'  => 'vc_column select_bxs lg_items vc_col-xs-12',
                'weight'            => 5,
                'value'             => array(
                    esc_html__( 'Default' , 'munza' )     => 'classic',
                    esc_html__( 'Creative' , 'munza' )    => 'creative',
                    esc_html__( 'Shadow' , 'munza' )      => 'with_shadow',
                ),
                "std"               => 'classic',
            ),
            array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'List Font Size', 'munza' ),
                'param_name'        => 'font_size',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
            ),
            array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'Padding Left', 'munza' ),
                'param_name'        => 'list_padd_lft',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
            ),
            array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'Padding Right', 'munza' ),
                'param_name'        => 'list_padd_rit',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
            ),
            array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'Padding Top', 'munza' ),
                'param_name'        => 'list_padd_top',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
            ),
            array(
                'type'              => 'numberfield',
                'heading'           => esc_html__( 'Padding Bottom', 'munza' ),
                'param_name'        => 'list_padd_bot',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
            ),
            array(
                'type'              => 'checkbox',
                'heading'           => esc_html__( 'Block Icon', 'munza' ),
                'param_name'        => 'block_icon',
                'edit_field_class'  => 'vc_column vc_col-xs-2',
                'weight'            => 5,
                'value'             => array(
                    '' => '1',
                )
            ),                
        );    
    }    
}

$tabs_param = WPBMap::getParam( 'vc_tta_tabs', 'title' );
$tabs_param['weight'] = 1000;        
vc_update_shortcode_param( 'vc_tta_tabs', $tabs_param );

$tb_shp_param = WPBMap::getParam( 'vc_tta_tabs', 'shape' );
$tb_shp_param['edit_field_class'] = 'select_bxs vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_shp_param );

$tb_fll_param = WPBMap::getParam( 'vc_tta_tabs', 'no_fill_content_area' );
$tb_fll_param['edit_field_class'] = 'select_bxs vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_fll_param );

$tb_pos_param = WPBMap::getParam( 'vc_tta_tabs', 'tab_position' );
$tb_pos_param['edit_field_class'] = 'select_bxs vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_pos_param );

$tb_al_param = WPBMap::getParam( 'vc_tta_tabs', 'alignment' );
$tb_al_param['edit_field_class'] = 'select_bxs vc_column vc_col-xs-6';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_al_param );

$tb_aut_param = WPBMap::getParam( 'vc_tta_tabs', 'autoplay' );
$tb_aut_param['edit_field_class'] = 'vc_column vc_col-xs-3';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_aut_param );

$tb_act_param = WPBMap::getParam( 'vc_tta_tabs', 'active_section' );
$tb_act_param['edit_field_class'] = 'vc_column vc_col-xs-4';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_act_param );

$tb_pg_param = WPBMap::getParam( 'vc_tta_tabs', 'pagination_style' );
$tb_pg_param['edit_field_class'] = 'vc_column vc_col-xs-5';
vc_update_shortcode_param( 'vc_tta_tabs', $tb_pg_param );

vc_remove_param( 'vc_tta_tabs',         "style" );
vc_remove_param( 'vc_tta_tabs',         "title" );
//vc_remove_param( 'vc_tta_tabs',         "no_fill_content_area" );
vc_remove_param( 'vc_tta_tabs',         "gap" );
vc_remove_param( 'vc_tta_tabs',         "spacing" );
vc_remove_param( 'vc_tta_tabs',         "color" );
vc_add_params( 'vc_tta_tabs',           tabs_atts() );
vc_map_update( 'vc_tta_tabs',           tabs_atts() );