<?php

if ( ! function_exists( 'munza_post_title' ) ) {
    function munza_post_title(){
        global $post;
        $output = '';
        $title_format   = munza_post_format_link( get_the_content(), get_the_title() );
        $output         .= $title_format['title'];        
        return $output;
    }
}

if ( ! function_exists( 'munza_post_summary' ) ){
    function munza_post_summary($max_words,$show_more,$mor_txt){
        global $post;
        
        $moreoutput     = '';      
        
        if ( $show_more == '1' ) {
            $more = " href='" . esc_url(get_permalink($post->ID)) . "'";
            $mtxt = esc_attr( $mor_txt );
            $moreoutput .= "<div class='more_container'><a class='box_more btn btn-sm'{$more}><span>{$mtxt}</span></a></div>";
        }
        
        $content = get_the_content();
        $content = strip_shortcodes( $content ); 
        
        if ( has_excerpt( $post->ID ) ){
            
            $content = get_the_excerpt();    
        
        } else if( strpos( $post->post_content, '<!--more-->' ) ) {
            
            $content = apply_filters('the_content', $content);
            $content = str_replace(']]>', ']]&gt;', $content);
        
        }        
        
        $content = ( $max_words != '-1' ) ? wp_trim_words( $content , $max_words , '...'. $moreoutput ) : "";
                                
        return $content;        
        
    } 
}

if ( ! function_exists( 'itr_allowed_tags' ) ){
    function itr_allowed_tags(){
        global $allowedtags;
        
        $attrs = array(
            'style'                 => array(),
            'id'                    => array(),
            'src'                   => array(),
            'alt'                   => array(),
            'title'                 => array(),
            'data-toggle'           => array(),
            'data-trigger'          => array(),
            'data-placement'        => array(),
            'data-content'          => array(),
            'data-original-title'   => array(),
            'href'                  => array(),
            'class'                 => array(),
        );
        
        $allowedtags['span']    = $attrs;
        $allowedtags['div']     = $attrs;
        $allowedtags['p']       = $attrs;
        $allowedtags['img']     = $attrs;
        $allowedtags['b']       = $attrs;
        $allowedtags['i']       = $attrs;
        $allowedtags['strong']  = $attrs;
        $allowedtags['a']       = $attrs;
        $allowedtags['u']       = $attrs;
        
        return $allowedtags;
    }
}

if ( ! function_exists( 'munza_author_meta' ) ) {
    function munza_author_meta ( $show_auth ) {
        $auth_id = get_the_author_meta('ID');
        $output = '<div class="author_meta_section">';
            $output .= '<span class="byline author vcard">';
                $output .= get_avatar( $auth_id, '32', '' );
                $output .= '<span>'.esc_html__( 'By: ','munza' ).'</span>';
                $output .= '<a href="'.get_author_posts_url( $auth_id ).'" rel="author">';
                    $output .= get_the_author();
                $output .= '</a>';
            $output .= '</span>';
        $output .= '</div>';
        
        if( $show_auth == '1' ) return $output;
        
    }
}

if ( ! function_exists( 'munza_author_inline' ) ) {
    function munza_author_inline ( $show_auth ) {
        $auth_id = get_the_author_meta('ID');
            $output = '<span class="byline author vcard">';
                $output .= get_avatar( $auth_id, '32', '' );
                $output .= '<a href="'.get_author_posts_url( $auth_id ).'" class="main-color" rel="author">';
                    $output .= get_the_author();
                $output .= '</a>';
            $output .= '</span>';
        
        if( $show_auth == '1' ) return $output;
        
    }
}

if ( ! function_exists( 'munza_post_image' ) ) {
    function munza_post_image( $content,$show_cats,$show_media ) {
        
        global $post;
        ob_start();
        ob_end_clean();
        $imgoutput = '';
        $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
        $first_img = $matches [1] [0];
        
        if ( is_singular() && is_single() ) {
            
            $imgoutput .= '<div class="details-img">';
                $imgoutput .= '<img alt="'.get_the_title().'" src="'.esc_url($first_img).'" />';
            $imgoutput .= '</div>';
            
        } else {
            
            if( !empty( $first_img ) ) {
                
                $imgoutput .= '<div class="post-image">';
                    $imgoutput .= '<a href="'.get_the_permalink().'">';
                        $imgoutput .= '<img alt="'.get_the_title().'" src="'.esc_url($first_img).'" />';
                    $imgoutput .= '</a>';
                $imgoutput .= '</div>';
                
            }else{
                munza_post_thumbnail();
            }
            
        }
        
        return $imgoutput;
        
    }
}

if ( ! function_exists( 'munza_post_media' ) ) {
    function munza_post_media( $content,$show_cats,$show_media ) {
        global $post;
        $output = '';
        $media = itr_getUrl( $content );
        $holder = itr_theme_option('img_placeholder');
        if( ! empty( $media ) ) {
            global $wp_embed;
            $content  = do_shortcode( $wp_embed->run_shortcode( '[embed]'. $media .'[/embed]' ) );
        } else {
            $pattern = itr_get_shortcode_regex( itr_wp_tagregexp() );
            preg_match( '/'.$pattern.'/s', $content, $media );
            if ( ! empty( $media[2] ) ) {
                if( $media[2] == 'embed' ) {
                    global $wp_embed;
                    $content = do_shortcode( $wp_embed->run_shortcode( $media[0] ) );
                } else {
                    
                    $gallery = get_post_gallery_images( $post );
                    
                    if ( get_post_format() == 'gallery' && ! empty( $gallery ) && ! empty( $media[0] ) ) {
                        $content = do_shortcode( $media[0] );
                    } else if ( get_post_format() != 'gallery' && ! empty( $media[0] ) ) {
                        $content = do_shortcode( $media[0] );
                    } else {
                        if ( get_the_post_thumbnail() ) {
                            $content = get_the_post_thumbnail();  
                        } else if( $holder ) {
                            $content = '<img alt="'.get_the_title().'" src="' . esc_url(get_parent_theme_file_uri("/assets/images/blog/placeholder.jpg")) .'" />';
                        }
                    }
                }
            }
        }
        
        if( ! empty( $media ) ) {
            $output .= (get_post_format() == 'gallery') ? '<div class="post-gallery">' : '<div class="post-media">';
                $output .= $content;
            $output .= '</div>';
            return $output;
        }
        //return false;
    }
}

if ( ! function_exists( 'munza_post_thumbnail' ) ) {
    function munza_post_thumbnail( $img_size,$show_media ) {
        global $post;
        $output = '';
        $holder = itr_theme_option('img_placeholder');
        if ( get_post_format() == 'gallery' || get_post_format() == 'video' || get_post_format() == 'audio' ) {
            
            $output .= munza_post_media( get_the_content(),'',$show_media );
            
        } else if ( get_post_format() == 'image' ) {
            
            if( has_post_thumbnail() ){
                $output .= '<div class="post-image post-img">';
                    $output .= '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                        $output .= get_the_post_thumbnail($post->ID,$img_size);  
                    $output .= '</a>'; 
                $output .= '</div>';
            } else {
                $output .= munza_post_image(get_the_content(),'',$show_media);
            }
            
        } else {
            
            if ( get_the_post_thumbnail() ) {
                
                $output .= '<div class="post-image post-img">';
                    $output .= '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                        $output .= get_the_post_thumbnail($post->ID,$img_size);  
                    $output .= '</a>';
                $output .= '</div>';
                
            } else if( $holder ) {
                 $output .= '<div class="post-image post-img">';
                    $output .= '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                        $output .= '<img alt="'.get_the_title().'" src="' . esc_url(get_parent_theme_file_uri("/assets/images/blog/placeholder.jpg")) .'" />';
                    $output .= '</a>';
                $output .= '</div>';
            } 
        }
        
        return $output;

    }
}

if ( ! function_exists( 'munza_listing_cat' ) ) {
    function munza_listing_cat (){
        $categories = get_the_category();
        if ( ! empty( $categories ) ) {
            return '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a>';
        }
    }
}

if ( ! function_exists ( 'munza_post_meta' ) ){
    function munza_post_meta ($show_auth){
        global $post;
        $cont = '<ul class="post-meta">';
            
            if ( $show_auth == '1' ){
                $cont .= '<li class="author_meta">'.itr_get_current_user().'</li>';
            }
            
            $cont .= '<li class="meta-cat">'.munza_listing_cat().'</li>';
            
            $num_comments = get_comments_number();
            if ( itr_theme_option('comment_on') == "1" ) {
                    if ( $num_comments == 0 ) {
                        $comments = esc_html__(' 0 Comments', 'munza');
                    } elseif ( $num_comments > 1 ) {
                        $comments = $num_comments . esc_html__(' Comments', 'munza');
                    } else {
                        $comments = esc_html__(' 1 Comment', 'munza');
                    }
                    $cont .= '<li><i class="stline-messages-bubble-text-1 main-color"></i><a href="' . get_comments_link() .'">'. $comments.'</a></li>';
            }

            $cont .= '<li>'.getPostLikeLink( $post->ID ).'</li>';
       
       $cont .= '</ul>';     
                        
        return $cont;
    }
}

//To keep the count accurate, lets get rid of prefetching..
if ( ! function_exists( 'munza_set_post_views' ) ) {
    function munza_set_post_views( $postID ) {
        $count_key = 'munza_post_views_count';
        $count = get_post_meta( $postID, $count_key, true );
        if( $count=='' ){
            $count = 1;
            delete_post_meta( $postID, $count_key );
            add_post_meta( $postID, $count_key, '1' );
        }else{
            $count++;
            update_post_meta( $postID, $count_key, $count );
        }
    }
}

if ( ! function_exists( 'munza_get_post_views' ) ) {
    function munza_get_post_views( $postID ){
        $count_key  = 'munza_post_views_count';
        $count      = get_post_meta( $postID, $count_key, true );
        
        if( $count == '' ){
            delete_post_meta( $postID, $count_key );
            add_post_meta( $postID, $count_key, '1' );
            return "0 ".esc_html__('Views','munza');
        }
        
        return $count.' '.esc_html__('Views','munza');
    }
}

// post views for popular posts..
if ( ! function_exists( 'munza_wpb_track_post_views' ) ){
    function munza_wpb_track_post_views ($post_id) {
        if ( !is_single() ) return;
        if ( empty ( $post_id) ) {
            global $post;
            $post_id = $post->ID;    
        }
        munza_set_post_views($post_id);
    }
}

if ( ! function_exists( 'itr_get_current_user' ) ) {
    function itr_get_current_user (){
        $auth_id = get_the_author_meta('ID');
        $output = '<a href="'.get_author_posts_url( $auth_id ).'" rel="author">';
            $output .= get_the_author();
        $output .= '</a>';
        return $output;
    }
}

if ( ! function_exists( 'munza_mini_pager' ) ) {
    function munza_mini_pager (){
        
        $itr_min_pag = wp_link_pages( array(
            'before'      => '<div class="sub-pager"><span class="page-links-title">' . esc_html__( 'Pages:', 'munza' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
        ) );
        
        return $itr_min_pag;
        
    }
}

if ( ! function_exists( 'itr_blog_share' ) ) {
    function itr_blog_share($pg_type){
        $tw             = (itr_theme_option('tw_on') == '1')            ? 'twitter,'       : '';
        $fb             = (itr_theme_option('fb_on') == '1')            ? 'facebook,'      : '';
        $gplus          = (itr_theme_option('gplus_on') == '1')         ? 'googleplus,'    : '';
        $ln             = (itr_theme_option('ln_on') == '1')            ? 'linkedin,'      : '';
        $pin            = (itr_theme_option('pin_on') == '1')           ? 'pinterest,'     : '';
        $whatsapp       = (itr_theme_option('whatsapp_on') == '1')      ? 'whatsapp,'      : '';
        $email          = (itr_theme_option('email_on') == '1')         ? 'email,'         : '';
        $stumbleupon    = (itr_theme_option('stumbleupon_on') == '1')   ? 'stumbleupon,'   : '';
        $telegram       = (itr_theme_option('telegram_on') == '1')      ? 'telegram,'      : '';
        $viber          = (itr_theme_option('viber_on') == '1')         ? 'viber,'         : '';
        $pocket         = (itr_theme_option('pocket_on') == '1')        ? 'pocket,'        : '';
        $vkontakte      = (itr_theme_option('vkontakte_on') == '1')     ? 'vkontakte,'     : '';
        $messenger      = (itr_theme_option('messenger_on') == '1')     ? 'messenger'     : '';
        
        $atts = $tw . $fb . $gplus . $ln . $pin . $whatsapp . $email . $stumbleupon . $telegram . $viber . $pocket . $vkontakte . $messenger;
        $atts = array( rtrim( $atts,',' ) );
        $output = '';
        if ( itr_theme_option('social_on') == "1" && $pg_type == 'list' && $atts ){
            
            $output .= '<div class="itr_post_share"><span class="main-color">'.esc_html__( 'Share: ' , 'munza' ).'</span><div class="itr_share_post_item" data-share-on="'.$atts[0].'"></div></div>';
        
        } else if ( itr_theme_option('singlesocial_on') == "1" && $pg_type == 'single' && $atts ){
            
            $output .= '<div class="itr-post-block itr_post_share"><span class="main-color">'.esc_html__( 'Share: ' , 'munza' ).'</span><div class="itr_single_share" data-share-on="'.$atts[0].'"></div></div>'; 
               
        }
        
        wp_enqueue_script( 'JSSocials', Munza_THM_URI . 'assets/front/js/vendor/jssocials.min.js', array('jquery'), null, true);
        
        return $output;
    }
}

if ( ! function_exists( 'munza_paging_nav' ) ) {
    function munza_paging_nav( $ino_query,$pager_type,$pg_pos,$load_txt ) {

        if ( $ino_query->max_num_pages < 2 ) return;
        $big = 999999999;
        $args = array(
            'base'      => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
            'format'    => '?paged=%#%',
            'current'   => max( 1, get_query_var('paged') ),
            'total'     => $ino_query->max_num_pages,
            'type'      => 'list',
            'prev_text' => '<i class="fa fa-angle-left"></i>',
            'next_text' => '<i class="fa fa-angle-right"></i>'                    
        );
                
        $output     = '';
        $lodtxt     = ($load_txt != '' ) ? esc_attr($load_txt) : __('Load More','munza');
        
        if ( $pager_type == "1" ) {
            
            $output .= '<div class="pager '. esc_attr($pg_pos).'">';
                $output .= paginate_links( $args );
            $output .= '</div>';
            
        } else if ( $pager_type == "2" ) {
                        
            $output .= '<ul class="pager oldnew">';
                $output .= '<li class="previous">' . get_next_posts_link( '<span><i class="fa fa-angle-left main-color"></i></span>' . esc_html__('OLDER ENTIRES', 'munza') , $ino_query->max_num_pages ) . '</li>';
                $output .= '<li class="next">' . get_previous_posts_link( esc_html__('NEWER ENTIRES', 'munza') . '<span><i class="fa fa-angle-right main-color"></i></span>' , $ino_query->max_num_pages ) . '</li>';
            $output .= '</ul>';
            
        } else if ( $pager_type == "3" ){
            
            $perm = ( get_option('permalink_structure') ) ? '/page/' : '&paged=';
            $output .= '<div class="loadmore">';
                $output .= '<span class="hidden blgurl" data-pag="'.$perm.'"></span>';
                $output .= '<a href="#" class="btn bold">'.esc_attr($lodtxt).' <span class="itr_preloader"><i class="main-color stline-loading-2"></i></span></a>';
                $output .= '<div class="hidden pgnum">'.esc_attr($ino_query->max_num_pages).'</div>';
                $output .= '<div class="load_msg">'.__('No More Posts To Show !!', 'munza').'</div>';
            $output .= '</div>';
            
        }
        
        return $output;
    }
}

if ( ! function_exists( 'munza_post_format_link' ) ) {
    function munza_post_format_link( $content = null, $title = null, $post = null ) {

        if ( ! $content ) {
            $post     = get_post( $post );
            $title    = $post->post_title;
            $content  = $post->post_content;
        }

        $link   = munza_getUrl( $content );

        if( ! empty( $link ) ) {

            $title    = '<a href="'. esc_url( $link ) .'" rel="bookmark">'. $title .'</a>';
            $content  = str_replace( $link, '', $content );

        } else {

            $pattern    = '/^\<a[^>](.*?)>(.*?)<\/a>/i';
            preg_match( $pattern, $content, $link );

            if( ! empty( $link[0] ) && ! empty( $link[2] ) ) {

                $title    = $link[0];
                $content  = str_replace( $link[0], '', $content );

            } elseif( ! empty( $link[0] ) && ! empty( $link[1] ) ) {

                $atts     = shortcode_parse_atts( $link[1] );
                $target = ( ! empty( $atts['target'] ) ) ? $atts['target'] : '_self';
                $title  = ( ! empty( $atts['title'] ) )  ? $atts['title']  : $title;
                $title    = '<a href="'. esc_url( $atts['href'] ) .'" rel="bookmark" target="'. esc_attr($target) .'">'. $title .'</a>';
                $content  = str_replace( $link[0], '', $content );

            } else {
                $title  = '<a href="'. esc_url( get_permalink() ) .'" rel="bookmark">'. $title .'</a>';
            }

        }

        $output['title']   = '<h3>'. $title . '</h3>';
        $output['content'] = $content;

        return $output;

    }
}

if ( ! function_exists( 'munza_getUrl' ) ) {
  function munza_getUrl( $html ) {
    $regex  = "/^\b(?:(?:https?|ftp):\/\/)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i";
    preg_match( $regex, $html, $matches );
    return ( !empty( $matches[0] ) ) ? $matches[0] : false;
  }
}

if ( ! function_exists( 'munza_get_shortcode_regex' ) ) {
  function munza_get_shortcode_regex() {
      global $shortcode_tags;
      $tagnames = array_keys($shortcode_tags);
      $tagregexp = join( '|', array_map('preg_quote', $tagnames) );

      // WARNING! Do not change this regex without changing do_shortcode_tag() and strip_shortcode_tag()
      // Also, see shortcode_unautop() and shortcode.js.
      return
          '\\['                              // Opening bracket
        . '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
        . "($tagregexp)"                     // 2: Shortcode name
        . '(?![\\w-])'                       // Not followed by word character or hyphen
        . '('                                // 3: Unroll the loop: Inside the opening shortcode tag
        .     '[^\\]\\/]*'                   // Not a closing bracket or forward slash
        .     '(?:'
        .         '\\/(?!\\])'               // A forward slash not followed by a closing bracket
        .         '[^\\]\\/]*'               // Not a closing bracket or forward slash
        .     ')*?'
        . ')'
        . '(?:'
        .     '(\\/)'                        // 4: Self closing tag ...
        .     '\\]'                          // ... and closing bracket
        . '|'
        .     '\\]'                          // Closing bracket
        .     '(?:'
        .         '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
        .             '[^\\[]*+'             // Not an opening bracket
        .             '(?:'
        .                 '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
        .                 '[^\\[]*+'         // Not an opening bracket
        .             ')*+'
        .         ')'
        .         '\\[\\/\\2\\]'             // Closing shortcode tag
        .     ')?'
        . ')'
        . '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
    }
}

if ( ! function_exists( 'munza_wp_tagregexp' ) ) {
  function munza_wp_tagregexp() {
    apply_filters( 'wp_custom_tagregexp', 'video|media|audio|playlist|video-playlist|embed' );
  }
}

if ( ! function_exists ( 'get_comments_popup_link' ) ) {
    function get_comments_popup_link( $zero = false, $one = false, $more = false, $css_class = '', $none = false ) {
    global $wpcommentspopupfile, $wpcommentsjavascript;
 
    $id = get_the_ID();
 
    if ( false === $zero ) $zero = esc_html__( 'No Comments','munza' );
    if ( false === $one ) $one = esc_html__( '1 Comment','munza' );
    if ( false === $more ) $more = esc_html__( '% Comments','munza' );
    if ( false === $none ) $none = esc_html__( 'Comments Off','munza' );
 
    $number = get_comments_number( $id );
 
    $str = '';
 
    if ( 0 == $number && !comments_open() && !pings_open() ) {
        $str = '<span' . ((!empty($css_class)) ? ' class="' . esc_attr( $css_class ) . '"' : '') . '>' . $none . '</span>';
        return $str;
    }
 
    if ( post_password_required() ) {
        $str = esc_html__('Enter your password to view comments.','munza');
        return $str;
    }
 
    $str = '<a href="';
    if ( $wpcommentsjavascript ) {
        if ( empty( $wpcommentspopupfile ) )
            $home = home_url();
        else
            $home = get_option('siteurl');
        $str .= $home . '/' . $wpcommentspopupfile . '?comments_popup=' . $id;
        $str .= '" onclick="wpopen(this.href); return false"';
    } else { // if comments_popup_script() is not in the template, display simple comment link
        if ( 0 == $number )
            $str .= get_permalink() . '#respond';
        else
            $str .= get_comments_link();
        $str .= '"';
    }
 
    if ( !empty( $css_class ) ) {
        $str .= ' class="'.$css_class.'" ';
    }
    $com_title = the_title_attribute( array('echo' => 0 ) );
 
    $str .= apply_filters( 'comments_popup_link_attributes', '' );
 
    $str .= ' title="' . esc_attr( sprintf( esc_html__('Comment on %s','munza'), $com_title ) ) . '">';
    $str .= get_comments_number_str( $zero, $one, $more );
    $str .= '</a>';
     
    return $str;
}
}

if ( ! function_exists ( 'get_comments_number_str' ) ){
    function get_comments_number_str( $zero = false, $one = false, $more = false, $deprecated = '' ) {
    if ( !empty( $deprecated ) )
        _deprecated_argument( __FUNCTION__, '1.3' );
 
    $number = get_comments_number();
 
    if ( $number > 1 )
        $output = str_replace('%', number_format_i18n($number), ( false === $more ) ? esc_html__('% Comments','munza') : $more);
    elseif ( $number == 0 )
        $output = ( false === $zero ) ? esc_html__('No Comments','munza') : $zero;
    else // must be one
        $output = ( false === $one ) ? esc_html__('1 Comment','munza') : $one;
 
    return apply_filters('comments_number', $output, $number);
}
}
