<?php

if ( ! function_exists( 'it_multiselect' ) ) {
    function it_multiselect( $settings, $value ) {
        
        $html = '';
        $css_option = str_replace( '#', 'hash-', vc_get_dropdown_option( $settings, $value ) );
        
        if ( is_array( $value ) ) {
            $value = isset( $value['value'] ) ? $value['value'] : array_shift( $value );
        }
        if ( ! empty( $settings['value'] ) ) {
            $html .= '<div class="multichck_wrap">';
            foreach ( $settings['value'] as $index => $data ) {
                $html .= '<span class="multichck_el">';
                    if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
                        $option_label = $data;
                        $option_value = $data;
                    } elseif ( is_numeric( $index ) && is_array( $data ) ) {
                        $option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
                        $option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
                    } else {
                        $option_value = $data;
                        $option_label = $index;
                    }
                    $html .= '<input type="checkbox" id="id_' . esc_attr( $option_value ) . '" class="multicheck" value="' . esc_attr( $option_value ) . '"><label for="id_' . esc_attr( $option_value ) . '">'. htmlspecialchars( $option_label ) . '</label>';
                $html .= '</span>';
            }
            $html .= '</div>';
        } 
        $html .= '<input type="text" name="'. $settings['param_name']. '" class="wpb_vc_param_value wpb-input wpb-select hidden multi_sel '. $settings['param_name']. ' ' . $settings['type'] . '" value="' . $value . '" />'; 
        return $html;
    }
}
vc_add_shortcode_param('it_multiselect', 'it_multiselect');
