<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_footer_socials_widget_reg');
function itr_footer_socials_widget_reg(){
    register_widget('itr_footer_socials_widget');
}
class itr_footer_socials_widget extends WP_Widget {

    function __construct() {
        parent::__construct('it_widget_footer_socials', esc_html__('- Social icons', 'munza'), array( 'description' => esc_html__( 'Social icons widget.', 'munza' )));
    }
    public function widget( $args, $instance ) {
        extract($args);
        $title = ( isset($instance["title"]) ) ? apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) : '';
        $footer_text = ( isset($instance["footer_text"]) ) ? $instance['footer_text'] : '';;
        echo $args['before_widget'];
        
        if ( ! empty( $title ) ){
            if ( !empty ( $instance['title']) ) {
                echo '<h2 class="widgettitle">'.esc_html($title).'</h2>';
            }            
        }
        
        if ( !empty ( $instance['footer_text']) ) { echo '<p class="foot-about-par">'.esc_html($footer_text).'</p>';}
        echo itr_display_social_icons();
        
        echo $args['after_widget'];
    }
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
            $footer_text = esc_textarea($instance['footer_text']);
        }else {
            $title = esc_html__( 'Social Icons', 'munza' );
            $footer_text = '';
        }
    ?>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'footer_text' )); ?>"><?php echo esc_html__( 'Footer text:', 'munza' ); ?></label> 
        <textarea class="widefat" rows="16" cols="20" id="<?php echo esc_attr($this->get_field_id( 'footer_text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'footer_text' )); ?>"><?php echo esc_attr( $footer_text ); ?></textarea>
    </p>
    <?php 
    }
    
    public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
    $instance['footer_text'] = ( ! empty( $new_instance['footer_text'] ) ) ? strip_tags( $new_instance['footer_text'] ) : '';
    return $instance;
    }

}
