<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_instagram_widget_reg');

function itr_instagram_widget_reg() {
    register_widget('itr_instagram_widget');
}

class itr_instagram_widget extends WP_Widget {
    
    function __construct() {
        parent::__construct('it_widget_instagram',esc_html__('- Instagram Feed', 'munza'), array( 'description' => esc_html__( 'instagram feed widget.', 'munza' )));
    }
    
    public function widget( $args, $instance ) {
        $title          = ( isset($instance["title"]) ) ? apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) : '';
        $instagram_id   = ( isset($instance['instagram_id']) ) ? $instance['instagram_id'] : '';
        $access_token   = ( isset($instance['access_token']) ) ? $instance['access_token'] : '';
        $limit          = ( isset($instance['limit']) ) ? (int) $instance['limit'] : '3';
        $colmns         = ( isset($instance['colmns']) ) ? (int) $instance['colmns'] : '';
        $widget_id      = ( isset($args['widget_id']) ) ? $args['widget_id'] : '';
        $widget_txt     = ( isset($instance['widget_txt']) ) ? $instance['widget_txt'] : '';
         
        echo $args['before_widget'];
        
        if ( ! empty( $title ) ){echo $args['before_title'] . $title . $args['after_title'];}
        
        if( ! empty($widget_txt)){
            echo '<p class="foot-about-par">'.esc_html( $widget_txt ).'</p>';
        }
        echo '<div class="instagram_wrap cols-3" id="'.esc_js($widget_id).'" data-get="user" data-client="'.esc_js($instagram_id).'" data-access="'.$access_token.'" data-sort="most-recent" 
        data-limit="'.esc_js($limit).'" data-columns="'.esc_js($colmns).'"  data-gap="2px" data-resol="thumbnail">';
        echo '</div>';
        wp_enqueue_script ( 'insta-feed', Munza_THM_URI . 'assets/front/js/vendor/insta.feed.js', null, null, true );            
        echo $args['after_widget'];
    }
            
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title          = $instance[ 'title' ];
            $instagram_id   = $instance['instagram_id'];
            $access_token   = $instance['access_token'];
            $limit          = (int) $instance['limit'];
            $colmns         = (int) $instance['colmns'];
            $widget_txt     = $instance['widget_txt'];
        }
        else {
            $title = esc_html__( 'Instagram Feed', 'munza' );
            $instagram_id   = '';
            $access_token   = '';
            $limit          = '';
            $colmns         = '';
            $widget_txt     = '';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'widget_txt' )); ?>"><?php echo esc_html__( 'Content:', 'munza' ); ?></label> 
            <textarea cols="12" rows="12" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_txt' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_txt' )); ?>"><?php echo esc_attr( $widget_txt ); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'instagram_id' )); ?>"><?php echo esc_html__( 'Client ID:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'instagram_id' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'instagram_id' )); ?>" type="text" value="<?php echo esc_attr( $instagram_id ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'access_token' )); ?>"><?php echo esc_html__( 'Access Token:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'access_token' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'access_token' )); ?>" type="text" value="<?php echo esc_attr( $access_token ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'limit' )); ?>"><?php echo esc_html__( 'Limit:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'limit' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'limit' )); ?>" type="number" value="<?php echo esc_attr( $limit ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'colmns' )); ?>"><?php echo esc_html__( 'Columns:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'colmns' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'colmns' )); ?>" type="number" value="<?php echo esc_attr( $colmns ); ?>" />
        </p>
        
        <?php 
    }
        
    public function update( $new_instance, $old_instance ) {
        $instance                   = array();
        $instance['title']          = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['instagram_id']   = ( ! empty( $new_instance['instagram_id'] ) ) ? strip_tags( $new_instance['instagram_id'] ) : '';
        $instance['access_token']   = ( ! empty( $new_instance['access_token'] ) ) ? strip_tags( $new_instance['access_token'] ) : '';
        $instance['limit']          = ( ! empty( $new_instance['limit'] ) ) ? strip_tags( $new_instance['limit'] ) : '';
        $instance['colmns']         = ( ! empty( $new_instance['colmns'] ) ) ? strip_tags( $new_instance['colmns'] ) : '';
        $instance['widget_txt']     = ( ! empty( $new_instance['widget_txt'] ) ) ? strip_tags( $new_instance['widget_txt'] ) : '';
        return $new_instance;
    } 
             
}