<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_login_widget_reg');

function itr_login_widget_reg(){
    register_widget('itr_login_widget');
}
class itr_login_widget extends WP_Widget {
    
    protected $options;
    
    function __construct() {
        parent::__construct('it_widget_login',esc_html__('- Login Widget', 'munza'), array( 'description' => esc_html__( 'login widget.', 'munza' ))); 
        
    } 
    
    public function widget( $args, $instance ) {
        
        $title = apply_filters( 'widget_title', $instance['title'] );

        echo $args['before_widget'];
        if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        
        if (is_user_logged_in()) {
            $this->itr_logout_form();
        } else {
            itr_login_form();
        }

        echo $args['after_widget'];
    }
    
    public function itr_logout_form() {
        
        $logoutoutput = '<div class="itr_logout text-center">';
            $logoutoutput .= '<label>'.esc_html__('You are logged in as','munza').' </label>'.itr_get_current_user().'<br>';
            $logoutoutput .= '<a class="btn-logout" href="'.esc_url(wp_logout_url()).'"><i class="stline-face-id-4"></i>'.esc_html__('Logout','munza').'</a>';
        $logoutoutput .= '</div>';
        
        echo $logoutoutput;
    }
            
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }else {
            $title = '';
        }

    ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
        </p>
    <?php 
    } 
        
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }   
}