<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_image_text_widget_reg');
function itr_image_text_widget_reg(){
    register_widget('itr_image_text_widget');
    wp_enqueue_style('thickbox');
}
class itr_image_text_widget extends WP_Widget {

    function __construct() {
        parent::__construct('it_widget_image_text', esc_html__('- Image & Text Widget', 'munza'), array( 'description' => esc_html__( 'Image & Text Widget.', 'munza' )));
    }
    
    public function widget( $args, $instance ) {
        extract($args);
        $title = apply_filters( 'widget_title', $instance['title'] );
        $image = $instance['image'];
        
        if (function_exists ( 'icl_translate' )){
            $text = icl_translate('Widgets', 'Image & Text Widget', esc_html($instance['text']));
        } else {
            $text = $instance['text'];
        }
        
        echo $args['before_widget'];
        
        if ( ! empty( $title ) ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        $ban_id = preg_replace( '/[^\d]/', '', $image );
        $ban_src = wp_get_attachment_image_src( $ban_id,'full' );
        echo '<div class="foot-image"><img alt="'.$title.'" src="'.esc_url($ban_src[0]).'" /></div>';
        echo '<p class="widget-txt">'.wp_kses_post($text).'</p>';
        
        echo $args['after_widget'];
        
    }
    
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title  = $instance[ 'title' ];
            $image  = $instance['image'];
            $text   = $instance['text'];
        }else {
            $title  = esc_html__( 'Image & Text', 'munza' );
            $image  = '';
            $text   = '';
        }
    ?>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
    </p>
    <p>
        <input class="regular-text txt-image hidden" id="<?php echo esc_attr($this->get_field_id( 'image' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image' )); ?>" type="text" value="<?php echo esc_attr( $image ); ?>" />
        <a class="upload_image_button" href="#"></a>
        <span class="clear-img">
            <img class="logo-im" alt="<?php echo esc_html__('Upload Image', 'munza'); ?>" src="<?php echo esc_url( wp_get_attachment_url( $image ) ); ?>" /><a class="remove-img" href="#" title="<?php echo esc_html__('Remove Image', 'munza') ?>"></a>
        </span>
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'footer_text_image' )); ?>"><?php echo esc_html__( 'Text:', 'munza' ); ?></label> 
        <textarea class="widefat" rows="16" cols="20" id="<?php echo esc_attr($this->get_field_id( 'text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'text' )); ?>"><?php echo esc_textarea( $text ); ?></textarea>
    </p>
    <?php 
    }
    
    public function update( $new_instance, $old_instance ) {
        $instance           = array();
        $instance['title']  = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['image']  = ( ! empty( $new_instance['image'] ) ) ? strip_tags( $new_instance['image'] ) : '';
        $instance['text']   = ( ! empty( $new_instance['text'] ) ) ? wp_kses_post( $new_instance['text'] ) : '';
        return $instance;
    }

}