<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_newsletters_widget_reg');

function itr_newsletters_widget_reg(){
    register_widget('itr_newsletters_widget');
}
class itr_newsletters_widget extends WP_Widget {

    function __construct() {
        parent::__construct('it_widget_newsletters',esc_html__('- Newsletters', 'munza'), array( 'description' => esc_html__( 'Newsletters widget.', 'munza' )));
    }
    
    public function widget( $args, $instance ) {
        
        $title              = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        $newsletters_text   = $instance['newsletters_text'];
        $form_id            = $instance['form_id'];
        $langcode           = ( class_exists( 'SitePress' ) ) ? '-'.ICL_LANGUAGE_CODE : '';
        
        echo $args['before_widget'];
        if ( ! empty( $title ) ) echo $args['before_title'] . $title . $args['after_title'];
        if (function_exists ( 'icl_translate' )){
            $newsletters_text = icl_translate('Widgets', 'Newsletters Text', esc_html($instance['newsletters_text']));
        }
        
        if ( $newsletters_text ){
            echo '<p class="foot-about-par">'.esc_html($newsletters_text).'</p>';
        }
        
        echo "<div class='nl_form_div'>";
            
            echo do_shortcode('[mc4wp_form id="'.$form_id.'"]');
            
        echo "</div>";
        echo $args['after_widget'];
    }
            
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        } else {
            $title = esc_html__( 'Newsletters', 'munza' );
        }
        
        if ( isset( $instance[ 'newsletters_text' ] ) ) {
            $newsletters_text = esc_textarea($instance['newsletters_text']);    
        } else {
            $newsletters_text = '';
        }
        
        if ( isset( $instance[ 'form_id' ] ) ) {
            $form_id = $instance['form_id'];    
        } else {
            $form_id = '';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'newsletters_text' )); ?>"><?php echo esc_html__( 'Newsletters text:', 'munza' ); ?></label> 
            <textarea class="widefat" rows="16" cols="20" id="<?php echo esc_attr($this->get_field_id( 'newsletters_text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'newsletters_text' )); ?>"><?php echo esc_attr( $newsletters_text ); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'form_id' )); ?>"><?php echo esc_html__( 'Form Id:', 'munza' ); ?></label> 
            <input type="number" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'form_id' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'form_id' )); ?>" value="<?php echo esc_attr( $form_id ); ?>" />
        </p>
    <?php 
    }
        
    public function update( $new_instance, $old_instance ) {
        $instance                       = array();
        $instance['title']              = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['newsletters_text']   = ( ! empty( $new_instance['newsletters_text'] ) ) ? strip_tags( $new_instance['newsletters_text'] ) : '';
        $instance['form_id']            = ( ! empty( $new_instance['form_id'] ) ) ? strip_tags( $new_instance['form_id'] ) : '';
        return $instance;
    }
}