<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_shortcode_widget_reg');

function itr_shortcode_widget_reg(){
    register_widget('itr_shortcode_widget');
}
class itr_shortcode_widget extends WP_Widget {

    function __construct() {
        parent::__construct('it_widget_shortcode',esc_html__('- Shortcode Widget', 'munza'), array( 'description' => esc_html__( 'Shortcode widget.', 'munza' ))); 
    } 
    
    public function widget( $args, $instance ) {
        $title      = apply_filters( 'widget_title', $instance['title'] );
        $langcode   = '';
        $shortc     = $instance['shortc'];

        echo $args['before_widget'];
        if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        echo do_shortcode($shortc);
        echo $args['after_widget'];
    } 
            
    public function form( $instance ) {
        $title = $instance[ 'title' ];
        $shortc = wp_kses_post($instance['shortc']);

    ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'shortc' )); ?>"><?php echo esc_html__( 'Shortcode:', 'munza' ); ?></label> 
            <textarea class="widefat" rows="16" cols="20" id="<?php echo esc_attr($this->get_field_id( 'shortc' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'shortc' )); ?>"><?php echo esc_attr( $shortc ); ?></textarea>
            <span><?php echo 'Ex: [shoertcode]'; ?></span>
        </p>
    <?php 
    } 
        
    public function update( $new_instance, $old_instance ) {
        $instance           = array();
        $instance['title']  = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['shortc'] = ( ! empty( $new_instance['shortc'] ) ) ? strip_tags( $new_instance['shortc'] ) : '';
        return $instance;
    }   
}