<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_banners_ads_widget_reg');

function itr_banners_ads_widget_reg(){
    register_widget('itr_banners_ads_widget');
    wp_enqueue_style('thickbox');
}
class itr_banners_ads_widget extends WP_Widget {
    
    function __construct() {
        parent::__construct('it_widget_side_banners',esc_html__('- Side Banners', 'munza'), array( 'description' => esc_html__( 'Add Banners on the sidebars.', 'munza' )));
    }
    
    public function widget( $args, $instance ) {
        
        $title      = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        $image      = $instance['image'];
        $im_link    = $instance['im_link'];
         
        echo $args['before_widget'];
        if ( ! empty( $title ) ){echo $args['before_title'] . $title . $args['after_title'];}
        $ban_id = preg_replace( '/[^\d]/', '', $image );
        $ban_src = wp_get_attachment_image_src( $ban_id,'full' );
        echo '<div class="banner_img">';
            echo '<a href="'.esc_url($im_link).'"><img alt="'.$title.'" src="'.esc_url($ban_src[0]).'" /></a>';
        echo '</div>';
        echo $args['after_widget'];
    }
            
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title      = $instance[ 'title' ];
            $image      = $instance['image'];
            $im_link    = $instance['im_link'];
        }else{
            $title      = '';
            $image      = '';
            $im_link    = '';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'im_link' )); ?>"><?php echo esc_html__( 'Banner Link:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'im_link' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'im_link' )); ?>" type="text" value="<?php echo esc_url( $im_link ); ?>" />
        </p>
        <p>
            <input class="regular-text txt-banner hidden" id="<?php echo esc_attr($this->get_field_id( 'image' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image' )); ?>" type="text" value="<?php echo esc_attr( $image ); ?>" />
            <a class="upload_image_button" href="#"></a>
            <span class="clear-img">
                <img class="logo-im" alt="<?php echo esc_html__('Upload Image', 'munza'); ?>" src="<?php echo esc_url( wp_get_attachment_url( $image ) ); ?>" /><a class="remove-img" href="#" title="<?php echo esc_html__('Remove Image', 'munza') ?>"></a>
            </span>
        </p>
        <?php 
    }
        
    public function update( $new_instance, $old_instance ) {
        $instance               = array();
        $instance['title']      = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['image']      = ( ! empty( $new_instance['image'] ) ) ? strip_tags( $new_instance['image'] ) : '';
        $instance['im_link']    = ( ! empty( $new_instance['im_link'] ) ) ? strip_tags( $new_instance['im_link'] ) : '';
        return $new_instance;
    } 
}
