<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_action('widgets_init', 'itr_tweets_widget_reg');

function itr_tweets_widget_reg() {
    register_widget('itr_tweets_widget');
}
class itr_tweets_widget extends WP_Widget {
    
    function __construct() {
        parent::__construct('it_widget_tweets',esc_html__('- Latest Tweets', 'munza'), array( 'description' => esc_html__( 'Latest tweets widget.', 'munza' )));
    }
    
    public function widget( $args, $instance ) {
        
        $title      = apply_filters( 'widget_title', $instance['title'] );
        $tw_user    = $instance['tw_user'];
        $tw_num     = (int) $instance['tw_num'];
        $tw_max_num = (int) $instance['tw_max_num'];
        $widget_id  = $args['widget_id'];
        
        echo $args['before_widget'];
        
        if ( ! empty( $title ) ){echo $args['before_title'] . $title . $args['after_title'];}
        echo '<div id="'.esc_attr($widget_id).'" class="tweet" data-tweets-num="'.esc_js($tw_num).'"></div>';
        ?>                                                        
        <a class="twitter-timeline" href="//twitter.com/<?php echo esc_attr($tw_user); ?>" data-tweet-limit="<?php echo esc_js($tw_max_num); ?>"></a>
        <?php
        wp_enqueue_script( 'munza-twitter-widget', '//platform.twitter.com/widgets.js' );            
        echo $args['after_widget'];
    }
            
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title      = $instance[ 'title' ];
            $tw_user    = $instance[ 'tw_user' ];
            $tw_num     = (int) $instance['tw_num'];
            $tw_max_num = (int) $instance['tw_max_num']; 
        }
        else {
            $title      = '';
            $tw_num     = '';
            $tw_max_num = '';
            $tw_user    = '';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'tw_user' )); ?>"><?php echo esc_html__( 'Twitter User:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tw_user' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tw_user' )); ?>" type="text" value="<?php echo esc_html( $tw_user ); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'tw_max_num' )); ?>"><?php echo esc_html__( 'Max. Number of Tweets:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tw_max_num' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tw_max_num' )); ?>" type="number" value="<?php echo esc_html( $tw_max_num ); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'tw_num' )); ?>"><?php echo esc_html__( 'Visible Tweets:', 'munza' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tw_num' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tw_num' )); ?>" type="number" value="<?php echo esc_html( $tw_num ); ?>" />
        </p>

        <?php 
    }
        
    public function update( $new_instance, $old_instance ) {
        $instance               = array();
        $instance['title']      = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['tw_num']     = ( ! empty( $new_instance['tw_num'] ) ) ? strip_tags( $new_instance['tw_num'] ) : '2';
        $instance['tw_max_num'] = ( ! empty( $new_instance['tw_max_num'] ) ) ? strip_tags( $new_instance['tw_max_num'] ) : '2';
        $instance['tw_user']    = ( ! empty( $new_instance['tw_user'] ) ) ? strip_tags( $new_instance['tw_user'] ) : '';
        return $new_instance;
    }  
             
}
