<?php
/*
Plugin Name: Munza Core
Plugin URI: https://www.it-rays.org/
Description: Munza Core plugin for Munza theme.
Author: IT-RAYS
Version: 1.2.0
Author URI: https://www.it-rays.org/
*/

if (!defined('ABSPATH')) die('-1');

defined('Munza_THM_DIR') or define('Munza_THM_DIR', plugin_dir_path(__FILE__));
defined('Munza_THM_URI') or define('Munza_THM_URI', plugin_dir_url(__FILE__));

class munza_Core {
  
    public function __construct() {
            
        add_action( 'vc_before_init', array( &$this, 'munza_before_func' ) );
        add_action( 'vc_after_init', array( &$this, 'munza_core_func' ) );
        
        add_action( 'admin_enqueue_scripts', array(&$this, 'munza_admin_styles') ); 
               
        add_action( 'wp_enqueue_scripts', array(&$this, 'munza_front_scripts') );
        
        add_action( 'vc_backend_editor_enqueue_js_css', array(&$this, 'munza_admin_js') ); 
        
        include_once( Munza_THM_DIR . '/includes/helpers.php' );
        include_once( Munza_THM_DIR . '/includes/it-post-like.php' );
        include_once (Munza_THM_DIR . '/includes/widgets/it-widgets.php');
        
        load_plugin_textdomain( 'munza', false, Munza_THM_DIR . '/languages/' );
            
    }

    public function munza_admin_styles(){
        wp_enqueue_style('munza-corecss', Munza_THM_URI . 'assets/admin/css/style.css');
    }
    
    public function munza_before_func(){
        $direc = Munza_THM_DIR.'/shortcodes/vc_templates';
        vc_set_shortcodes_templates_dir( $direc ); 
    }
    
    public function munza_admin_js(){
        wp_enqueue_script('itr-color-picker',       Munza_THM_URI . 'assets/admin/js/colorpicker.js',               array('jquery'), null, true);
        wp_enqueue_script('itr-gradient',           Munza_THM_URI . 'assets/admin/js/jquery.gradientPicker.js',     array('jquery'), null, true);
        wp_enqueue_script('munza-hotspot',          Munza_THM_URI . 'assets/admin/js/jquery.hotspot.js',            array('jquery'), null, true);
        wp_enqueue_script('munza-corejs',           Munza_THM_URI . 'assets/admin/js/script.js',                    array('jquery'), null, true);
        wp_enqueue_script('jquery-ui-datepicker');
    }
    
    public function munza_front_scripts(){
        wp_deregister_style( 'animate-css' );
        wp_deregister_style( 'js_composer_front' );
                
        wp_enqueue_style ( 'munza-corecss-assets',  Munza_THM_URI . 'assets/front/css/assets.css' );
        wp_enqueue_style ( 'itr-animate-css',       Munza_THM_URI . 'assets/front/css/vendor/animate.css' );
        wp_enqueue_style ( 'slick-slider',          Munza_THM_URI . 'assets/front/css/vendor/slick.slider.css' );
        
        wp_register_style ( 'animated.text',        Munza_THM_URI . 'assets/front/css/vendor/animated.text.css' );
        wp_register_style ( 'itr_modal',            Munza_THM_URI . 'assets/front/css/vendor/md-modal.css' );
        wp_register_style ( 'compare-slider',       Munza_THM_URI . 'assets/front/css/vendor/image.compare.css' );
        wp_register_style ( 'itr-hotspot',          Munza_THM_URI . 'assets/front/css/vendor/hotspot.css' );
        
        wp_enqueue_style ( 'munza-corecss',         Munza_THM_URI . 'assets/front/css/style.css' );
                
        // include JS plugins files...   
        wp_register_script ( 'animated.text',       Munza_THM_URI . 'assets/front/js/vendor/jquery.animated.text.js',   array( 'jquery' ), null, true );  
        wp_register_script ( 'itr-classie',         Munza_THM_URI . 'assets/front/js/vendor/classie.js',                array( 'jquery' ), null, true );
        wp_register_script ( 'itr-modalEffects',    Munza_THM_URI . 'assets/front/js/vendor/modalEffects.js',           array( 'jquery' ), null, true ); 
        wp_register_script ( 'compare.slider',      Munza_THM_URI . 'assets/front/js/vendor/jquery.compare.slider.js',  array( 'jquery' ), null, true );   
        wp_register_script ( 'itr-hotspot',         Munza_THM_URI . 'assets/front/js/vendor/jquery.hotspot.js',         array( 'jquery' ), null, true );        
                                                                                                    
        wp_enqueue_script ( 'jquery.appear',        Munza_THM_URI . 'assets/front/js/vendor/jquery.appear.min.js',      array( 'jquery' ), null, true);
        wp_enqueue_script ( 'slick-slider',         Munza_THM_URI . 'assets/front/js/vendor/slick.slider.js',           array( 'jquery' ), null, true);
        wp_enqueue_script ( 'munza-corejs',         Munza_THM_URI . 'assets/front/js/script.js',                        array( 'jquery' ), null, true );
                
    }
        
  	public function munza_core_func(){
                
        $config_path = Munza_THM_DIR . 'config'; 
        
        vc_lean_map( 'it_btn',                  null, $config_path . '/shortcode-button.php' );
        vc_lean_map( 'it_heading',              null, $config_path . '/shortcode-heading.php' );
        vc_lean_map( 'it_anim_text',            null, $config_path . '/shortcode-anim-text.php' );
        vc_lean_map( 'it_letters',              null, $config_path . '/shortcode-anim-letters.php' );
        vc_lean_map( 'it_parallax_el',          null, $config_path . '/shortcode-parallax-element.php' );
        vc_lean_map( 'it_cta',                  null, $config_path . '/shortcode-cta.php' );
        vc_lean_map( 'it_icon',                 null, $config_path . '/shortcode-icon.php' );
        vc_lean_map( 'it_iconbox',              null, $config_path . '/shortcode-icon-boxes.php' );
        vc_lean_map( 'it_list',                 null, $config_path . '/shortcode-list.php' );
        vc_lean_map( 'it_list_item',            null, $config_path . '/shortcode-list-item.php' );
        vc_lean_map( 'it_feature',              null, $config_path . '/shortcode-features.php' );
        vc_lean_map( 'it_img_compare',          null, $config_path . '/shortcode-img-compare.php' );
        vc_lean_map( 'it_images_layers',        null, $config_path . '/shortcode-image-layers.php' );
        vc_lean_map( 'it_hotspot',              null, $config_path . '/shortcode-hotspot.php' );
        vc_lean_map( 'it_price_table',          null, $config_path . '/shortcode-pricing-table.php' );
        vc_lean_map( 'it_pie',                  null, $config_path . '/shortcode-pie.php' );
        vc_lean_map( 'it_counter',              null, $config_path . '/shortcode-counter.php' );
        vc_lean_map( 'it_testimonials',         null, $config_path . '/shortcode-testimonials.php' );
        vc_lean_map( 'it_testimonial',          null, $config_path . '/shortcode-testimonial.php' );
        vc_lean_map( 'it_divider',              null, $config_path . '/shortcode-dividers.php' );
        vc_lean_map( 'it_member',               null, $config_path . '/shortcode-member.php' );
        vc_lean_map( 'it_carousel',             null, $config_path . '/shortcode-carousel.php' );
        vc_lean_map( 'it_twitter',              null, $config_path . '/shortcode-twitter.php' );
        vc_lean_map( 'it_facebook',             null, $config_path . '/shortcode-facebook.php' );
        vc_lean_map( 'it_instagram',            null, $config_path . '/shortcode-instagram.php' );
        vc_lean_map( 'it_gmap',                 null, $config_path . '/shortcode-gmap.php' );
        vc_lean_map( 'it_steps',                null, $config_path . '/shortcode-steps.php' );
        vc_lean_map( 'it_step',                 null, $config_path . '/shortcode-step.php' );
        vc_lean_map( 'it_modal',                null, $config_path . '/shortcode-modal.php' );
        vc_lean_map( 'it_breaking_news',        null, $config_path . '/shortcode-breaking-news.php' );
        vc_lean_map( 'it_blog',                 null, $config_path . '/shortcode-blog.php' );   
        vc_lean_map( 'it_recent_posts',         null, $config_path . '/shortcode-recent-posts.php' );
        vc_lean_map( 'it_popular_posts',        null, $config_path . '/shortcode-popular-posts.php' );
                
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
            return;
        }
        
        if ( !is_admin() ){
            foreach ( glob( plugin_dir_path( __FILE__ ) . "shortcodes/vc_*.php" ) as $file ) {
                include_once $file;
            }
        }
        
        foreach ( glob( plugin_dir_path( __FILE__ ) . "config/vc_elements/vc_*.php" ) as $conf_file ) {
            include_once $conf_file;
        }
        
        foreach ( glob( plugin_dir_path( __FILE__ ) . "includes/params/vc_*.php" ) as $param_file ) {
            include_once $param_file;
        }
                        
        include_once( Munza_THM_DIR . '/includes/extends.php' );
                              
        // add parameter settings.
        $anim = array(
           it_animation(),
           it_animation_delay(),
           it_animation_duration(), 
        );        

        // remove elements.
        $to_remove = array(
            'vc_cta',
            'vc_gmaps',
            'vc_icon',
            'vc_section',
            'vc_images_carousel',
            'vc_tta_pageable',
            'vc_pie',
            'vc_separator',
            'vc_text_separator',
            'vc_message',
            'vc_tabs',
            'vc_tour',
            'vc_accordion'
        );
        
        foreach ( $to_remove as $r ) {
            vc_remove_element( $r );
        }
        
        // remove params from shortcodes.
        vc_remove_param( 'vc_toggle', "style" );
        vc_remove_param( 'vc_toggle', "color" );
        vc_remove_param( 'vc_toggle', "size" );
        vc_remove_param( 'vc_basic_grid', "item" );
        vc_remove_param( 'vc_masonry_grid', "item" );
        
        if ( ! function_exists( 'it_dropdown_cats' ) ) {
            function it_dropdown_cats() {
                $categories_obj = get_categories('hide_empty=0');
                $categories = array();
                foreach ($categories_obj as $pn_cat){
                    $categories[$pn_cat->cat_name] = $pn_cat->category_nicename;
                }  
                $categories = array( esc_html__( "All" , "munza" ) => "" ) + $categories;
                return $categories;
            }
        }
               
        if ( ! function_exists( 'colorCreator' ) ) {
            function colorCreator($colour, $per) {  
                $colour = substr( $colour, 1 ); 
                $rgb = '';
                $per = $per/100*255;
                if ($per < 0 ) { 
                    $per =  abs($per); 
                    for ($x=0;$x<3;$x++) { 
                        $c = hexdec(substr($colour,(2*$x),2)) - $per; 
                        $c = ($c < 0) ? 0 : dechex($c); 
                        $rgb .= (strlen($c) < 2) ? '0'.$c : $c; 
                    }   
                } else { 
                    for ($x=0;$x<3;$x++) {             
                        $c = hexdec(substr($colour,(2*$x),2)) + $per; 
                        $c = ($c > 255) ? 'ff' : dechex($c); 
                        $rgb .= (strlen($c) < 2) ? '0'.$c : $c; 
                    }    
                } 
                return '#'.$rgb; 
            }
        }
        
        if ( ! function_exists( 'itr_editor_buttons' ) ) {
            function itr_editor_buttons( $buttons ) {
                array_unshift( $buttons, 'underline' ); 
                return $buttons;
            }
            add_filter( 'mce_buttons_2', 'itr_editor_buttons' );
        }
        
        if ( ! function_exists( 'shortCodeEnq' ) ) {
            function shortCodeEnq($font){

                $s_font = $font.':100,200,300,400,500,600,700,900,italic';
                
                $font = str_replace( ' ', '+', $font );
                
                if ( ! empty( $font ) ) {
                    
                    $query_args = array(
                        'family' => $s_font,
                        'subset' => 'latin,latin-ext',
                    );
                    
                    $request_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
                    wp_deregister_style( $font );
                    wp_register_style( $font, $request_url, array(),null );
                    wp_enqueue_style( $font );
                } 
            }    
        }
        
        if ( ! function_exists( 'itr_inline_css' ) ) {
            function itr_inline_css( $cssE ){
                $cssE = str_replace(': ', ':', str_replace(';}', '}', str_replace('; ',';',str_replace(' }','}',str_replace(' {', '{', str_replace('{ ','{',str_replace(array("\r\n","\r","\n","\t",'  ','    ','    '),"",preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!','',$cssE))))))));
                wp_enqueue_style ('munza_custom_css', Munza_THM_URI . 'assets/front/css/custom-style.css', array( 'itr-main-style' ) );
                wp_add_inline_style ('munza_custom_css', $cssE);
            }
        }  
        
    }
}

new munza_Core();