<?php
function it_blog_shortcode($atts, $content=null){
 
    extract(shortcode_atts( array(
        'it_category'       => '',
        'blog_style'        => 'large-image',
        'blog_cols'         => '4',
        'tl_sidebar'        => 'left_bar',
        'posts_per_page'    => '10',
        'img_size'          => '',
        'pager_type'        => '1',
        'pg_pos'            => 'centered',
        'el_class'          => '',
        'max_words'         => '40',
        'load_txt'          => 'Load More',
        'show_date'         => '1',
        'show_title'        => '1',
        'show_media'        => '1',
        'show_meta'         => '1',
        'show_except'       => '1',
        'show_socials'      => '1',
        'show_more'         => '',
        'mor_txt'           => 'READ MORE',
        'show_auth'         => '1',
        'posts_exec'        => ''
    ), $atts));
    
    global $post,$paged;
    
    $exec_posts = esc_html($posts_exec);
    $exArray = explode(',', $exec_posts);

    $cont = '';
    $args = array(
        'category_name'     => $it_category,
        'posts_per_page'    => $posts_per_page,
        'post__not_in'      => $exArray,
        'post_type'         => 'post',
        'orderby'           => 'post_date',
        'order'             => 'DESC',
        'post_status'       => 'publish',
        'paged'             => $paged,
    );
    
    $ino_query   = new WP_Query( $args );
    $holder      = itr_theme_option('img_placeholder');
    $morevl      = ($show_more != '') ? "1" : "0";
    $class       = $blog_style.' blog-posts';
    $class      .= ( $el_class != '' ) ? ' '.$el_class : "";
    
    if ( $ino_query->have_posts() ) {
            
        $cont .= '<div id="itr_blog_content" class="'.$class.'">';   
            
            while($ino_query->have_posts()){ 
                $ino_query->the_post();            
                $IDD        = $post->ID;
                $pg_type    = 'list';
                $pos_clas   = 'post-item';
                $pos_clas  .= ( $blog_style != 'masonry' && $blog_style != 'grid' ) ? ' fx' : '';
                $pos_clas  .= ( $blog_style == 'masonry' || $blog_style == 'grid' ) ? " col-md-".$blog_cols : "";
                $pos_clas  .= ( is_sticky( $IDD ) ) ? " sticky" : "";
                $pos_clas  .= ( !get_the_post_thumbnail() && $holder == '' ) ? ' no-holder' : "";
                $itr_format = (get_post_format($post->ID)) ? get_post_format($post->ID) : '';
                $inclass    = ( $itr_format == 'quote' || $itr_format == 'link' ) ? 'main-bg abs_bg' : 'inner_post_item';
                $dataAnim   = ( $blog_style != 'masonry' && $blog_style != 'grid' ) ? ' data-animate="fadeInUp"' : '';
                $cont .= '<article id="post-'.$IDD.'" class="'.$pos_clas.'"'.$dataAnim.'>';
                    
                    $cont .= '<div class="'.$inclass.'">';
                        
                        $cont .= ( $itr_format == 'quote' ) ? '<i class="stline-close-quote abs_qte"></i>' : '';
                        $cont .= ( $itr_format == 'link' ) ? '<i class="stline-hyperlink-2 abs_lnk"></i>' : '';
                        
                        if ( is_sticky() ) {
                            $cont .= '<span class="post-sticky main-bg" title="' . esc_html__( 'Featured', 'munza' ) . '"><i class="outlinefont-Asset-1252"></i></span>';
                        }
                        
                        $cont .= ( $show_media != '') ? munza_post_thumbnail($img_size,$show_media) : "";
                            
                        $cont .= '<div class="post-info">';
                            
                            $cont .= ( $show_date != '' ) ? '<div class="meta_date">' . get_the_date() . '</div>' : '';
                            
                            $cont .= ( $show_title != '' ) ? munza_post_title() : ''; 
                            
                            $cont .= ( $show_meta != '' ) ? munza_post_meta($show_auth) : "";
                            
                            if( $show_except != '' && $itr_format != 'quote' && $itr_format != 'link' ){
                                $cont .= '<div class="entry-content">';
                                    $cont .= munza_post_summary($max_words,$morevl,$mor_txt);
                                    $cont .= ( $show_socials != '' ) ? itr_blog_share($pg_type) : '';
                                $cont .= '</div>';
                            }
                            
                            $cont .= munza_mini_pager();
                                                        
                        $cont .= '</div>';
                        
                    $cont .= '</div>';
                $cont .= '</article>';    
                
            }
                        
        $cont .= '</div>';
        
        $cont .= munza_paging_nav( $ino_query,$pager_type,$pg_pos,$load_txt );
        
    }else{
        $cont .= '<div class="no_posts alert alert-danger t-center">'.__('No posts to be shown!!','munza').'</div>';
    }
    
    if ( $blog_style == 'masonry' || $blog_style == 'grid' ){
        wp_enqueue_script( 'jquery-isotope', ITR_THM_URI . '/assets/js/vendor/isotope.js', array('jquery'), null, true);
    }
    
    wp_reset_postdata();
    
    return $cont;
}                                               
add_shortcode('it_blog', 'it_blog_shortcode');

