<?php
function it_divider_shortcode($atts, $content=null){

    extract(shortcode_atts( array(
        'icon_param'             => '',
        
        'divider_class'          => 'short',
        'divider_color'          => '',
        'el_class'               => '',
        'it_animation'           => '',
        'delay'                  => '',
        'duration'               => '',
        'icon_shape'             => '',
        'icon_align'             => 'left',
        'use_icon'               => '1',
        'div_i_color'            => '',
        'div_bg_color'           => '',
        'div_border_color'       => '',
        'icon_typ'               => 'icon',
        'div_text'               => '',
        'it_bg_img'              => '',
        'div_font_size'          => ''
    ), $atts));
    
    $img_id = preg_replace( '/[^\d]/', '', $it_bg_img );
    $img_src = wp_get_attachment_image_src( $img_id,'full' );
    
    $output = $custom_stle = $iconClass = $ico = $class = '';
    
    $divid = ( $divider_color != '' || $div_i_color != '' || $div_bg_color != '' || $div_border_color != '' || $div_font_size != '' ) ? uniqid( 'divd_' ) : "";
    
    if ( $divider_color != '' ) {
        $custom_stle .= ".{$divid}:before,.{$divid}:after{";
            $custom_stle .= ($divider_color != '') ? "background-color: {$divider_color} !important;" : "";
            $custom_stle .= ( $divider_class == 'double' || $divider_class == 'dotted-sm' || $divider_class == 'dotted-lg' || $divider_class == 'dashed-sm' || $divider_class == 'dashed-lg'  ) ? "border-color: {$divider_color} !important;" : "";
        $custom_stle .= "}";    
    }
    
    if ( $div_i_color != '' || $div_bg_color != '' || $div_border_color != '' || $div_font_size != '' ) {
        $custom_stle .= ".{$divid} i,.{$divid} .icospan{";
            $custom_stle .= ($div_i_color != '') ? "color: {$div_i_color};" : "";
            $custom_stle .= ($div_bg_color != '') ? "background-color: {$div_bg_color};" : "";
            $custom_stle .= ($div_border_color != '') ? "border-color: {$div_border_color};" : "";
            $custom_stle .= ($div_font_size != '') ? "font-size: {$div_font_size}px;" : "";
        $custom_stle .= "}";
    }
    
    itr_inline_css( $custom_stle );    
    
    $class .= 'divider';
    $class .= ( $divider_class != '' ) ? ' '.$divider_class : "";
    $class .= ( $divid != '' ) ? ' '.$divid : "";
    $class .= ( $el_class != '' ) ? ' '.$el_class : "";
    $class .= ( $it_animation != '' ) ? ' fx' : '';
    $class .= ( $icon_align != '' ) ? ' div-'.$icon_align : "";        
    $iconClass .= ( $icon_shape != '' ) ? ' '.$icon_shape : "";
    $iconClass .= ( $icon_align != '' ) ? ' '.$icon_align : "";
    $iconClass .= ( $div_bg_color != '' ) ? " filled" : "";
    $iconClass .= ( $div_border_color != '' ) ? " bordered" : "";
        
    if($use_icon == '1'){
        if( $icon_typ == 'icon' ){
            $iconClass .= ' ' . $icon_param;
            $ico = '<i class="'.$iconClass.'"></i>';
        } else if( $icon_typ == 'text' ){
            $iconClass .= ' icospan';
            $ico = '<span class="'.$iconClass.'">'.$div_text.'</span>';
        } if( $icon_typ == 'img' ){
            $iconClass .= ' icospan ';
            $ico = '<img class="'.$iconClass.'" src="'.$img_src[0].'" alt="" />';
        }
        
    }
        
    // animation styling...
    $data_anim = ($it_animation != '') ? ' data-animate="'.esc_js($it_animation).'"' : '';
    $data_dur = ($duration != '') ? ' data-animation-duration="'.esc_js($duration).'"' : '';
    $data_del = ($delay != '') ? ' data-animation-delay="'.esc_js($delay).'"' : '';
    $animation = $data_anim.$data_del.$data_dur;

    $output = '<div class="'.$class.'" '.$animation.'>';
    if( $divider_class != 'gradAnim' && $use_icon == '1' ){
        $output .= $ico;
    }
    
    $output .='</div>';
        
    return $output; 
 
}
add_shortcode('it_divider', 'it_divider_shortcode');