<?php 
function it_gmap_shortcode($atts, $content=null){
    global $allowedposttags;
    extract(shortcode_atts( array(
        'no_scroll'        => '',
        'el_class'         => '',
        'gmap_zoom'        => '12',
        'map_color'        => '#e7512f',
        'gmap_icon'        => '',
        'gmap_latitude'    => '',
        'gmap_longitude'   => '',
        'gmap_address'     => '',
        'gmap_html'        => '',
        'gmap_key'         => '',
        'gmap_height'      => '500'
    ), $atts));
    $hit = '';
    
    $img_id = preg_replace( '/[^\d]/', '', $gmap_icon );
    $img_src = wp_get_attachment_image_src( $img_id,'full' );
    
    $ico = ( $img_src != '' ) ? $img_src[0] : get_template_directory_uri().'/assets/images/gmap_pin.png';
    
    wp_enqueue_script( 'google-maps-api', '//maps.googleapis.com/maps/api/js?key=' . sanitize_text_field( $gmap_key ),null,null,false );
    wp_enqueue_script ( 'gmap', Munza_THM_URI . 'assets/front/js/vendor/jquery.gmap.min.js', null, null, true );
    
    wp_print_scripts( 'google-maps-api' );
    wp_print_scripts( 'google-maps' );
    

    $gmap_scroll = ($no_scroll != '') ? 'false' : 'true';
    
    if ($gmap_height != ''){
        $hit = 'height: '.$gmap_height.'px;';
    } 
    
    $map_id = uniqid( 'wp_gmaps_' );
    
    $output = '<div class="'.$el_class.'" id="'.esc_attr( $map_id ).'" style="'.$hit.'width: 100%;"></div>';          
           
    ?>
    <script type="text/javascript"> 

         jQuery(window).on("load", function(){   
            
            var mapOptions = {
                zoom: <?php echo esc_attr($gmap_zoom); ?>,
                scrollwheel: <?php echo esc_attr($gmap_scroll); ?>,
                center: new google.maps.LatLng('<?php echo esc_attr($gmap_latitude); ?>', '<?php echo esc_attr($gmap_longitude); ?>'),
                styles: [{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"color":"#444444"}]},{"featureType":"landscape","elementType":"all","stylers":[{"color":"#f2f2f2"}]},{"featureType":"poi","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"all","stylers":[{"saturation":-100},{"lightness":45}]},{"featureType":"road.highway","elementType":"all","stylers":[{"visibility":"simplified"}]},{"featureType":"road.arterial","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"all","stylers":[{"color":"<?php echo $map_color; ?>"},{"visibility":"on"}]}]
            };

            var mapElement = document.getElementById('<?php echo esc_attr( $map_id ); ?>');
            var map = new google.maps.Map(mapElement, mapOptions);
            var marker = new google.maps.Marker({
                position: new google.maps.LatLng('<?php echo esc_attr($gmap_latitude); ?>', '<?php echo esc_attr($gmap_longitude); ?>'),
                map: map,
                icon: "<?php echo esc_attr($ico); ?>",
                title: '<?php echo esc_textarea($gmap_address); ?>'
            }); 
        });    
    </script> 
    <?php      
    return $output; 
    
    
}
add_shortcode('it_gmap', 'it_gmap_shortcode');