<?php 
function it_heading_shortcode($atts, $content=null){

    extract(shortcode_atts( array(
        
        'heading_style'     => 'main',
        'heading_align'     => 'left',
        'margin_top'        => '',
        'margin_bottom'     => '',
        
        'it_animation'      => '',
        'delay'             => '',
        'duration'          => '',
        
        'tag'               => 'h3',
        'size'              => '',
        'letter_spacing'    => '',
        'line_height'       => '',
        'font_weight'       => '',
        'family'            => '',
        'head1_shad_color'  => '',

        'el_class'          => ''
        
    ), $atts));
    
    $output = $custom_stle = '';
    
    $headid = ( $margin_top || $margin_bottom || $family || $size || $letter_spacing || $line_height || $font_weight || $head1_shad_color ) ? uniqid( 'head_' ) : "";
        
    if( $margin_top || $margin_bottom || $family || $size || $letter_spacing || $line_height || $font_weight ){
        $custom_stle .= ".{$headid}{";
            $custom_stle .= ( $margin_top != '' )     ? "margin-top: {$margin_top}px !important;"         : "";    
            $custom_stle .= ( $margin_bottom != '' )  ? "margin-bottom: {$margin_bottom}px !important;"   : "";
            $custom_stle .= ( $family != '' )         ? "font-family: {$family};"                         : "";
            $custom_stle .= ( $size != '' )           ? "font-size: {$size}px;"                           : "";
            $custom_stle .= ( $letter_spacing != '' ) ? "letter-spacing: {$letter_spacing}px;"            : "";
            $custom_stle .= ( $line_height != '' )    ? "line-height: {$line_height}px;"                  : "";
            $custom_stle .= ( $font_weight != '' )    ? "font-weight: {$font_weight};"                    : "";
        $custom_stle .= "}";
    }
    
    if ( $heading_style == 'main' && $head1_shad_color != '' ) {
        $custom_stle .= ".{$headid}.main:after{";
            $custom_stle .= "color: {$head1_shad_color};";
        $custom_stle .= "}";    
    }
        
    itr_inline_css( $custom_stle );
        
    $class = 'itr-heading';
    $class .= ' '.$heading_style;
    $class .= ( $it_animation != '' )       ? " fx" : "";
    $class .= ( $headid != '' )             ? " ".$headid : "";
    $class .= ( $heading_align != '' )      ? " ".$heading_align : "";
    $class .= ( $el_class != '' )           ? " ".$el_class : "";
        
    shortCodeEnq($family);
        
    // animation styling...
    $data_anim = ($it_animation != '') ? ' data-animate="'.esc_js($it_animation).'"' : '';
    $data_dur = ($duration != '') ? ' data-animation-duration="'.esc_js($duration).'"' : '';
    $data_del = ($delay != '') ? ' data-animation-delay="'.esc_js($delay).'"' : '';
    $animation = $data_anim.$data_del.$data_dur;
    
    $tagcontent = wp_kses($content,itr_allowed_tags(),null);
    $txttag = strip_tags($tagcontent);
            
    // headings...
    if( $tagcontent != ''){
        $output .= "<{$tag} class='{$class}'{$animation}>";
            $output .= $tagcontent;
        $output .= "</{$tag}>";
    }
            
    return $output; 
 
}
add_shortcode('it_heading', 'it_heading_shortcode');
