<?php
class WPBakeryShortCode_it_icbox extends WPBakeryShortCode {
    
    public function __construct(){
        add_shortcode('it_iconbox', array(&$this, 'it_iconbox_shortcode'));     
    }
    
    public function it_iconbox_shortcode($atts, $content=null){
        global $allowedposttags;
        extract(shortcode_atts( array(
            
            'icon_param'                => 'outlinefont-Asset-180',
            
            'icbx_align'                => 'text-center',
            'padd_top'                  => '',
            'padd_right'                => '',
            'padd_bottom'               => '',
            'padd_left'                 => '',
            'marg_top'                  => '',
            'marg_right'                => '',
            'marg_bottom'               => '',
            'marg_left'                 => '',
            'border_width'              => '',
            'border_color'              => '',
            'border_style'              => '',
            'border_radius'             => '',
            'icbx_bg'                   => 'color',
            'icbx_bg_color'             => '',
            'icbx_bg_grad'              => '',
            'reverse_content'           => '',
            
            'box_shadow'                => '',
            'hover_shadow'              => '',
            'border_hover_width'        => '',
            'border_hover_color'        => '',
            'border_hover_radius'       => '',
            'icbx_hover_bg'             => 'color',
            'icbx_hover_bg_color'       => '',
            'icbx_hover_bg_grad'        => '',
            
            'it_animation'              => '',
            'filter'                    => true,
            'delay'                     => '',
            'duration'                  => '',
            
            'icbx_cust_shape'           => '',
            'icbx_title'                => 'Icon Box Title',
            'icbx_title_tag'            => 'h4',
            'title_size'                => '',
            'icbx_title_weight'         => '',
            'icbx_title_color'          => '',
            'icbx_title_hover_color'    => '',
            'icbx_subtitle'             => '',
            'icbx_subtitle_tag'         => 'h6',
            'subtitle_size'             => '',
            'icbx_subtitle_weight'      => '',
            'icbx_subtitle_color'       => '',
            'icbx_subtitle_bg_color'    => '',
            'icbx_sub_hover_color'      => '',
            'icbx_sub_hover_bg_color'   => '',
            'icbx_sub_marg_top'         => '',
            'icbx_sub_marg_right'       => '',
            'icbx_sub_marg_bottom'      => '',
            'icbx_sub_marg_left'        => '',
            
            'content_hover_color'       => '',
            'use_icon'                  => '1',
            'icon_position'             => 'itr_block_icn',
            'icon_align'                => 'center',
            'icon_size'                 => '',
            'icon_font_size'            => '',
            'icon_color'                => '',
            'icon_bg_color'             => '',
            'icon_border_color'         => '',
            'icon_border_width'         => '',
            'icon_border_style'         => '',
            'icon_hover_color'          => '',
            'icon_hover_bg_color'       => '',
            'icon_hover_border_color'   => '',
            'icon_border_rad'           => '',
            'icon_hover_border_rad'     => '',
            'icon_shadow'               => '',
            'icon_typ'                  => '',
            'icon_text'                 => '',
            'icon_image'                => '',
            'icbx_link'                 => '',
            'icon_height'               => '',
            'icon_width'                => '',
            'rel'                       => '',
            
            'show_more'                 => '',
            'more_text'                 => 'Read More',
            'more_size'                 => 'btn-sm',
            'more_align'                => 'centered',
            'more_color'                => '',
            'more_border_color'         => '',
            'more_hover_color'          => '',
            'more_show_hover'           => '',
            
            'el_class'                  => '',
            
        ), $atts));
        
        $output = $moreoutput = $iconClass = $icon_alt = $cr_cicle = $custom_stle = $icol = $icon = $mc = $mb = $mg = $tcol = $ifont = $tscol = $icss = $i_bgcol = $mstyle = $istyle = $isize = $atss = '';
        
        $boxid = uniqid( 'icbx_' );
        $icon_border_width = ( $icon_border_width != '' ) ? $icon_border_width : '1';
        
        //$grd = "background:".esc_textarea($icbx_bg_grad).";";
        
        $svgid = uniqid('svg-', '');
        $grd = esc_textarea($icbx_bg_grad);
        $on = strstr($grd, '#');
        $fist_hx = substr($on, 0, 7);
        
        $str2 = substr($on, 7);
        $needle = strstr($str2, '#'); 
        $sec_hx = substr($needle, 0, 7);
        
        $svghovid = uniqid('svghov-', '');
        $grd2 = esc_textarea($icbx_hover_bg_grad);
        $on2 = strstr($grd2, '#');
        $fist_hx2 = substr($on2, 0, 7);
        
        $str22 = substr($on2, 7);
        $needle2 = strstr($str22, '#'); 
        $sec_hx2 = substr($needle2, 0, 7);
        
        if (strpos($grd, 'radial') !== false) {
            $grdtype = 'radial';
        } else {
            $grdtype = 'linear';
        }
        
        if (strpos($grd2, 'radial') !== false) {
            $grdhovtype = 'radial';
        } else {
            $grdhovtype = 'linear';
        }
        
        // main box
        if( $padd_top || $padd_right || $padd_bottom || $padd_left || $marg_top || $marg_right || $marg_bottom || $marg_left || $icbx_bg_color || $border_width || $border_style || $border_color || $border_radius  ){
            
            $custom_stle .= ".{$boxid}{";
                $custom_stle .= ( $padd_top != '' ) ? "padding-top: {$padd_top}px;" : "";
                $custom_stle .= ( $padd_right != '' ) ? "padding-right: {$padd_right}px;" : "";
                $custom_stle .= ( $padd_bottom != '' ) ? "padding-bottom: {$padd_bottom}px;" : "";
                $custom_stle .= ( $padd_left != '' ) ? "padding-left: {$padd_left}px;" : "";
                $custom_stle .= ( $marg_top != '' ) ? "margin-top: {$marg_top}px;" : "";
                $custom_stle .= ( $marg_right != '' ) ? "margin-right: {$marg_right}px;" : "";
                $custom_stle .= ( $marg_bottom != '' ) ? "margin-bottom: {$marg_bottom}px;" : "";
                $custom_stle .= ( $marg_left != '' ) ? "margin-left: {$marg_left}px;" : "";
                $custom_stle .= ( $border_color != '' && $icbx_cust_shape == '' ) ? "border-color: {$border_color};" : "";
                $custom_stle .= ( $border_radius != '' && $icbx_cust_shape == '' ) ? "border-radius: {$border_radius}px;" : "";
                $custom_stle .= ( $border_style != '' && $icbx_cust_shape == '' ) ? "border-style: {$border_style};" : "";
                $custom_stle .= ( $border_width != '' && $icbx_cust_shape == '' ) ? "border-width: {$border_width}px;" : "";
                $custom_stle .= ( $icbx_bg_color != '' && $icbx_bg == 'color' && $icbx_cust_shape == '' ) ? "background-color: {$icbx_bg_color};" : "";
                $custom_stle .= ( $icbx_bg_grad != '' && $icbx_bg == 'gradient' && $icbx_cust_shape == '' ) ? "background: {$grd};" : "";
            $custom_stle .= "}";
            
        }
        
        if( $icbx_cust_shape != '' && ( $icbx_bg_color != '' || $icbx_bg_grad != '' || $border_width != '' ) ){
            $custom_stle .= ".{$boxid} > svg.slurve-svg,.{$boxid} > svg.slurve-svg path{";
                $custom_stle .= ( $icbx_bg_color != '' && $icbx_bg == 'color' ) ? "fill: {$icbx_bg_color};" : "";
                $custom_stle .= ( $icbx_bg_grad != '' && $icbx_bg == 'gradient' ) ? "fill: url(#{$svgid});" : "";
                $custom_stle .= ( $icbx_bg_color == '' && $icbx_bg_grad == '' ) ? "fill: none;" : "";
                $custom_stle .= ( $border_color != '' ) ? "stroke: {$border_color};" : "";
                $custom_stle .= ( $border_width != '' ) ? "stroke-width: {$border_width}px;" : "";
            $custom_stle .= "}";    
        } 
            

        // main box hover
        if( $border_hover_color || $border_hover_width ){
            
            $custom_stle .= ".{$boxid}:hover{";
                $custom_stle .= ( $border_hover_color != '' ) ? "border-color: {$border_hover_color} !important;" : "";
                $custom_stle .= ( $border_hover_width != '' && $icbx_cust_shape == '' ) ? "border-width: {$border_hover_width}px;" : "";
                $custom_stle .= ( $icbx_cust_shape == '' ) ? "border-style: {$bord_style} !important;" : "";
            $custom_stle .= "}";    
            
            $custom_stle .= ".{$boxid}:hover .box_content:before,.{$boxid}:hover .box_content:after,.{$boxid}:hover .box_content,.{$boxid}:hover .box_content{";
                $custom_stle .= ($icbx_hover_border_color != '') ? "border-color: {$icbx_hover_border_color};" : "";
            $custom_stle .= "}";
            
        }
        
        if( $icbx_cust_shape != '' && ( $icbx_hover_bg_color != '' || $icbx_hover_bg_grad != '' || $border_hover_width != '' ) ){
            $custom_stle .= ".{$boxid}:hover > .slurve-svg,.{$boxid}:hover > .slurve-svg path{";
                $custom_stle .= ( $icbx_hover_bg_color != '' && $icbx_hover_bg == 'color' ) ? "fill: {$icbx_hover_bg_color};" : "";
                $custom_stle .= ( $icbx_hover_bg_grad != '' && $icbx_hover_bg == 'gradient' ) ? "fill: url(#{$svghovid});" : "";
                $custom_stle .= ( $border_hover_color != '' ) ? "stroke: {$border_hover_color};" : "";
                $custom_stle .= ( $border_hover_width != '' ) ? "stroke-width: {$border_hover_width};" : "";
            $custom_stle .= "}";    
        }
        
        // title
        if( $icbx_title_color != '' || $icbx_title_hover_color != '' || $title_size != '' || $icbx_title_weight != '' ){
            $custom_stle .= ".{$boxid} .box_title{";
                $custom_stle .= ( $icbx_title_color != '' ) ? "color: {$icbx_title_color};" : "";
                $custom_stle .= ( $title_size != '' ) ? "font-size: {$title_size}px;" : "";
                $custom_stle .= ( $icbx_title_weight != '' ) ? "font-weight: {$icbx_title_weight};" : "";
            $custom_stle .= "}";
            
            $custom_stle .= ".{$boxid}:hover .box_title{";
                $custom_stle .= ( $icbx_title_hover_color != '' ) ? "color: {$icbx_title_hover_color};" : "";
            $custom_stle .= "}";
            
            $custom_stle .= ".{$boxid} .box_title a{";
                $custom_stle .= ( $icbx_title_color != '' ) ? "color: {$icbx_title_color};" : "";
            $custom_stle .= "}";
            
            $custom_stle .= ".{$boxid}:hover .box_title a{";
                $custom_stle .= ( $icbx_title_hover_color != '' ) ? "color: {$icbx_title_hover_color};" : "";
            $custom_stle .= "}";
        }

        // sub title
        if( $icbx_subtitle_color != '' || $icbx_subtitle_bg_color != '' || $icbx_sub_hover_color != '' || $icbx_sub_hover_bg_color != '' || $subtitle_size != '' || $icbx_subtitle_weight != '' || $icbx_sub_marg_top != '' || $icbx_sub_marg_right != '' || $icbx_sub_marg_bottom != '' || $icbx_sub_marg_left != '' ){
            $custom_stle .= ".{$boxid} .box_subtitle{";
                $custom_stle .= ($icbx_subtitle_color != '') ? "color: {$icbx_subtitle_color};" : "";
                $custom_stle .= ($subtitle_size != '') ? "font-size: {$subtitle_size}px;" : "";
                $custom_stle .= ($icbx_subtitle_weight != '') ? "font-weight: {$icbx_subtitle_weight};" : "";
                $custom_stle .= ($icbx_subtitle_bg_color != '') ? "background-color: {$icbx_subtitle_bg_color};" : "";
                $custom_stle .= ($icbx_sub_marg_top != '') ? "margin-top: {$icbx_sub_marg_top}px;" : "";
                $custom_stle .= ($icbx_sub_marg_right != '') ? "margin-right: {$icbx_sub_marg_right}px;" : "";
                $custom_stle .= ($icbx_sub_marg_bottom != '') ? "margin-bottom: {$icbx_sub_marg_bottom}px;" : "";
                $custom_stle .= ($icbx_sub_marg_left != '') ? "margin-left: {$icbx_sub_marg_left}px;" : "";
                $custom_stle .= "}";
            $custom_stle .= ".{$boxid}:hover .box_subtitle{";
                $custom_stle .= ($icbx_sub_hover_color != '') ? "color: {$icbx_sub_hover_color};" : "";
                $custom_stle .= ($icbx_sub_hover_bg_color != '') ? "background-color: {$icbx_sub_hover_bg_color};" : "";
            $custom_stle .= "}";
        }

        // content hover color
        if( $content_hover_color != '' ){
            $custom_stle .= ".{$boxid}:hover .box_text,.{$boxid}:hover .box_text span{";
                $custom_stle .= ($content_hover_color != '') ? "color: {$content_hover_color} !important;" : "";
            $custom_stle .= "}";
        }

        // icon        
        if( $icon_color || $icon_bg_color || $icon_border_color || $icon_border_width || $icon_border_style || $icon_border_rad || $icon_font_size || $icon_width || $icon_height || $icon_hover_color || $icon_hover_bg_color || 
        $icon_hover_border_color || $icon_hover_border_rad  ){
            $custom_stle .= ".{$boxid} .box_icon{";
            
                $custom_stle .= ( $icon_color != '' ) ? "color: {$icon_color};" : "";
                $custom_stle .= ( $icon_bg_color != '' ) ? "background-color: {$icon_bg_color};" : "";
                $custom_stle .= ( $icon_border_color != '' ) ? "border-color: {$icon_border_color};" : "";
                $custom_stle .= ( $icon_border_width != '' ) ? "border-width: {$icon_border_width}px;" : "";
                $custom_stle .= ( $icon_border_style != '' ) ? "border-style: {$icon_border_style};" : "";
                $custom_stle .= ( $icon_border_rad != '' ) ? "border-radius: {$icon_border_rad}px;"    : "";
                $custom_stle .= ( $icon_font_size != '' ) ? "font-size: {$icon_font_size}px !important;" : "";                  
                $custom_stle .= ( $icon_size == 'custom' && $icon_width != '' ) ? "width: {$icon_width}px !important;" : "";
                $custom_stle .= ( $icon_size == 'custom' && $icon_width != '' ) ? "--width: {$icon_width}px !important;" : "";
                $custom_stle .= ( $icon_size == 'custom' && $icon_height != '' ) ? "height: {$icon_height}px !important;" : "";
                $custom_stle .= ( $icon_size == 'custom' && $icon_height != '' ) ? "--height: {$icon_height}px !important;" : "";
                $custom_stle .= ( $icon_border_width != '' ) ? "line-height: calc(var(--height) - {$icon_border_width}px) !important;" : "";
                
            $custom_stle .= "}";
                                  
            $custom_stle .= ".{$boxid}:hover .box_icon{";
                $custom_stle .= ( $icon_hover_color != '' ) ? "color: {$icon_hover_color};" : "";
                $custom_stle .= ( $icon_hover_bg_color != '' ) ? "background-color: {$icon_hover_bg_color};" : "";
                $custom_stle .= ( $icon_hover_border_color != '' ) ? "border-color: {$icon_hover_border_color};"     : "";
                $custom_stle .= ( $icon_hover_border_rad != '' ) ? "border-radius: {$icon_hover_border_rad}px;"    : "";
            $custom_stle .= "}";
            
        }
        
        // read more
        if( $more_color || $more_border_color || $more_hover_color ){
            $custom_stle .= ".{$boxid} .box_more{";
                $custom_stle .= ($more_color != '') ? "color: {$more_color};" : "";
            $custom_stle .= "}";
            $custom_stle .= ".{$boxid} .box_more:hover{";
                $custom_stle .= ($more_hover_color != '') ? "color: {$more_hover_color};" : "";
            $custom_stle .= "}";
            $custom_stle .= ".{$boxid} .box_more:hover:after,.{$boxid} .box_more:hover:before{";
                $custom_stle .= ($more_border_color != '') ? "border-color: {$more_border_color};" : "";
            $custom_stle .= "}";
        }    
        
        itr_inline_css( $custom_stle );
        
        $link = $icbx_link;
        $url = vc_build_link( $link );
        if ( ! empty( $url['rel'] ) ) {
            $rel = ' rel="' . esc_attr( $url['rel'] ) . '"';
        } 

        $iconClass = $icon_param;
        
        $icon_class = 'box_icon';
        $icon_class .= ( $icon_typ != 'image' && $icon_size != '' ) ? ' ' . $icon_size : '';
        $img_output = '';                
        if ( $icon_typ == 'text' ) {
            $icon = '<span>'.$icon_text.'</span>';
            $icon_class .= ' ic-txt';
        } else if ( $icon_typ == 'image' ){
            $img_id = preg_replace( '/[^\d]/', '', $icon_image );
            $img = wpb_getImageBySize( array( 'attach_id' => $img_id, 'thumb_size' => 'full' ) );
            $filename = $img['p_img_large'][0];
            $ext = pathinfo($filename, PATHINFO_EXTENSION);
            
            if( $ext == 'svg' ){
                $find_string   = '<svg';
                $position = strpos($filename, $find_string);

                $svg_file_new = substr($filename, $position);

                $img_output = file_get_contents($svg_file_new);
            } else {
                $img_output = $img['thumbnail']; 
            }
            
            $icon_class .= ' ic-img';
            $icon = '<span>'.$img_output.'</span>';
        } else {
            $icon = "<i class='{$iconClass}'></i>";
        }
        
        if ( $show_more == '1' ) {
            $more = " href='" . esc_attr( $url['url'] ) . $rel . "' title='" . esc_attr( $url['title'] ) . "' target='" . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . "'";
            $mtxt = esc_attr( $more_text );
            $moreoutput .= "<a class='btn box_more {$more_align} {$more_size}'{$more}>{$mtxt}</a>";
        }   

        // animation styling...
        $data_anim = ($it_animation != '') ? ' data-animate="'.esc_js($it_animation).'"' : '';
        $data_dur = ($duration != '') ? ' data-animation-duration="'.esc_js($duration).'"' : '';
        $data_del = ($delay != '') ? ' data-animation-delay="'.esc_js($delay).'"' : '';
        $animation = $data_anim.$data_del.$data_dur;
        
        $boxClass = 'itr-icon-box';
        $boxClass .= ' '.$boxid;
        $boxClass .= ( $icon_position != '') ? ' ' . $icon_position : '';
        $boxClass .= ( $reverse_content != '') ? ' itr-reverse-box' : '';
        $boxClass .= ( $el_class != '' ) ? ' '.$el_class : '';
        $boxClass .= ( $box_shadow != '' ) ? ' icbx-shad' : '';
        $boxClass .= ( $hover_shadow != '' ) ? ' icbx-hover-shad' : '';
        $boxClass .= ( $icon_align != '' ) ? ' icon-'.$icon_align : '';
        $boxClass .= ( $icon_position == 'block_icon' ) ? ' bl_icbx' : "";
        $boxClass .= ( $it_animation != '' ) ? ' fx' : '';
        $boxClass .= ( $icbx_align != '' ) ? ' '.$icbx_align : '';
        $boxClass .= ( $more_show_hover == '1' && $show_more == '1' ) ? ' hidden_more' : '';
        $boxClass .= ( $border_style == 'dashed' || $border_style == 'dotted' ) ? ' dashed_border' : '';
        $boxClass .= ( $icbx_cust_shape != '' ) ? ' slurve' : '';
        
        $subClass = ($icbx_subtitle_bg_color != '') ? ' sub_pad' : '';
        
        if( $icbx_cust_shape != '' ){
            if ( $icbx_bg_grad != '' || $icbx_bg_color != '' || $border_width != '' ) {
                if ( $icbx_cust_shape == 'btn1' ) {
                    $atss .= ' data-slurve="0,-25,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.'"'; 
                } else if ( $icbx_cust_shape == 'btn2' ) {
                    $atss .= ' data-slurve="0,0,'.$border_radius.' 0,-25,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.'"'; 
                } else if ( $icbx_cust_shape == 'btn3' ) {
                    $atss .= ' data-slurve="0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,-25,'.$border_radius.' 0,0,'.$border_radius.'"';
                } else if ( $icbx_cust_shape == 'btn4' ) {
                    $atss .= ' data-slurve="0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,-25,'.$border_radius.'"';  
                }    
            } else {
                if( $icbx_bg_color !='' || $icbx_bg_grad !='' || $icbx_hover_bg_color !='' || $icbx_hover_bg_grad !='' ){
                    $atss .= ' data-slurve="0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.' 0,0,'.$border_radius.'"';  
                }
            }    
        }
                

        // begin icon boxes...
        $output .= "<div class='{$boxClass}'{$animation}{$atss}>";
            
            if( $icbx_bg_grad != '' && $icbx_bg == 'gradient' ){
                $output .= '<svg version="1.1" class="slurve-definitions" xmlns="http://www.w3.org/2000/svg">';
                    $output .= '<defs>';
                        $output .= '<'.$grdtype.'Gradient id="'.$svgid.'" gradientTransform="rotate(0)">';
                            $output .= '<stop offset="0%" stop-color="'.$fist_hx.'" />';
                            $output .= '<stop offset="100%" stop-color="'.$sec_hx.'" />';
                        $output .= '</'.$grdtype.'Gradient>';
                    $output .= '</defs>';
                $output .= '</svg>';    
            }
            
            if( $icbx_hover_bg_grad != '' && $icbx_hover_bg == 'gradient' ){
                $output .= '<svg version="1.1" class="slurve-definitions" xmlns="http://www.w3.org/2000/svg">';
                    $output .= '<defs>';
                        $output .= '<'.$grdhovtype.'Gradient id="'.$svghovid.'" gradientTransform="rotate(0)">';
                            $output .= '<stop offset="0%" stop-color="'.$fist_hx2.'" />';
                            $output .= '<stop offset="100%" stop-color="'.$sec_hx2.'" />';
                        $output .= '</'.$grdhovtype.'Gradient>';
                    $output .= '</defs>';
                $output .= '</svg>';    
            }
            
            if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
                $box_title = '<a href="' . esc_attr( $url['url'] ) . '" ' . $rel . ' title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_html($icbx_title).'</a>';
            } else {
                $box_title = esc_html( $icbx_title );
            }
                    
            if ( $use_icon == '1' && $icon_position != 'itr_inline_icn' ) {
                $output .= "<div class='{$icon_class}'>";
                    $output .= $icon;
                $output .= "</div>";
            }
            
            $output .= "<div class='box_content'>";
                
                if ( $icbx_title != '' ) {
                    $output .= "<{$icbx_title_tag} class='box_title'>";
                        if ( $use_icon == '1' && $icon_position == 'itr_inline_icn' ) {
                            $output .= "<span class='{$icon_class}'>{$icon}</span>";
                        }
                        $output .= $box_title;
                    $output .="</{$icbx_title_tag}>";
                }
                
                if ( $icbx_subtitle != '' ) {
                    $output .= "<{$icbx_subtitle_tag} class='box_subtitle{$subClass}'>".esc_html($icbx_subtitle)."</{$icbx_subtitle_tag}>";    
                }
                
                if ( $content != '' ) {
                    $output .= '<p class="box_text">'.wp_kses( $content, $allowedposttags, null ).'</p>';
                }
                
                $output .= $moreoutput;
                                
            $output .= '</div>';
                                                
        $output .= '</div>'; 
         
        return $output; 
     
    }

}

new WPBakeryShortCode_it_icbox;
