<?php 
function it_img_compare_shortcode($atts, $content=null){
    global $cl_style;
    extract(shortcode_atts( array(
        'image'             => '',
        'sec_image'         => '',
        'img_size'          => 'full', 
        'main_text'         => 'Original',
        'second_text'       => 'Modified',
        'div_width'         => '',
        'div_bg_color'      => '',
        'div_act_bg_color'  => '',
        'circ_bg_color'     => '',
        'txt_color'         => '',
        'sec_txt_color'     => '',
        'txt_size'          => '',
        'sec_txt_size'      => '',
        'circ_act_bg_color' => '',
        'it_animation'      => '',
        'delay'             => '',
        'duration'          => '',
        'start_point'       => '50',
        'el_class'          => ''
    ), $atts));
    
    $img_id = preg_replace( '/[^\d]/', '', $image );
    $img = wpb_getImageBySize( array( 'attach_id' => $img_id, 'thumb_size' => $img_size ) );
    $img_output = $img['thumbnail'];
    
    $sec_img_id = preg_replace( '/[^\d]/', '', $sec_image );
    $sec_img = wpb_getImageBySize( array( 'attach_id' => $sec_img_id, 'thumb_size' => $img_size ) );
    $sec_img_output = $sec_img['thumbnail'];
    
    $slid = uniqid( 'sld_' );
    $custom_stle = '';
        
    $custom_stle .= "#{$slid} .cp-img-compare-handle{";
        $custom_stle .= ($div_width != '') ? "width: {$div_width}px;" : "";
        $custom_stle .= ($div_width != '') ? "height: {$div_width}px;" : "";
        $custom_stle .= ($div_bg_color != '') ? "background-color: {$div_bg_color};" : "";
    $custom_stle .= "}";
        
    $custom_stle .= "#{$slid} .cp-img-compare-label.mainlbl{";
        $custom_stle .= ($txt_color != '') ? "color: {$txt_color};" : "";
        $custom_stle .= ($txt_size != '') ? "font-size: {$txt_size}px;" : "";
    $custom_stle .= "}";
    
    $custom_stle .= "#{$slid} .cp-img-compare-label.seclbl{";
        $custom_stle .= ($sec_txt_color != '') ? "color: {$sec_txt_color};" : "";
        $custom_stle .= ($sec_txt_size != '') ? "font-size: {$sec_txt_size}px;" : "";
    $custom_stle .= "}";
    
    $custom_stle .= "#{$slid} .cp-img-compare-handle.draggable{";
        $custom_stle .= ($div_act_bg_color != '') ? "background-color: {$div_act_bg_color};" : "";
    $custom_stle .= "}";
    
    $custom_stle .= "#{$slid} .cp-img-compare-handle i{";
        $custom_stle .= ($circ_bg_color != '') ? "background-color: {$circ_bg_color};" : "";
    $custom_stle .= "}";
    
    $custom_stle .= "#{$slid} .cp-img-compare-handle.draggable i{";
        $custom_stle .= ($circ_act_bg_color != '') ? "background-color: {$circ_act_bg_color};" : "";
    $custom_stle .= "}";
    
    if ( $start_point != '' ) {
        $custom_stle .= "#{$slid}.is-visible .cp-img-compare-resize{";
            $custom_stle .= "width: {$start_point}%;";
            $custom_stle .= "-webkit-animation: {$slid}-bounce-in 0.7s;";
            $custom_stle .= "animation: {$slid}-bounce-in 0.7s;";
        $custom_stle .= "}";
                
        $custom_stle .= "#{$slid}.is-visible .cp-img-compare-handle{";
            $custom_stle .= "left: {$start_point}%;";
        $custom_stle .= "}";
        
        $custom_stle .= "@-webkit-keyframes {$slid}-bounce-in {0% {width: 0;}100% {width: {$start_point}%;}}@keyframes {$slid}-bounce-in {0% {width: 0;}100% {width: {$start_point}%;}}";
    }
    
    itr_inline_css( $custom_stle );
    
    $class = 'cp-img-compare-container';
    $class .= ( $el_class != '' ) ? ' '.$el_class : "";
    $class .= ( $it_animation != '' ) ? ' fx' : '';
    
    // animation styling...
    $data_anim = ($it_animation != '') ? ' data-animate="'.esc_js($it_animation).'"' : '';
    $data_dur = ($duration != '') ? ' data-animation-duration="'.esc_js($duration).'"' : '';
    $data_del = ($delay != '') ? ' data-animation-delay="'.esc_js($delay).'"' : '';
    $animation = $data_anim.$data_del.$data_dur;
    
    $output = '<figure class="'.$class.'" id="'.$slid.'"'.$animation.'>';
        $output .= $img_output;
        $output .= '<span class="cp-img-compare-label mainlbl" data-type="original">'.esc_html($main_text).'</span>';

        $output .= '<div class="cp-img-compare-resize">';
            $output .= $sec_img_output;
            $output .= '<span class="cp-img-compare-label seclbl" data-type="modified">'.esc_html($second_text).'</span>';
        $output .= '</div>';

        $output .= '<span class="cp-img-compare-handle"><i></i></span>';
    $output .= '</figure>'; 
    
    wp_enqueue_script ( 'compare.slider' );
    wp_enqueue_style ( 'compare-slider' );         
          
    return $output; 
 
}

add_shortcode('it_img_compare', 'it_img_compare_shortcode');